@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.LocalGatewayRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Local Gateway Route. More information can be found in the [Outposts User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#routing).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.LocalGatewayRoute("example", {
 *     destinationCidrBlock: "172.16.0.0/16",
 *     localGatewayRouteTableId: exampleAwsEc2LocalGatewayRouteTable.id,
 *     localGatewayVirtualInterfaceGroupId: exampleAwsEc2LocalGatewayVirtualInterfaceGroup.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.LocalGatewayRoute("example",
 *     destination_cidr_block="172.16.0.0/16",
 *     local_gateway_route_table_id=example_aws_ec2_local_gateway_route_table["id"],
 *     local_gateway_virtual_interface_group_id=example_aws_ec2_local_gateway_virtual_interface_group["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.LocalGatewayRoute("example", new()
 *     {
 *         DestinationCidrBlock = "172.16.0.0/16",
 *         LocalGatewayRouteTableId = exampleAwsEc2LocalGatewayRouteTable.Id,
 *         LocalGatewayVirtualInterfaceGroupId = exampleAwsEc2LocalGatewayVirtualInterfaceGroup.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewLocalGatewayRoute(ctx, "example", &ec2.LocalGatewayRouteArgs{
 * 			DestinationCidrBlock:                pulumi.String("172.16.0.0/16"),
 * 			LocalGatewayRouteTableId:            pulumi.Any(exampleAwsEc2LocalGatewayRouteTable.Id),
 * 			LocalGatewayVirtualInterfaceGroupId: pulumi.Any(exampleAwsEc2LocalGatewayVirtualInterfaceGroup.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LocalGatewayRoute;
 * import com.pulumi.aws.ec2.LocalGatewayRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocalGatewayRoute("example", LocalGatewayRouteArgs.builder()
 *             .destinationCidrBlock("172.16.0.0/16")
 *             .localGatewayRouteTableId(exampleAwsEc2LocalGatewayRouteTable.id())
 *             .localGatewayVirtualInterfaceGroupId(exampleAwsEc2LocalGatewayVirtualInterfaceGroup.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:LocalGatewayRoute
 *     properties:
 *       destinationCidrBlock: 172.16.0.0/16
 *       localGatewayRouteTableId: ${exampleAwsEc2LocalGatewayRouteTable.id}
 *       localGatewayVirtualInterfaceGroupId: ${exampleAwsEc2LocalGatewayVirtualInterfaceGroup.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_local_gateway_route` using the EC2 Local Gateway Route Table identifier and destination CIDR block separated by underscores (`_`). For example:
 * ```sh
 * $ pulumi import aws:ec2/localGatewayRoute:LocalGatewayRoute example lgw-rtb-12345678_172.16.0.0/16
 * ```
 * @property destinationCidrBlock IPv4 CIDR range used for destination matches. Routing decisions are based on the most specific match.
 * @property localGatewayRouteTableId Identifier of EC2 Local Gateway Route Table.
 * @property localGatewayVirtualInterfaceGroupId Identifier of EC2 Local Gateway Virtual Interface Group.
 */
public data class LocalGatewayRouteArgs(
    public val destinationCidrBlock: Output<String>? = null,
    public val localGatewayRouteTableId: Output<String>? = null,
    public val localGatewayVirtualInterfaceGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.LocalGatewayRouteArgs> {
    override fun toJava(): com.pulumi.aws.ec2.LocalGatewayRouteArgs =
        com.pulumi.aws.ec2.LocalGatewayRouteArgs.builder()
            .destinationCidrBlock(destinationCidrBlock?.applyValue({ args0 -> args0 }))
            .localGatewayRouteTableId(localGatewayRouteTableId?.applyValue({ args0 -> args0 }))
            .localGatewayVirtualInterfaceGroupId(
                localGatewayVirtualInterfaceGroupId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [LocalGatewayRouteArgs].
 */
@PulumiTagMarker
public class LocalGatewayRouteArgsBuilder internal constructor() {
    private var destinationCidrBlock: Output<String>? = null

    private var localGatewayRouteTableId: Output<String>? = null

    private var localGatewayVirtualInterfaceGroupId: Output<String>? = null

    /**
     * @param value IPv4 CIDR range used for destination matches. Routing decisions are based on the most specific match.
     */
    @JvmName("dvqvtrwytqlldyes")
    public suspend fun destinationCidrBlock(`value`: Output<String>) {
        this.destinationCidrBlock = value
    }

    /**
     * @param value Identifier of EC2 Local Gateway Route Table.
     */
    @JvmName("qhtxqnsirvhordqo")
    public suspend fun localGatewayRouteTableId(`value`: Output<String>) {
        this.localGatewayRouteTableId = value
    }

    /**
     * @param value Identifier of EC2 Local Gateway Virtual Interface Group.
     */
    @JvmName("bsmrqjvcjidclrud")
    public suspend fun localGatewayVirtualInterfaceGroupId(`value`: Output<String>) {
        this.localGatewayVirtualInterfaceGroupId = value
    }

    /**
     * @param value IPv4 CIDR range used for destination matches. Routing decisions are based on the most specific match.
     */
    @JvmName("wxtwmpatmbqefrnc")
    public suspend fun destinationCidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationCidrBlock = mapped
    }

    /**
     * @param value Identifier of EC2 Local Gateway Route Table.
     */
    @JvmName("hvesoiwesmbyeklk")
    public suspend fun localGatewayRouteTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localGatewayRouteTableId = mapped
    }

    /**
     * @param value Identifier of EC2 Local Gateway Virtual Interface Group.
     */
    @JvmName("xtuxrgwprkkrmvxj")
    public suspend fun localGatewayVirtualInterfaceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localGatewayVirtualInterfaceGroupId = mapped
    }

    internal fun build(): LocalGatewayRouteArgs = LocalGatewayRouteArgs(
        destinationCidrBlock = destinationCidrBlock,
        localGatewayRouteTableId = localGatewayRouteTableId,
        localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId,
    )
}
