@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.LocalGatewayRouteTableVpcAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Local Gateway Route Table VPC Association. More information can be found in the [Outposts User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html#vpc-associations).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ec2.getLocalGatewayRouteTable({
 *     outpostArn: "arn:aws:outposts:us-west-2:123456789012:outpost/op-1234567890abcdef",
 * });
 * const exampleVpc = new aws.ec2.Vpc("example", {cidrBlock: "10.0.0.0/16"});
 * const exampleLocalGatewayRouteTableVpcAssociation = new aws.ec2.LocalGatewayRouteTableVpcAssociation("example", {
 *     localGatewayRouteTableId: example.then(example => example.id),
 *     vpcId: exampleVpc.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.get_local_gateway_route_table(outpost_arn="arn:aws:outposts:us-west-2:123456789012:outpost/op-1234567890abcdef")
 * example_vpc = aws.ec2.Vpc("example", cidr_block="10.0.0.0/16")
 * example_local_gateway_route_table_vpc_association = aws.ec2.LocalGatewayRouteTableVpcAssociation("example",
 *     local_gateway_route_table_id=example.id,
 *     vpc_id=example_vpc.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.Ec2.GetLocalGatewayRouteTable.Invoke(new()
 *     {
 *         OutpostArn = "arn:aws:outposts:us-west-2:123456789012:outpost/op-1234567890abcdef",
 *     });
 *     var exampleVpc = new Aws.Ec2.Vpc("example", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var exampleLocalGatewayRouteTableVpcAssociation = new Aws.Ec2.LocalGatewayRouteTableVpcAssociation("example", new()
 *     {
 *         LocalGatewayRouteTableId = example.Apply(getLocalGatewayRouteTableResult => getLocalGatewayRouteTableResult.Id),
 *         VpcId = exampleVpc.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.GetLocalGatewayRouteTable(ctx, &ec2.GetLocalGatewayRouteTableArgs{
 * 			OutpostArn: pulumi.StringRef("arn:aws:outposts:us-west-2:123456789012:outpost/op-1234567890abcdef"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpc, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewLocalGatewayRouteTableVpcAssociation(ctx, "example", &ec2.LocalGatewayRouteTableVpcAssociationArgs{
 * 			LocalGatewayRouteTableId: pulumi.String(example.Id),
 * 			VpcId:                    exampleVpc.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetLocalGatewayRouteTableArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.LocalGatewayRouteTableVpcAssociation;
 * import com.pulumi.aws.ec2.LocalGatewayRouteTableVpcAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = Ec2Functions.getLocalGatewayRouteTable(GetLocalGatewayRouteTableArgs.builder()
 *             .outpostArn("arn:aws:outposts:us-west-2:123456789012:outpost/op-1234567890abcdef")
 *             .build());
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var exampleLocalGatewayRouteTableVpcAssociation = new LocalGatewayRouteTableVpcAssociation("exampleLocalGatewayRouteTableVpcAssociation", LocalGatewayRouteTableVpcAssociationArgs.builder()
 *             .localGatewayRouteTableId(example.applyValue(getLocalGatewayRouteTableResult -> getLocalGatewayRouteTableResult.id()))
 *             .vpcId(exampleVpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleVpc:
 *     type: aws:ec2:Vpc
 *     name: example
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *   exampleLocalGatewayRouteTableVpcAssociation:
 *     type: aws:ec2:LocalGatewayRouteTableVpcAssociation
 *     name: example
 *     properties:
 *       localGatewayRouteTableId: ${example.id}
 *       vpcId: ${exampleVpc.id}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ec2:getLocalGatewayRouteTable
 *       Arguments:
 *         outpostArn: arn:aws:outposts:us-west-2:123456789012:outpost/op-1234567890abcdef
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_local_gateway_route_table_vpc_association` using the Local Gateway Route Table VPC Association identifier. For example:
 * ```sh
 * $ pulumi import aws:ec2/localGatewayRouteTableVpcAssociation:LocalGatewayRouteTableVpcAssociation example lgw-vpc-assoc-1234567890abcdef
 * ```
 * @property localGatewayRouteTableId Identifier of EC2 Local Gateway Route Table.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcId Identifier of EC2 VPC.
 * The following arguments are optional:
 */
public data class LocalGatewayRouteTableVpcAssociationArgs(
    public val localGatewayRouteTableId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.LocalGatewayRouteTableVpcAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.LocalGatewayRouteTableVpcAssociationArgs =
        com.pulumi.aws.ec2.LocalGatewayRouteTableVpcAssociationArgs.builder()
            .localGatewayRouteTableId(localGatewayRouteTableId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LocalGatewayRouteTableVpcAssociationArgs].
 */
@PulumiTagMarker
public class LocalGatewayRouteTableVpcAssociationArgsBuilder internal constructor() {
    private var localGatewayRouteTableId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Identifier of EC2 Local Gateway Route Table.
     */
    @JvmName("ksudllxrwhwmytrc")
    public suspend fun localGatewayRouteTableId(`value`: Output<String>) {
        this.localGatewayRouteTableId = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mkxwieuglpowksro")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Identifier of EC2 VPC.
     * The following arguments are optional:
     */
    @JvmName("diribagwqhcwioge")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Identifier of EC2 Local Gateway Route Table.
     */
    @JvmName("cwruspbkcncrlqcn")
    public suspend fun localGatewayRouteTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localGatewayRouteTableId = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("seyenolqqpnduujd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nxfgqqngkrsklxvk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Identifier of EC2 VPC.
     * The following arguments are optional:
     */
    @JvmName("pegrglbigqpewhyt")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): LocalGatewayRouteTableVpcAssociationArgs =
        LocalGatewayRouteTableVpcAssociationArgs(
            localGatewayRouteTableId = localGatewayRouteTableId,
            tags = tags,
            vpcId = vpcId,
        )
}
