@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MainRouteTableAssociation].
 */
@PulumiTagMarker
public class MainRouteTableAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MainRouteTableAssociationArgs = MainRouteTableAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MainRouteTableAssociationArgsBuilder.() -> Unit) {
        val builder = MainRouteTableAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MainRouteTableAssociation {
        val builtJavaResource = com.pulumi.aws.ec2.MainRouteTableAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MainRouteTableAssociation(builtJavaResource)
    }
}

/**
 * Provides a resource for managing the main routing table of a VPC.
 * > **NOTE:** **Do not** use both `aws.ec2.DefaultRouteTable` to manage a default route table **and** `aws.ec2.MainRouteTableAssociation` with the same VPC due to possible route conflicts. See aws.ec2.DefaultRouteTable documentation for more details.
 * For more information, see the Amazon VPC User Guide on [Route Tables][aws-route-tables]&#46; For information about managing normal route tables in Pulumi, see [`aws&#46;ec2&#46;RouteTable`][tf-route-tables].
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const a = new aws.ec2.MainRouteTableAssociation("a", {
 *     vpcId: foo.id,
 *     routeTableId: bar.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * a = aws.ec2.MainRouteTableAssociation("a",
 *     vpc_id=foo["id"],
 *     route_table_id=bar["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var a = new Aws.Ec2.MainRouteTableAssociation("a", new()
 *     {
 *         VpcId = foo.Id,
 *         RouteTableId = bar.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewMainRouteTableAssociation(ctx, "a", &ec2.MainRouteTableAssociationArgs{
 * 			VpcId:        pulumi.Any(foo.Id),
 * 			RouteTableId: pulumi.Any(bar.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.MainRouteTableAssociation;
 * import com.pulumi.aws.ec2.MainRouteTableAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var a = new MainRouteTableAssociation("a", MainRouteTableAssociationArgs.builder()
 *             .vpcId(foo.id())
 *             .routeTableId(bar.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   a:
 *     type: aws:ec2:MainRouteTableAssociation
 *     properties:
 *       vpcId: ${foo.id}
 *       routeTableId: ${bar.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Notes
 * On VPC creation, the AWS API always creates an initial Main Route Table. This
 * resource records the ID of that Route Table under `original_route_table_id`.
 * The "Delete" action for a `main_route_table_association` consists of resetting
 * this original table as the Main Route Table for the VPC. You'll see this
 * additional Route Table in the AWS console; it must remain intact in order for
 * the `main_route_table_association` delete to work properly.
 */
public class MainRouteTableAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.MainRouteTableAssociation,
) : KotlinCustomResource(javaResource, MainRouteTableAssociationMapper) {
    /**
     * Used internally, see **Notes** below
     */
    public val originalRouteTableId: Output<String>
        get() = javaResource.originalRouteTableId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Route Table to set as the new
     * main route table for the target VPC
     */
    public val routeTableId: Output<String>
        get() = javaResource.routeTableId().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC whose main route table should be set
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object MainRouteTableAssociationMapper : ResourceMapper<MainRouteTableAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.MainRouteTableAssociation::class == javaResource::class

    override fun map(javaResource: Resource): MainRouteTableAssociation =
        MainRouteTableAssociation(javaResource as com.pulumi.aws.ec2.MainRouteTableAssociation)
}

/**
 * @see [MainRouteTableAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MainRouteTableAssociation].
 */
public suspend fun mainRouteTableAssociation(
    name: String,
    block: suspend MainRouteTableAssociationResourceBuilder.() -> Unit,
): MainRouteTableAssociation {
    val builder = MainRouteTableAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MainRouteTableAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mainRouteTableAssociation(name: String): MainRouteTableAssociation {
    val builder = MainRouteTableAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
