@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.MainRouteTableAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource for managing the main routing table of a VPC.
 * > **NOTE:** **Do not** use both `aws.ec2.DefaultRouteTable` to manage a default route table **and** `aws.ec2.MainRouteTableAssociation` with the same VPC due to possible route conflicts. See aws.ec2.DefaultRouteTable documentation for more details.
 * For more information, see the Amazon VPC User Guide on [Route Tables][aws-route-tables]&#46; For information about managing normal route tables in Pulumi, see [`aws&#46;ec2&#46;RouteTable`][tf-route-tables].
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const a = new aws.ec2.MainRouteTableAssociation("a", {
 *     vpcId: foo.id,
 *     routeTableId: bar.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * a = aws.ec2.MainRouteTableAssociation("a",
 *     vpc_id=foo["id"],
 *     route_table_id=bar["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var a = new Aws.Ec2.MainRouteTableAssociation("a", new()
 *     {
 *         VpcId = foo.Id,
 *         RouteTableId = bar.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewMainRouteTableAssociation(ctx, "a", &ec2.MainRouteTableAssociationArgs{
 * 			VpcId:        pulumi.Any(foo.Id),
 * 			RouteTableId: pulumi.Any(bar.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.MainRouteTableAssociation;
 * import com.pulumi.aws.ec2.MainRouteTableAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var a = new MainRouteTableAssociation("a", MainRouteTableAssociationArgs.builder()
 *             .vpcId(foo.id())
 *             .routeTableId(bar.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   a:
 *     type: aws:ec2:MainRouteTableAssociation
 *     properties:
 *       vpcId: ${foo.id}
 *       routeTableId: ${bar.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Notes
 * On VPC creation, the AWS API always creates an initial Main Route Table. This
 * resource records the ID of that Route Table under `original_route_table_id`.
 * The "Delete" action for a `main_route_table_association` consists of resetting
 * this original table as the Main Route Table for the VPC. You'll see this
 * additional Route Table in the AWS console; it must remain intact in order for
 * the `main_route_table_association` delete to work properly.
 * @property routeTableId The ID of the Route Table to set as the new
 * main route table for the target VPC
 * @property vpcId The ID of the VPC whose main route table should be set
 */
public data class MainRouteTableAssociationArgs(
    public val routeTableId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.MainRouteTableAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.MainRouteTableAssociationArgs =
        com.pulumi.aws.ec2.MainRouteTableAssociationArgs.builder()
            .routeTableId(routeTableId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MainRouteTableAssociationArgs].
 */
@PulumiTagMarker
public class MainRouteTableAssociationArgsBuilder internal constructor() {
    private var routeTableId: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The ID of the Route Table to set as the new
     * main route table for the target VPC
     */
    @JvmName("wmgsdvquxklutwlu")
    public suspend fun routeTableId(`value`: Output<String>) {
        this.routeTableId = value
    }

    /**
     * @param value The ID of the VPC whose main route table should be set
     */
    @JvmName("kqerbwmbaukkebhk")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the Route Table to set as the new
     * main route table for the target VPC
     */
    @JvmName("bdsfasmyiiunigpw")
    public suspend fun routeTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableId = mapped
    }

    /**
     * @param value The ID of the VPC whose main route table should be set
     */
    @JvmName("esipnyqwceqncxps")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): MainRouteTableAssociationArgs = MainRouteTableAssociationArgs(
        routeTableId = routeTableId,
        vpcId = vpcId,
    )
}
