@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.ManagedPrefixListEntry
import com.pulumi.aws.ec2.kotlin.outputs.ManagedPrefixListEntry.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ManagedPrefixList].
 */
@PulumiTagMarker
public class ManagedPrefixListResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedPrefixListArgs = ManagedPrefixListArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedPrefixListArgsBuilder.() -> Unit) {
        val builder = ManagedPrefixListArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedPrefixList {
        val builtJavaResource = com.pulumi.aws.ec2.ManagedPrefixList(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ManagedPrefixList(builtJavaResource)
    }
}

/**
 * Provides a managed prefix list resource.
 * > **NOTE on Managed Prefix Lists and Managed Prefix List Entries:** The provider
 * currently provides both a standalone Managed Prefix List Entry resource (a single entry),
 * and a Managed Prefix List resource with entries defined in-line. At this time you
 * cannot use a Managed Prefix List with in-line rules in conjunction with any Managed
 * Prefix List Entry resources. Doing so will cause a conflict of entries and will overwrite entries.
 * > **NOTE on `max_entries`:** When you reference a Prefix List in a resource,
 * the maximum number of entries for the prefix lists counts as the same number of rules
 * or entries for the resource. For example, if you create a prefix list with a maximum
 * of 20 entries and you reference that prefix list in a security group rule, this counts
 * as 20 rules for the security group.
 * ## Example Usage
 * Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.ManagedPrefixList("example", {
 *     name: "All VPC CIDR-s",
 *     addressFamily: "IPv4",
 *     maxEntries: 5,
 *     entries: [
 *         {
 *             cidr: exampleAwsVpc.cidrBlock,
 *             description: "Primary",
 *         },
 *         {
 *             cidr: exampleAwsVpcIpv4CidrBlockAssociation.cidrBlock,
 *             description: "Secondary",
 *         },
 *     ],
 *     tags: {
 *         Env: "live",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.ManagedPrefixList("example",
 *     name="All VPC CIDR-s",
 *     address_family="IPv4",
 *     max_entries=5,
 *     entries=[
 *         {
 *             "cidr": example_aws_vpc["cidrBlock"],
 *             "description": "Primary",
 *         },
 *         {
 *             "cidr": example_aws_vpc_ipv4_cidr_block_association["cidrBlock"],
 *             "description": "Secondary",
 *         },
 *     ],
 *     tags={
 *         "Env": "live",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.ManagedPrefixList("example", new()
 *     {
 *         Name = "All VPC CIDR-s",
 *         AddressFamily = "IPv4",
 *         MaxEntries = 5,
 *         Entries = new[]
 *         {
 *             new Aws.Ec2.Inputs.ManagedPrefixListEntryArgs
 *             {
 *                 Cidr = exampleAwsVpc.CidrBlock,
 *                 Description = "Primary",
 *             },
 *             new Aws.Ec2.Inputs.ManagedPrefixListEntryArgs
 *             {
 *                 Cidr = exampleAwsVpcIpv4CidrBlockAssociation.CidrBlock,
 *                 Description = "Secondary",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Env", "live" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewManagedPrefixList(ctx, "example", &ec2.ManagedPrefixListArgs{
 * 			Name:          pulumi.String("All VPC CIDR-s"),
 * 			AddressFamily: pulumi.String("IPv4"),
 * 			MaxEntries:    pulumi.Int(5),
 * 			Entries: ec2.ManagedPrefixListEntryTypeArray{
 * 				&ec2.ManagedPrefixListEntryTypeArgs{
 * 					Cidr:        pulumi.Any(exampleAwsVpc.CidrBlock),
 * 					Description: pulumi.String("Primary"),
 * 				},
 * 				&ec2.ManagedPrefixListEntryTypeArgs{
 * 					Cidr:        pulumi.Any(exampleAwsVpcIpv4CidrBlockAssociation.CidrBlock),
 * 					Description: pulumi.String("Secondary"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Env": pulumi.String("live"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.ManagedPrefixList;
 * import com.pulumi.aws.ec2.ManagedPrefixListArgs;
 * import com.pulumi.aws.ec2.inputs.ManagedPrefixListEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ManagedPrefixList("example", ManagedPrefixListArgs.builder()
 *             .name("All VPC CIDR-s")
 *             .addressFamily("IPv4")
 *             .maxEntries(5)
 *             .entries(
 *                 ManagedPrefixListEntryArgs.builder()
 *                     .cidr(exampleAwsVpc.cidrBlock())
 *                     .description("Primary")
 *                     .build(),
 *                 ManagedPrefixListEntryArgs.builder()
 *                     .cidr(exampleAwsVpcIpv4CidrBlockAssociation.cidrBlock())
 *                     .description("Secondary")
 *                     .build())
 *             .tags(Map.of("Env", "live"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:ManagedPrefixList
 *     properties:
 *       name: All VPC CIDR-s
 *       addressFamily: IPv4
 *       maxEntries: 5
 *       entries:
 *         - cidr: ${exampleAwsVpc.cidrBlock}
 *           description: Primary
 *         - cidr: ${exampleAwsVpcIpv4CidrBlockAssociation.cidrBlock}
 *           description: Secondary
 *       tags:
 *         Env: live
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Prefix Lists using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/managedPrefixList:ManagedPrefixList default pl-0570a1d2d725c16be
 * ```
 */
public class ManagedPrefixList internal constructor(
    override val javaResource: com.pulumi.aws.ec2.ManagedPrefixList,
) : KotlinCustomResource(javaResource, ManagedPrefixListMapper) {
    /**
     * Address family (`IPv4` or `IPv6`) of this prefix list.
     */
    public val addressFamily: Output<String>
        get() = javaResource.addressFamily().applyValue({ args0 -> args0 })

    /**
     * ARN of the prefix list.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block for prefix list entry. Detailed below. Different entries may have overlapping CIDR blocks, but a particular CIDR should not be duplicated.
     */
    public val entries: Output<List<ManagedPrefixListEntry>>
        get() = javaResource.entries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Maximum number of entries that this prefix list can contain.
     */
    public val maxEntries: Output<Int>
        get() = javaResource.maxEntries().applyValue({ args0 -> args0 })

    /**
     * Name of this resource. The name must not start with `com.amazonaws`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ID of the AWS account that owns this prefix list.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Latest version of this prefix list.
     */
    public val version: Output<Int>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object ManagedPrefixListMapper : ResourceMapper<ManagedPrefixList> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.ManagedPrefixList::class == javaResource::class

    override fun map(javaResource: Resource): ManagedPrefixList = ManagedPrefixList(
        javaResource as
            com.pulumi.aws.ec2.ManagedPrefixList,
    )
}

/**
 * @see [ManagedPrefixList].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedPrefixList].
 */
public suspend fun managedPrefixList(
    name: String,
    block: suspend ManagedPrefixListResourceBuilder.() -> Unit,
): ManagedPrefixList {
    val builder = ManagedPrefixListResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedPrefixList].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedPrefixList(name: String): ManagedPrefixList {
    val builder = ManagedPrefixListResourceBuilder()
    builder.name(name)
    return builder.build()
}
