@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.ManagedPrefixListArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.ManagedPrefixListEntryArgs
import com.pulumi.aws.ec2.kotlin.inputs.ManagedPrefixListEntryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a managed prefix list resource.
 * > **NOTE on Managed Prefix Lists and Managed Prefix List Entries:** The provider
 * currently provides both a standalone Managed Prefix List Entry resource (a single entry),
 * and a Managed Prefix List resource with entries defined in-line. At this time you
 * cannot use a Managed Prefix List with in-line rules in conjunction with any Managed
 * Prefix List Entry resources. Doing so will cause a conflict of entries and will overwrite entries.
 * > **NOTE on `max_entries`:** When you reference a Prefix List in a resource,
 * the maximum number of entries for the prefix lists counts as the same number of rules
 * or entries for the resource. For example, if you create a prefix list with a maximum
 * of 20 entries and you reference that prefix list in a security group rule, this counts
 * as 20 rules for the security group.
 * ## Example Usage
 * Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.ManagedPrefixList("example", {
 *     name: "All VPC CIDR-s",
 *     addressFamily: "IPv4",
 *     maxEntries: 5,
 *     entries: [
 *         {
 *             cidr: exampleAwsVpc.cidrBlock,
 *             description: "Primary",
 *         },
 *         {
 *             cidr: exampleAwsVpcIpv4CidrBlockAssociation.cidrBlock,
 *             description: "Secondary",
 *         },
 *     ],
 *     tags: {
 *         Env: "live",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.ManagedPrefixList("example",
 *     name="All VPC CIDR-s",
 *     address_family="IPv4",
 *     max_entries=5,
 *     entries=[
 *         {
 *             "cidr": example_aws_vpc["cidrBlock"],
 *             "description": "Primary",
 *         },
 *         {
 *             "cidr": example_aws_vpc_ipv4_cidr_block_association["cidrBlock"],
 *             "description": "Secondary",
 *         },
 *     ],
 *     tags={
 *         "Env": "live",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.ManagedPrefixList("example", new()
 *     {
 *         Name = "All VPC CIDR-s",
 *         AddressFamily = "IPv4",
 *         MaxEntries = 5,
 *         Entries = new[]
 *         {
 *             new Aws.Ec2.Inputs.ManagedPrefixListEntryArgs
 *             {
 *                 Cidr = exampleAwsVpc.CidrBlock,
 *                 Description = "Primary",
 *             },
 *             new Aws.Ec2.Inputs.ManagedPrefixListEntryArgs
 *             {
 *                 Cidr = exampleAwsVpcIpv4CidrBlockAssociation.CidrBlock,
 *                 Description = "Secondary",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Env", "live" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewManagedPrefixList(ctx, "example", &ec2.ManagedPrefixListArgs{
 * 			Name:          pulumi.String("All VPC CIDR-s"),
 * 			AddressFamily: pulumi.String("IPv4"),
 * 			MaxEntries:    pulumi.Int(5),
 * 			Entries: ec2.ManagedPrefixListEntryTypeArray{
 * 				&ec2.ManagedPrefixListEntryTypeArgs{
 * 					Cidr:        pulumi.Any(exampleAwsVpc.CidrBlock),
 * 					Description: pulumi.String("Primary"),
 * 				},
 * 				&ec2.ManagedPrefixListEntryTypeArgs{
 * 					Cidr:        pulumi.Any(exampleAwsVpcIpv4CidrBlockAssociation.CidrBlock),
 * 					Description: pulumi.String("Secondary"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Env": pulumi.String("live"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.ManagedPrefixList;
 * import com.pulumi.aws.ec2.ManagedPrefixListArgs;
 * import com.pulumi.aws.ec2.inputs.ManagedPrefixListEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ManagedPrefixList("example", ManagedPrefixListArgs.builder()
 *             .name("All VPC CIDR-s")
 *             .addressFamily("IPv4")
 *             .maxEntries(5)
 *             .entries(
 *                 ManagedPrefixListEntryArgs.builder()
 *                     .cidr(exampleAwsVpc.cidrBlock())
 *                     .description("Primary")
 *                     .build(),
 *                 ManagedPrefixListEntryArgs.builder()
 *                     .cidr(exampleAwsVpcIpv4CidrBlockAssociation.cidrBlock())
 *                     .description("Secondary")
 *                     .build())
 *             .tags(Map.of("Env", "live"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:ManagedPrefixList
 *     properties:
 *       name: All VPC CIDR-s
 *       addressFamily: IPv4
 *       maxEntries: 5
 *       entries:
 *         - cidr: ${exampleAwsVpc.cidrBlock}
 *           description: Primary
 *         - cidr: ${exampleAwsVpcIpv4CidrBlockAssociation.cidrBlock}
 *           description: Secondary
 *       tags:
 *         Env: live
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Prefix Lists using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/managedPrefixList:ManagedPrefixList default pl-0570a1d2d725c16be
 * ```
 * @property addressFamily Address family (`IPv4` or `IPv6`) of this prefix list.
 * @property entries Configuration block for prefix list entry. Detailed below. Different entries may have overlapping CIDR blocks, but a particular CIDR should not be duplicated.
 * @property maxEntries Maximum number of entries that this prefix list can contain.
 * @property name Name of this resource. The name must not start with `com.amazonaws`.
 * @property tags Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ManagedPrefixListArgs(
    public val addressFamily: Output<String>? = null,
    public val entries: Output<List<ManagedPrefixListEntryArgs>>? = null,
    public val maxEntries: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.ManagedPrefixListArgs> {
    override fun toJava(): com.pulumi.aws.ec2.ManagedPrefixListArgs =
        com.pulumi.aws.ec2.ManagedPrefixListArgs.builder()
            .addressFamily(addressFamily?.applyValue({ args0 -> args0 }))
            .entries(
                entries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .maxEntries(maxEntries?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ManagedPrefixListArgs].
 */
@PulumiTagMarker
public class ManagedPrefixListArgsBuilder internal constructor() {
    private var addressFamily: Output<String>? = null

    private var entries: Output<List<ManagedPrefixListEntryArgs>>? = null

    private var maxEntries: Output<Int>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Address family (`IPv4` or `IPv6`) of this prefix list.
     */
    @JvmName("uyelwfiiuuwnnlga")
    public suspend fun addressFamily(`value`: Output<String>) {
        this.addressFamily = value
    }

    /**
     * @param value Configuration block for prefix list entry. Detailed below. Different entries may have overlapping CIDR blocks, but a particular CIDR should not be duplicated.
     */
    @JvmName("yjtlrmwnilgfrodc")
    public suspend fun entries(`value`: Output<List<ManagedPrefixListEntryArgs>>) {
        this.entries = value
    }

    @JvmName("ybuovwwuiahulcaw")
    public suspend fun entries(vararg values: Output<ManagedPrefixListEntryArgs>) {
        this.entries = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for prefix list entry. Detailed below. Different entries may have overlapping CIDR blocks, but a particular CIDR should not be duplicated.
     */
    @JvmName("tfwegqlljunvcqwb")
    public suspend fun entries(values: List<Output<ManagedPrefixListEntryArgs>>) {
        this.entries = Output.all(values)
    }

    /**
     * @param value Maximum number of entries that this prefix list can contain.
     */
    @JvmName("cwjhmiawggvlguhc")
    public suspend fun maxEntries(`value`: Output<Int>) {
        this.maxEntries = value
    }

    /**
     * @param value Name of this resource. The name must not start with `com.amazonaws`.
     */
    @JvmName("mkisypjltyytbxrl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("icefyjuqqwopvwuh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Address family (`IPv4` or `IPv6`) of this prefix list.
     */
    @JvmName("itqgavfdqusmjwfn")
    public suspend fun addressFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressFamily = mapped
    }

    /**
     * @param value Configuration block for prefix list entry. Detailed below. Different entries may have overlapping CIDR blocks, but a particular CIDR should not be duplicated.
     */
    @JvmName("eouccsoemcetkfrh")
    public suspend fun entries(`value`: List<ManagedPrefixListEntryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entries = mapped
    }

    /**
     * @param argument Configuration block for prefix list entry. Detailed below. Different entries may have overlapping CIDR blocks, but a particular CIDR should not be duplicated.
     */
    @JvmName("eyabxucephvkfxdj")
    public suspend fun entries(argument: List<suspend ManagedPrefixListEntryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedPrefixListEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.entries = mapped
    }

    /**
     * @param argument Configuration block for prefix list entry. Detailed below. Different entries may have overlapping CIDR blocks, but a particular CIDR should not be duplicated.
     */
    @JvmName("fvodclbnhmhiqscj")
    public suspend fun entries(vararg argument: suspend ManagedPrefixListEntryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManagedPrefixListEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.entries = mapped
    }

    /**
     * @param argument Configuration block for prefix list entry. Detailed below. Different entries may have overlapping CIDR blocks, but a particular CIDR should not be duplicated.
     */
    @JvmName("suantaxvqkkxbray")
    public suspend fun entries(argument: suspend ManagedPrefixListEntryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ManagedPrefixListEntryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.entries = mapped
    }

    /**
     * @param values Configuration block for prefix list entry. Detailed below. Different entries may have overlapping CIDR blocks, but a particular CIDR should not be duplicated.
     */
    @JvmName("uaybnqycllyxnonk")
    public suspend fun entries(vararg values: ManagedPrefixListEntryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entries = mapped
    }

    /**
     * @param value Maximum number of entries that this prefix list can contain.
     */
    @JvmName("msdspqxspkpmtltl")
    public suspend fun maxEntries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxEntries = mapped
    }

    /**
     * @param value Name of this resource. The name must not start with `com.amazonaws`.
     */
    @JvmName("ijqfecuxhdcibmmd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ragoylkgkastvshm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lqrvpifwlxwecwqy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ManagedPrefixListArgs = ManagedPrefixListArgs(
        addressFamily = addressFamily,
        entries = entries,
        maxEntries = maxEntries,
        name = name,
        tags = tags,
    )
}
