@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagedPrefixListEntry].
 */
@PulumiTagMarker
public class ManagedPrefixListEntryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedPrefixListEntryArgs = ManagedPrefixListEntryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedPrefixListEntryArgsBuilder.() -> Unit) {
        val builder = ManagedPrefixListEntryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedPrefixListEntry {
        val builtJavaResource = com.pulumi.aws.ec2.ManagedPrefixListEntry(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ManagedPrefixListEntry(builtJavaResource)
    }
}

/**
 * Use the `aws_prefix_list_entry` resource to manage a managed prefix list entry.
 * > **NOTE:** Pulumi currently provides two resources for managing Managed Prefix Lists and Managed Prefix List Entries. The standalone resource, Managed Prefix List Entry, is used to manage a single entry. The Managed Prefix List resource is used to manage multiple entries defined in-line. It is important to note that you cannot use a Managed Prefix List with in-line rules in conjunction with any Managed Prefix List Entry resources. This will result in a conflict of entries and will cause the entries to be overwritten.
 * > **NOTE:** To improve execution times on larger updates, it is recommended to use the inline `entry` block as part of the Managed Prefix List resource when creating a prefix list with more than 100 entries. You can find more information about the resource here.
 * ## Example Usage
 * Basic usage.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.ManagedPrefixList("example", {
 *     name: "All VPC CIDR-s",
 *     addressFamily: "IPv4",
 *     maxEntries: 5,
 *     tags: {
 *         Env: "live",
 *     },
 * });
 * const entry1 = new aws.ec2.ManagedPrefixListEntry("entry_1", {
 *     cidr: exampleAwsVpc.cidrBlock,
 *     description: "Primary",
 *     prefixListId: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.ManagedPrefixList("example",
 *     name="All VPC CIDR-s",
 *     address_family="IPv4",
 *     max_entries=5,
 *     tags={
 *         "Env": "live",
 *     })
 * entry1 = aws.ec2.ManagedPrefixListEntry("entry_1",
 *     cidr=example_aws_vpc["cidrBlock"],
 *     description="Primary",
 *     prefix_list_id=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.ManagedPrefixList("example", new()
 *     {
 *         Name = "All VPC CIDR-s",
 *         AddressFamily = "IPv4",
 *         MaxEntries = 5,
 *         Tags =
 *         {
 *             { "Env", "live" },
 *         },
 *     });
 *     var entry1 = new Aws.Ec2.ManagedPrefixListEntry("entry_1", new()
 *     {
 *         Cidr = exampleAwsVpc.CidrBlock,
 *         Description = "Primary",
 *         PrefixListId = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.NewManagedPrefixList(ctx, "example", &ec2.ManagedPrefixListArgs{
 * 			Name:          pulumi.String("All VPC CIDR-s"),
 * 			AddressFamily: pulumi.String("IPv4"),
 * 			MaxEntries:    pulumi.Int(5),
 * 			Tags: pulumi.StringMap{
 * 				"Env": pulumi.String("live"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewManagedPrefixListEntry(ctx, "entry_1", &ec2.ManagedPrefixListEntryArgs{
 * 			Cidr:         pulumi.Any(exampleAwsVpc.CidrBlock),
 * 			Description:  pulumi.String("Primary"),
 * 			PrefixListId: example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.ManagedPrefixList;
 * import com.pulumi.aws.ec2.ManagedPrefixListArgs;
 * import com.pulumi.aws.ec2.ManagedPrefixListEntry;
 * import com.pulumi.aws.ec2.ManagedPrefixListEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ManagedPrefixList("example", ManagedPrefixListArgs.builder()
 *             .name("All VPC CIDR-s")
 *             .addressFamily("IPv4")
 *             .maxEntries(5)
 *             .tags(Map.of("Env", "live"))
 *             .build());
 *         var entry1 = new ManagedPrefixListEntry("entry1", ManagedPrefixListEntryArgs.builder()
 *             .cidr(exampleAwsVpc.cidrBlock())
 *             .description("Primary")
 *             .prefixListId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:ManagedPrefixList
 *     properties:
 *       name: All VPC CIDR-s
 *       addressFamily: IPv4
 *       maxEntries: 5
 *       tags:
 *         Env: live
 *   entry1:
 *     type: aws:ec2:ManagedPrefixListEntry
 *     name: entry_1
 *     properties:
 *       cidr: ${exampleAwsVpc.cidrBlock}
 *       description: Primary
 *       prefixListId: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import prefix list entries using `prefix_list_id` and `cidr` separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:ec2/managedPrefixListEntry:ManagedPrefixListEntry default pl-0570a1d2d725c16be,10.0.3.0/24
 * ```
 */
public class ManagedPrefixListEntry internal constructor(
    override val javaResource: com.pulumi.aws.ec2.ManagedPrefixListEntry,
) : KotlinCustomResource(javaResource, ManagedPrefixListEntryMapper) {
    /**
     * CIDR block of this entry.
     */
    public val cidr: Output<String>
        get() = javaResource.cidr().applyValue({ args0 -> args0 })

    /**
     * Description of this entry. Please note that due to API limitations, updating only the description of an entry will require recreating the entry.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the prefix list.
     */
    public val prefixListId: Output<String>
        get() = javaResource.prefixListId().applyValue({ args0 -> args0 })
}

public object ManagedPrefixListEntryMapper : ResourceMapper<ManagedPrefixListEntry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.ManagedPrefixListEntry::class == javaResource::class

    override fun map(javaResource: Resource): ManagedPrefixListEntry =
        ManagedPrefixListEntry(javaResource as com.pulumi.aws.ec2.ManagedPrefixListEntry)
}

/**
 * @see [ManagedPrefixListEntry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedPrefixListEntry].
 */
public suspend fun managedPrefixListEntry(
    name: String,
    block: suspend ManagedPrefixListEntryResourceBuilder.() -> Unit,
): ManagedPrefixListEntry {
    val builder = ManagedPrefixListEntryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedPrefixListEntry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedPrefixListEntry(name: String): ManagedPrefixListEntry {
    val builder = ManagedPrefixListEntryResourceBuilder()
    builder.name(name)
    return builder.build()
}
