@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [NatGateway].
 */
@PulumiTagMarker
public class NatGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NatGatewayArgs = NatGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NatGatewayArgsBuilder.() -> Unit) {
        val builder = NatGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NatGateway {
        val builtJavaResource = com.pulumi.aws.ec2.NatGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NatGateway(builtJavaResource)
    }
}

/**
 * Provides a resource to create a VPC NAT Gateway.
 * ## Example Usage
 * ### Public NAT
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.NatGateway("example", {
 *     allocationId: exampleAwsEip.id,
 *     subnetId: exampleAwsSubnet.id,
 *     tags: {
 *         Name: "gw NAT",
 *     },
 * }, {
 *     dependsOn: [exampleAwsInternetGateway],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.NatGateway("example",
 *     allocation_id=example_aws_eip["id"],
 *     subnet_id=example_aws_subnet["id"],
 *     tags={
 *         "Name": "gw NAT",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_internet_gateway]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.NatGateway("example", new()
 *     {
 *         AllocationId = exampleAwsEip.Id,
 *         SubnetId = exampleAwsSubnet.Id,
 *         Tags =
 *         {
 *             { "Name", "gw NAT" },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsInternetGateway,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewNatGateway(ctx, "example", &ec2.NatGatewayArgs{
 * 			AllocationId: pulumi.Any(exampleAwsEip.Id),
 * 			SubnetId:     pulumi.Any(exampleAwsSubnet.Id),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("gw NAT"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsInternetGateway,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .allocationId(exampleAwsEip.id())
 *             .subnetId(exampleAwsSubnet.id())
 *             .tags(Map.of("Name", "gw NAT"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsInternetGateway)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:NatGateway
 *     properties:
 *       allocationId: ${exampleAwsEip.id}
 *       subnetId: ${exampleAwsSubnet.id}
 *       tags:
 *         Name: gw NAT
 *     options:
 *       dependson:
 *         - ${exampleAwsInternetGateway}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Public NAT with Secondary Private IP Addresses
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.NatGateway("example", {
 *     allocationId: exampleAwsEip.id,
 *     subnetId: exampleAwsSubnet.id,
 *     secondaryAllocationIds: [secondary&#46;id],
 *     secondaryPrivateIpAddresses: ["10&#46;0&#46;1&#46;5"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.NatGateway("example",
 *     allocation_id=example_aws_eip["id"],
 *     subnet_id=example_aws_subnet["id"],
 *     secondary_allocation_ids=[secondary["id"]],
 *     secondary_private_ip_addresses=["10&#46;0&#46;1&#46;5"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.NatGateway("example", new()
 *     {
 *         AllocationId = exampleAwsEip.Id,
 *         SubnetId = exampleAwsSubnet.Id,
 *         SecondaryAllocationIds = new[]
 *         {
 *             secondary.Id,
 *         },
 *         SecondaryPrivateIpAddresses = new[]
 *         {
 *             "10.0.1.5",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewNatGateway(ctx, "example", &ec2.NatGatewayArgs{
 * 			AllocationId: pulumi.Any(exampleAwsEip.Id),
 * 			SubnetId:     pulumi.Any(exampleAwsSubnet.Id),
 * 			SecondaryAllocationIds: pulumi.StringArray{
 * 				secondary.Id,
 * 			},
 * 			SecondaryPrivateIpAddresses: pulumi.StringArray{
 * 				pulumi.String("10.0.1.5"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .allocationId(exampleAwsEip.id())
 *             .subnetId(exampleAwsSubnet.id())
 *             .secondaryAllocationIds(secondary.id())
 *             .secondaryPrivateIpAddresses("10.0.1.5")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:NatGateway
 *     properties:
 *       allocationId: ${exampleAwsEip.id}
 *       subnetId: ${exampleAwsSubnet.id}
 *       secondaryAllocationIds:
 *         - ${secondary.id}
 *       secondaryPrivateIpAddresses:
 *         - 10.0.1.5
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Private NAT
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.NatGateway("example", {
 *     connectivityType: "private",
 *     subnetId: exampleAwsSubnet.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.NatGateway("example",
 *     connectivity_type="private",
 *     subnet_id=example_aws_subnet["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.NatGateway("example", new()
 *     {
 *         ConnectivityType = "private",
 *         SubnetId = exampleAwsSubnet.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewNatGateway(ctx, "example", &ec2.NatGatewayArgs{
 * 			ConnectivityType: pulumi.String("private"),
 * 			SubnetId:         pulumi.Any(exampleAwsSubnet.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .connectivityType("private")
 *             .subnetId(exampleAwsSubnet.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:NatGateway
 *     properties:
 *       connectivityType: private
 *       subnetId: ${exampleAwsSubnet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Private NAT with Secondary Private IP Addresses
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.NatGateway("example", {
 *     connectivityType: "private",
 *     subnetId: exampleAwsSubnet.id,
 *     secondaryPrivateIpAddressCount: 7,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.NatGateway("example",
 *     connectivity_type="private",
 *     subnet_id=example_aws_subnet["id"],
 *     secondary_private_ip_address_count=7)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.NatGateway("example", new()
 *     {
 *         ConnectivityType = "private",
 *         SubnetId = exampleAwsSubnet.Id,
 *         SecondaryPrivateIpAddressCount = 7,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewNatGateway(ctx, "example", &ec2.NatGatewayArgs{
 * 			ConnectivityType:               pulumi.String("private"),
 * 			SubnetId:                       pulumi.Any(exampleAwsSubnet.Id),
 * 			SecondaryPrivateIpAddressCount: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .connectivityType("private")
 *             .subnetId(exampleAwsSubnet.id())
 *             .secondaryPrivateIpAddressCount(7)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:NatGateway
 *     properties:
 *       connectivityType: private
 *       subnetId: ${exampleAwsSubnet.id}
 *       secondaryPrivateIpAddressCount: 7
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import NAT Gateways using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/natGateway:NatGateway private_gw nat-05dba92075d71c408
 * ```
 */
public class NatGateway internal constructor(
    override val javaResource: com.pulumi.aws.ec2.NatGateway,
) : KotlinCustomResource(javaResource, NatGatewayMapper) {
    /**
     * The Allocation ID of the Elastic IP address for the NAT Gateway. Required for `connectivity_type` of `public`.
     */
    public val allocationId: Output<String>?
        get() = javaResource.allocationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The association ID of the Elastic IP address that's associated with the NAT Gateway. Only available when `connectivity_type` is `public`.
     */
    public val associationId: Output<String>
        get() = javaResource.associationId().applyValue({ args0 -> args0 })

    /**
     * Connectivity type for the NAT Gateway. Valid values are `private` and `public`. Defaults to `public`.
     */
    public val connectivityType: Output<String>?
        get() = javaResource.connectivityType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the network interface associated with the NAT Gateway.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The private IPv4 address to assign to the NAT Gateway. If you don't provide an address, a private IPv4 address will be automatically assigned.
     */
    public val privateIp: Output<String>
        get() = javaResource.privateIp().applyValue({ args0 -> args0 })

    /**
     * The Elastic IP address associated with the NAT Gateway.
     */
    public val publicIp: Output<String>
        get() = javaResource.publicIp().applyValue({ args0 -> args0 })

    /**
     * A list of secondary allocation EIP IDs for this NAT Gateway.
     */
    public val secondaryAllocationIds: Output<List<String>>?
        get() = javaResource.secondaryAllocationIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * [Private NAT Gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT Gateway.
     */
    public val secondaryPrivateIpAddressCount: Output<Int>
        get() = javaResource.secondaryPrivateIpAddressCount().applyValue({ args0 -> args0 })

    /**
     * A list of secondary private IPv4 addresses to assign to the NAT Gateway.
     */
    public val secondaryPrivateIpAddresses: Output<List<String>>
        get() = javaResource.secondaryPrivateIpAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * The Subnet ID of the subnet in which to place the NAT Gateway.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object NatGatewayMapper : ResourceMapper<NatGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.NatGateway::class == javaResource::class

    override fun map(javaResource: Resource): NatGateway = NatGateway(
        javaResource as
            com.pulumi.aws.ec2.NatGateway,
    )
}

/**
 * @see [NatGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NatGateway].
 */
public suspend fun natGateway(name: String, block: suspend NatGatewayResourceBuilder.() -> Unit): NatGateway {
    val builder = NatGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NatGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun natGateway(name: String): NatGateway {
    val builder = NatGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
