@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.NatGatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to create a VPC NAT Gateway.
 * ## Example Usage
 * ### Public NAT
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.NatGateway("example", {
 *     allocationId: exampleAwsEip.id,
 *     subnetId: exampleAwsSubnet.id,
 *     tags: {
 *         Name: "gw NAT",
 *     },
 * }, {
 *     dependsOn: [exampleAwsInternetGateway],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.NatGateway("example",
 *     allocation_id=example_aws_eip["id"],
 *     subnet_id=example_aws_subnet["id"],
 *     tags={
 *         "Name": "gw NAT",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_internet_gateway]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.NatGateway("example", new()
 *     {
 *         AllocationId = exampleAwsEip.Id,
 *         SubnetId = exampleAwsSubnet.Id,
 *         Tags =
 *         {
 *             { "Name", "gw NAT" },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsInternetGateway,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewNatGateway(ctx, "example", &ec2.NatGatewayArgs{
 * 			AllocationId: pulumi.Any(exampleAwsEip.Id),
 * 			SubnetId:     pulumi.Any(exampleAwsSubnet.Id),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("gw NAT"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsInternetGateway,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .allocationId(exampleAwsEip.id())
 *             .subnetId(exampleAwsSubnet.id())
 *             .tags(Map.of("Name", "gw NAT"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsInternetGateway)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:NatGateway
 *     properties:
 *       allocationId: ${exampleAwsEip.id}
 *       subnetId: ${exampleAwsSubnet.id}
 *       tags:
 *         Name: gw NAT
 *     options:
 *       dependson:
 *         - ${exampleAwsInternetGateway}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Public NAT with Secondary Private IP Addresses
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.NatGateway("example", {
 *     allocationId: exampleAwsEip.id,
 *     subnetId: exampleAwsSubnet.id,
 *     secondaryAllocationIds: [secondary&#46;id],
 *     secondaryPrivateIpAddresses: ["10&#46;0&#46;1&#46;5"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.NatGateway("example",
 *     allocation_id=example_aws_eip["id"],
 *     subnet_id=example_aws_subnet["id"],
 *     secondary_allocation_ids=[secondary["id"]],
 *     secondary_private_ip_addresses=["10&#46;0&#46;1&#46;5"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.NatGateway("example", new()
 *     {
 *         AllocationId = exampleAwsEip.Id,
 *         SubnetId = exampleAwsSubnet.Id,
 *         SecondaryAllocationIds = new[]
 *         {
 *             secondary.Id,
 *         },
 *         SecondaryPrivateIpAddresses = new[]
 *         {
 *             "10.0.1.5",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewNatGateway(ctx, "example", &ec2.NatGatewayArgs{
 * 			AllocationId: pulumi.Any(exampleAwsEip.Id),
 * 			SubnetId:     pulumi.Any(exampleAwsSubnet.Id),
 * 			SecondaryAllocationIds: pulumi.StringArray{
 * 				secondary.Id,
 * 			},
 * 			SecondaryPrivateIpAddresses: pulumi.StringArray{
 * 				pulumi.String("10.0.1.5"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .allocationId(exampleAwsEip.id())
 *             .subnetId(exampleAwsSubnet.id())
 *             .secondaryAllocationIds(secondary.id())
 *             .secondaryPrivateIpAddresses("10.0.1.5")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:NatGateway
 *     properties:
 *       allocationId: ${exampleAwsEip.id}
 *       subnetId: ${exampleAwsSubnet.id}
 *       secondaryAllocationIds:
 *         - ${secondary.id}
 *       secondaryPrivateIpAddresses:
 *         - 10.0.1.5
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Private NAT
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.NatGateway("example", {
 *     connectivityType: "private",
 *     subnetId: exampleAwsSubnet.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.NatGateway("example",
 *     connectivity_type="private",
 *     subnet_id=example_aws_subnet["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.NatGateway("example", new()
 *     {
 *         ConnectivityType = "private",
 *         SubnetId = exampleAwsSubnet.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewNatGateway(ctx, "example", &ec2.NatGatewayArgs{
 * 			ConnectivityType: pulumi.String("private"),
 * 			SubnetId:         pulumi.Any(exampleAwsSubnet.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .connectivityType("private")
 *             .subnetId(exampleAwsSubnet.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:NatGateway
 *     properties:
 *       connectivityType: private
 *       subnetId: ${exampleAwsSubnet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Private NAT with Secondary Private IP Addresses
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.NatGateway("example", {
 *     connectivityType: "private",
 *     subnetId: exampleAwsSubnet.id,
 *     secondaryPrivateIpAddressCount: 7,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.NatGateway("example",
 *     connectivity_type="private",
 *     subnet_id=example_aws_subnet["id"],
 *     secondary_private_ip_address_count=7)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.NatGateway("example", new()
 *     {
 *         ConnectivityType = "private",
 *         SubnetId = exampleAwsSubnet.Id,
 *         SecondaryPrivateIpAddressCount = 7,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewNatGateway(ctx, "example", &ec2.NatGatewayArgs{
 * 			ConnectivityType:               pulumi.String("private"),
 * 			SubnetId:                       pulumi.Any(exampleAwsSubnet.Id),
 * 			SecondaryPrivateIpAddressCount: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .connectivityType("private")
 *             .subnetId(exampleAwsSubnet.id())
 *             .secondaryPrivateIpAddressCount(7)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:NatGateway
 *     properties:
 *       connectivityType: private
 *       subnetId: ${exampleAwsSubnet.id}
 *       secondaryPrivateIpAddressCount: 7
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import NAT Gateways using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/natGateway:NatGateway private_gw nat-05dba92075d71c408
 * ```
 * @property allocationId The Allocation ID of the Elastic IP address for the NAT Gateway. Required for `connectivity_type` of `public`.
 * @property connectivityType Connectivity type for the NAT Gateway. Valid values are `private` and `public`. Defaults to `public`.
 * @property privateIp The private IPv4 address to assign to the NAT Gateway. If you don't provide an address, a private IPv4 address will be automatically assigned.
 * @property secondaryAllocationIds A list of secondary allocation EIP IDs for this NAT Gateway.
 * @property secondaryPrivateIpAddressCount [Private NAT Gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT Gateway.
 * @property secondaryPrivateIpAddresses A list of secondary private IPv4 addresses to assign to the NAT Gateway.
 * @property subnetId The Subnet ID of the subnet in which to place the NAT Gateway.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class NatGatewayArgs(
    public val allocationId: Output<String>? = null,
    public val connectivityType: Output<String>? = null,
    public val privateIp: Output<String>? = null,
    public val secondaryAllocationIds: Output<List<String>>? = null,
    public val secondaryPrivateIpAddressCount: Output<Int>? = null,
    public val secondaryPrivateIpAddresses: Output<List<String>>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.NatGatewayArgs> {
    override fun toJava(): com.pulumi.aws.ec2.NatGatewayArgs =
        com.pulumi.aws.ec2.NatGatewayArgs.builder()
            .allocationId(allocationId?.applyValue({ args0 -> args0 }))
            .connectivityType(connectivityType?.applyValue({ args0 -> args0 }))
            .privateIp(privateIp?.applyValue({ args0 -> args0 }))
            .secondaryAllocationIds(
                secondaryAllocationIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .secondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount?.applyValue({ args0 -> args0 }))
            .secondaryPrivateIpAddresses(
                secondaryPrivateIpAddresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NatGatewayArgs].
 */
@PulumiTagMarker
public class NatGatewayArgsBuilder internal constructor() {
    private var allocationId: Output<String>? = null

    private var connectivityType: Output<String>? = null

    private var privateIp: Output<String>? = null

    private var secondaryAllocationIds: Output<List<String>>? = null

    private var secondaryPrivateIpAddressCount: Output<Int>? = null

    private var secondaryPrivateIpAddresses: Output<List<String>>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Allocation ID of the Elastic IP address for the NAT Gateway. Required for `connectivity_type` of `public`.
     */
    @JvmName("tdnymgurcbtwgysk")
    public suspend fun allocationId(`value`: Output<String>) {
        this.allocationId = value
    }

    /**
     * @param value Connectivity type for the NAT Gateway. Valid values are `private` and `public`. Defaults to `public`.
     */
    @JvmName("ubcxabguvldpspen")
    public suspend fun connectivityType(`value`: Output<String>) {
        this.connectivityType = value
    }

    /**
     * @param value The private IPv4 address to assign to the NAT Gateway. If you don't provide an address, a private IPv4 address will be automatically assigned.
     */
    @JvmName("cldvbceaghncsvuv")
    public suspend fun privateIp(`value`: Output<String>) {
        this.privateIp = value
    }

    /**
     * @param value A list of secondary allocation EIP IDs for this NAT Gateway.
     */
    @JvmName("gklchlspvvtjqdrg")
    public suspend fun secondaryAllocationIds(`value`: Output<List<String>>) {
        this.secondaryAllocationIds = value
    }

    @JvmName("rfjggccjxrqpvcsc")
    public suspend fun secondaryAllocationIds(vararg values: Output<String>) {
        this.secondaryAllocationIds = Output.all(values.asList())
    }

    /**
     * @param values A list of secondary allocation EIP IDs for this NAT Gateway.
     */
    @JvmName("xemrpjdyfwokdcre")
    public suspend fun secondaryAllocationIds(values: List<Output<String>>) {
        this.secondaryAllocationIds = Output.all(values)
    }

    /**
     * @param value [Private NAT Gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT Gateway.
     */
    @JvmName("gntavsuaqjpfsjse")
    public suspend fun secondaryPrivateIpAddressCount(`value`: Output<Int>) {
        this.secondaryPrivateIpAddressCount = value
    }

    /**
     * @param value A list of secondary private IPv4 addresses to assign to the NAT Gateway.
     */
    @JvmName("bgdixgnpsjdalkap")
    public suspend fun secondaryPrivateIpAddresses(`value`: Output<List<String>>) {
        this.secondaryPrivateIpAddresses = value
    }

    @JvmName("pqyhnjmbuwxogykf")
    public suspend fun secondaryPrivateIpAddresses(vararg values: Output<String>) {
        this.secondaryPrivateIpAddresses = Output.all(values.asList())
    }

    /**
     * @param values A list of secondary private IPv4 addresses to assign to the NAT Gateway.
     */
    @JvmName("cgpsocaasibqnihp")
    public suspend fun secondaryPrivateIpAddresses(values: List<Output<String>>) {
        this.secondaryPrivateIpAddresses = Output.all(values)
    }

    /**
     * @param value The Subnet ID of the subnet in which to place the NAT Gateway.
     */
    @JvmName("yeitqlqdqnnbnocf")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jaducysleckjvenv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Allocation ID of the Elastic IP address for the NAT Gateway. Required for `connectivity_type` of `public`.
     */
    @JvmName("eqmyjqrtkhtbcmdj")
    public suspend fun allocationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationId = mapped
    }

    /**
     * @param value Connectivity type for the NAT Gateway. Valid values are `private` and `public`. Defaults to `public`.
     */
    @JvmName("lomqwvxrwckjpgqd")
    public suspend fun connectivityType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectivityType = mapped
    }

    /**
     * @param value The private IPv4 address to assign to the NAT Gateway. If you don't provide an address, a private IPv4 address will be automatically assigned.
     */
    @JvmName("rjvajlceqxanpony")
    public suspend fun privateIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIp = mapped
    }

    /**
     * @param value A list of secondary allocation EIP IDs for this NAT Gateway.
     */
    @JvmName("lqahanqtqbdnghqm")
    public suspend fun secondaryAllocationIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryAllocationIds = mapped
    }

    /**
     * @param values A list of secondary allocation EIP IDs for this NAT Gateway.
     */
    @JvmName("kchilhdgjidlwwlv")
    public suspend fun secondaryAllocationIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryAllocationIds = mapped
    }

    /**
     * @param value [Private NAT Gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT Gateway.
     */
    @JvmName("rdeqeivjsgyylgnk")
    public suspend fun secondaryPrivateIpAddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryPrivateIpAddressCount = mapped
    }

    /**
     * @param value A list of secondary private IPv4 addresses to assign to the NAT Gateway.
     */
    @JvmName("ahosythswsxwrwcr")
    public suspend fun secondaryPrivateIpAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryPrivateIpAddresses = mapped
    }

    /**
     * @param values A list of secondary private IPv4 addresses to assign to the NAT Gateway.
     */
    @JvmName("qajgdwbkyqrnvflf")
    public suspend fun secondaryPrivateIpAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryPrivateIpAddresses = mapped
    }

    /**
     * @param value The Subnet ID of the subnet in which to place the NAT Gateway.
     */
    @JvmName("uvevpucjxistdgjt")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("shsdjkcvkplujkmb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("essunlgypgdjswma")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NatGatewayArgs = NatGatewayArgs(
        allocationId = allocationId,
        connectivityType = connectivityType,
        privateIp = privateIp,
        secondaryAllocationIds = secondaryAllocationIds,
        secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount,
        secondaryPrivateIpAddresses = secondaryPrivateIpAddresses,
        subnetId = subnetId,
        tags = tags,
    )
}
