@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.NetworkAclEgress
import com.pulumi.aws.ec2.kotlin.outputs.NetworkAclIngress
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.NetworkAclEgress.Companion.toKotlin as networkAclEgressToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.NetworkAclIngress.Companion.toKotlin as networkAclIngressToKotlin

/**
 * Builder for [NetworkAcl].
 */
@PulumiTagMarker
public class NetworkAclResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkAclArgs = NetworkAclArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkAclArgsBuilder.() -> Unit) {
        val builder = NetworkAclArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkAcl {
        val builtJavaResource = com.pulumi.aws.ec2.NetworkAcl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkAcl(builtJavaResource)
    }
}

/**
 * Provides an network ACL resource. You might set up network ACLs with rules similar
 * to your security groups in order to add an additional layer of security to your VPC.
 * > **NOTE on Network ACLs and Network ACL Rules:** This provider currently
 * provides both a standalone Network ACL Rule resource and a Network ACL resource with rules
 * defined in-line. At this time you cannot use a Network ACL with in-line rules
 * in conjunction with any Network ACL Rule resources. Doing so will cause
 * a conflict of rule settings and will overwrite rules.
 * > **NOTE on Network ACLs and Network ACL Associations:** the provider provides both a standalone network ACL association
 * resource and a network ACL resource with a `subnet_ids` attribute. Do not use the same subnet ID in both a network ACL
 * resource and a network ACL association resource. Doing so will cause a conflict of associations and will overwrite the association.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.NetworkAcl("main", {
 *     vpcId: mainAwsVpc.id,
 *     egress: [{
 *         protocol: "tcp",
 *         ruleNo: 200,
 *         action: "allow",
 *         cidrBlock: "10.3.0.0/18",
 *         fromPort: 443,
 *         toPort: 443,
 *     }],
 *     ingress: [{
 *         protocol: "tcp",
 *         ruleNo: 100,
 *         action: "allow",
 *         cidrBlock: "10.3.0.0/18",
 *         fromPort: 80,
 *         toPort: 80,
 *     }],
 *     tags: {
 *         Name: "main",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.NetworkAcl("main",
 *     vpc_id=main_aws_vpc["id"],
 *     egress=[{
 *         "protocol": "tcp",
 *         "rule_no": 200,
 *         "action": "allow",
 *         "cidr_block": "10.3.0.0/18",
 *         "from_port": 443,
 *         "to_port": 443,
 *     }],
 *     ingress=[{
 *         "protocol": "tcp",
 *         "rule_no": 100,
 *         "action": "allow",
 *         "cidr_block": "10.3.0.0/18",
 *         "from_port": 80,
 *         "to_port": 80,
 *     }],
 *     tags={
 *         "Name": "main",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.NetworkAcl("main", new()
 *     {
 *         VpcId = mainAwsVpc.Id,
 *         Egress = new[]
 *         {
 *             new Aws.Ec2.Inputs.NetworkAclEgressArgs
 *             {
 *                 Protocol = "tcp",
 *                 RuleNo = 200,
 *                 Action = "allow",
 *                 CidrBlock = "10.3.0.0/18",
 *                 FromPort = 443,
 *                 ToPort = 443,
 *             },
 *         },
 *         Ingress = new[]
 *         {
 *             new Aws.Ec2.Inputs.NetworkAclIngressArgs
 *             {
 *                 Protocol = "tcp",
 *                 RuleNo = 100,
 *                 Action = "allow",
 *                 CidrBlock = "10.3.0.0/18",
 *                 FromPort = 80,
 *                 ToPort = 80,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "main" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewNetworkAcl(ctx, "main", &ec2.NetworkAclArgs{
 * 			VpcId: pulumi.Any(mainAwsVpc.Id),
 * 			Egress: ec2.NetworkAclEgressArray{
 * 				&ec2.NetworkAclEgressArgs{
 * 					Protocol:  pulumi.String("tcp"),
 * 					RuleNo:    pulumi.Int(200),
 * 					Action:    pulumi.String("allow"),
 * 					CidrBlock: pulumi.String("10.3.0.0/18"),
 * 					FromPort:  pulumi.Int(443),
 * 					ToPort:    pulumi.Int(443),
 * 				},
 * 			},
 * 			Ingress: ec2.NetworkAclIngressArray{
 * 				&ec2.NetworkAclIngressArgs{
 * 					Protocol:  pulumi.String("tcp"),
 * 					RuleNo:    pulumi.Int(100),
 * 					Action:    pulumi.String("allow"),
 * 					CidrBlock: pulumi.String("10.3.0.0/18"),
 * 					FromPort:  pulumi.Int(80),
 * 					ToPort:    pulumi.Int(80),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("main"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkAcl;
 * import com.pulumi.aws.ec2.NetworkAclArgs;
 * import com.pulumi.aws.ec2.inputs.NetworkAclEgressArgs;
 * import com.pulumi.aws.ec2.inputs.NetworkAclIngressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new NetworkAcl("main", NetworkAclArgs.builder()
 *             .vpcId(mainAwsVpc.id())
 *             .egress(NetworkAclEgressArgs.builder()
 *                 .protocol("tcp")
 *                 .ruleNo(200)
 *                 .action("allow")
 *                 .cidrBlock("10.3.0.0/18")
 *                 .fromPort(443)
 *                 .toPort(443)
 *                 .build())
 *             .ingress(NetworkAclIngressArgs.builder()
 *                 .protocol("tcp")
 *                 .ruleNo(100)
 *                 .action("allow")
 *                 .cidrBlock("10.3.0.0/18")
 *                 .fromPort(80)
 *                 .toPort(80)
 *                 .build())
 *             .tags(Map.of("Name", "main"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:ec2:NetworkAcl
 *     properties:
 *       vpcId: ${mainAwsVpc.id}
 *       egress:
 *         - protocol: tcp
 *           ruleNo: 200
 *           action: allow
 *           cidrBlock: 10.3.0.0/18
 *           fromPort: 443
 *           toPort: 443
 *       ingress:
 *         - protocol: tcp
 *           ruleNo: 100
 *           action: allow
 *           cidrBlock: 10.3.0.0/18
 *           fromPort: 80
 *           toPort: 80
 *       tags:
 *         Name: main
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Network ACLs using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/networkAcl:NetworkAcl main acl-7aaabd18
 * ```
 */
public class NetworkAcl internal constructor(
    override val javaResource: com.pulumi.aws.ec2.NetworkAcl,
) : KotlinCustomResource(javaResource, NetworkAclMapper) {
    /**
     * The ARN of the network ACL
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies an egress rule. Parameters defined below.
     */
    public val egress: Output<List<NetworkAclEgress>>
        get() = javaResource.egress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    networkAclEgressToKotlin(args0)
                })
            })
        })

    /**
     * Specifies an ingress rule. Parameters defined below.
     */
    public val ingress: Output<List<NetworkAclIngress>>
        get() = javaResource.ingress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    networkAclIngressToKotlin(args0)
                })
            })
        })

    /**
     * The ID of the AWS account that owns the network ACL.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * A list of Subnet IDs to apply the ACL to
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the associated VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object NetworkAclMapper : ResourceMapper<NetworkAcl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.NetworkAcl::class == javaResource::class

    override fun map(javaResource: Resource): NetworkAcl = NetworkAcl(
        javaResource as
            com.pulumi.aws.ec2.NetworkAcl,
    )
}

/**
 * @see [NetworkAcl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkAcl].
 */
public suspend fun networkAcl(name: String, block: suspend NetworkAclResourceBuilder.() -> Unit): NetworkAcl {
    val builder = NetworkAclResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkAcl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkAcl(name: String): NetworkAcl {
    val builder = NetworkAclResourceBuilder()
    builder.name(name)
    return builder.build()
}
