@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.NetworkAclArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.NetworkAclEgressArgs
import com.pulumi.aws.ec2.kotlin.inputs.NetworkAclEgressArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.NetworkAclIngressArgs
import com.pulumi.aws.ec2.kotlin.inputs.NetworkAclIngressArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an network ACL resource. You might set up network ACLs with rules similar
 * to your security groups in order to add an additional layer of security to your VPC.
 * > **NOTE on Network ACLs and Network ACL Rules:** This provider currently
 * provides both a standalone Network ACL Rule resource and a Network ACL resource with rules
 * defined in-line. At this time you cannot use a Network ACL with in-line rules
 * in conjunction with any Network ACL Rule resources. Doing so will cause
 * a conflict of rule settings and will overwrite rules.
 * > **NOTE on Network ACLs and Network ACL Associations:** the provider provides both a standalone network ACL association
 * resource and a network ACL resource with a `subnet_ids` attribute. Do not use the same subnet ID in both a network ACL
 * resource and a network ACL association resource. Doing so will cause a conflict of associations and will overwrite the association.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.NetworkAcl("main", {
 *     vpcId: mainAwsVpc.id,
 *     egress: [{
 *         protocol: "tcp",
 *         ruleNo: 200,
 *         action: "allow",
 *         cidrBlock: "10.3.0.0/18",
 *         fromPort: 443,
 *         toPort: 443,
 *     }],
 *     ingress: [{
 *         protocol: "tcp",
 *         ruleNo: 100,
 *         action: "allow",
 *         cidrBlock: "10.3.0.0/18",
 *         fromPort: 80,
 *         toPort: 80,
 *     }],
 *     tags: {
 *         Name: "main",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.NetworkAcl("main",
 *     vpc_id=main_aws_vpc["id"],
 *     egress=[{
 *         "protocol": "tcp",
 *         "rule_no": 200,
 *         "action": "allow",
 *         "cidr_block": "10.3.0.0/18",
 *         "from_port": 443,
 *         "to_port": 443,
 *     }],
 *     ingress=[{
 *         "protocol": "tcp",
 *         "rule_no": 100,
 *         "action": "allow",
 *         "cidr_block": "10.3.0.0/18",
 *         "from_port": 80,
 *         "to_port": 80,
 *     }],
 *     tags={
 *         "Name": "main",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.NetworkAcl("main", new()
 *     {
 *         VpcId = mainAwsVpc.Id,
 *         Egress = new[]
 *         {
 *             new Aws.Ec2.Inputs.NetworkAclEgressArgs
 *             {
 *                 Protocol = "tcp",
 *                 RuleNo = 200,
 *                 Action = "allow",
 *                 CidrBlock = "10.3.0.0/18",
 *                 FromPort = 443,
 *                 ToPort = 443,
 *             },
 *         },
 *         Ingress = new[]
 *         {
 *             new Aws.Ec2.Inputs.NetworkAclIngressArgs
 *             {
 *                 Protocol = "tcp",
 *                 RuleNo = 100,
 *                 Action = "allow",
 *                 CidrBlock = "10.3.0.0/18",
 *                 FromPort = 80,
 *                 ToPort = 80,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "main" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewNetworkAcl(ctx, "main", &ec2.NetworkAclArgs{
 * 			VpcId: pulumi.Any(mainAwsVpc.Id),
 * 			Egress: ec2.NetworkAclEgressArray{
 * 				&ec2.NetworkAclEgressArgs{
 * 					Protocol:  pulumi.String("tcp"),
 * 					RuleNo:    pulumi.Int(200),
 * 					Action:    pulumi.String("allow"),
 * 					CidrBlock: pulumi.String("10.3.0.0/18"),
 * 					FromPort:  pulumi.Int(443),
 * 					ToPort:    pulumi.Int(443),
 * 				},
 * 			},
 * 			Ingress: ec2.NetworkAclIngressArray{
 * 				&ec2.NetworkAclIngressArgs{
 * 					Protocol:  pulumi.String("tcp"),
 * 					RuleNo:    pulumi.Int(100),
 * 					Action:    pulumi.String("allow"),
 * 					CidrBlock: pulumi.String("10.3.0.0/18"),
 * 					FromPort:  pulumi.Int(80),
 * 					ToPort:    pulumi.Int(80),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("main"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkAcl;
 * import com.pulumi.aws.ec2.NetworkAclArgs;
 * import com.pulumi.aws.ec2.inputs.NetworkAclEgressArgs;
 * import com.pulumi.aws.ec2.inputs.NetworkAclIngressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new NetworkAcl("main", NetworkAclArgs.builder()
 *             .vpcId(mainAwsVpc.id())
 *             .egress(NetworkAclEgressArgs.builder()
 *                 .protocol("tcp")
 *                 .ruleNo(200)
 *                 .action("allow")
 *                 .cidrBlock("10.3.0.0/18")
 *                 .fromPort(443)
 *                 .toPort(443)
 *                 .build())
 *             .ingress(NetworkAclIngressArgs.builder()
 *                 .protocol("tcp")
 *                 .ruleNo(100)
 *                 .action("allow")
 *                 .cidrBlock("10.3.0.0/18")
 *                 .fromPort(80)
 *                 .toPort(80)
 *                 .build())
 *             .tags(Map.of("Name", "main"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:ec2:NetworkAcl
 *     properties:
 *       vpcId: ${mainAwsVpc.id}
 *       egress:
 *         - protocol: tcp
 *           ruleNo: 200
 *           action: allow
 *           cidrBlock: 10.3.0.0/18
 *           fromPort: 443
 *           toPort: 443
 *       ingress:
 *         - protocol: tcp
 *           ruleNo: 100
 *           action: allow
 *           cidrBlock: 10.3.0.0/18
 *           fromPort: 80
 *           toPort: 80
 *       tags:
 *         Name: main
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Network ACLs using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/networkAcl:NetworkAcl main acl-7aaabd18
 * ```
 * @property egress Specifies an egress rule. Parameters defined below.
 * @property ingress Specifies an ingress rule. Parameters defined below.
 * @property subnetIds A list of Subnet IDs to apply the ACL to
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcId The ID of the associated VPC.
 */
public data class NetworkAclArgs(
    public val egress: Output<List<NetworkAclEgressArgs>>? = null,
    public val ingress: Output<List<NetworkAclIngressArgs>>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.NetworkAclArgs> {
    override fun toJava(): com.pulumi.aws.ec2.NetworkAclArgs =
        com.pulumi.aws.ec2.NetworkAclArgs.builder()
            .egress(egress?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .ingress(
                ingress?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAclArgs].
 */
@PulumiTagMarker
public class NetworkAclArgsBuilder internal constructor() {
    private var egress: Output<List<NetworkAclEgressArgs>>? = null

    private var ingress: Output<List<NetworkAclIngressArgs>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Specifies an egress rule. Parameters defined below.
     */
    @JvmName("hlbrvwlqdolryxac")
    public suspend fun egress(`value`: Output<List<NetworkAclEgressArgs>>) {
        this.egress = value
    }

    @JvmName("owhnbkvrvmxjsbjx")
    public suspend fun egress(vararg values: Output<NetworkAclEgressArgs>) {
        this.egress = Output.all(values.asList())
    }

    /**
     * @param values Specifies an egress rule. Parameters defined below.
     */
    @JvmName("fvvsbbdvviqbkoni")
    public suspend fun egress(values: List<Output<NetworkAclEgressArgs>>) {
        this.egress = Output.all(values)
    }

    /**
     * @param value Specifies an ingress rule. Parameters defined below.
     */
    @JvmName("qihgtpypmmbnysfw")
    public suspend fun ingress(`value`: Output<List<NetworkAclIngressArgs>>) {
        this.ingress = value
    }

    @JvmName("qvpvtjvuktobomdn")
    public suspend fun ingress(vararg values: Output<NetworkAclIngressArgs>) {
        this.ingress = Output.all(values.asList())
    }

    /**
     * @param values Specifies an ingress rule. Parameters defined below.
     */
    @JvmName("tmgjayltiuhdeuvt")
    public suspend fun ingress(values: List<Output<NetworkAclIngressArgs>>) {
        this.ingress = Output.all(values)
    }

    /**
     * @param value A list of Subnet IDs to apply the ACL to
     */
    @JvmName("iiyxkyjmmujolcvx")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("gvwcwxlllhxigofb")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of Subnet IDs to apply the ACL to
     */
    @JvmName("anbpejfhdxyucfsi")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mnmwpihxeyvoctcn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the associated VPC.
     */
    @JvmName("mbooybkeotwrhxkc")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Specifies an egress rule. Parameters defined below.
     */
    @JvmName("oilhcwbtjsboiafw")
    public suspend fun egress(`value`: List<NetworkAclEgressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egress = mapped
    }

    /**
     * @param argument Specifies an egress rule. Parameters defined below.
     */
    @JvmName("qfcofytbfxqyvdmg")
    public suspend fun egress(argument: List<suspend NetworkAclEgressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkAclEgressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.egress = mapped
    }

    /**
     * @param argument Specifies an egress rule. Parameters defined below.
     */
    @JvmName("wiviubykfmlockie")
    public suspend fun egress(vararg argument: suspend NetworkAclEgressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NetworkAclEgressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.egress = mapped
    }

    /**
     * @param argument Specifies an egress rule. Parameters defined below.
     */
    @JvmName("uedlhklmypultvtu")
    public suspend fun egress(argument: suspend NetworkAclEgressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NetworkAclEgressArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.egress = mapped
    }

    /**
     * @param values Specifies an egress rule. Parameters defined below.
     */
    @JvmName("olhrukteexpagkxl")
    public suspend fun egress(vararg values: NetworkAclEgressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.egress = mapped
    }

    /**
     * @param value Specifies an ingress rule. Parameters defined below.
     */
    @JvmName("bsfhvlidqljpnseo")
    public suspend fun ingress(`value`: List<NetworkAclIngressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingress = mapped
    }

    /**
     * @param argument Specifies an ingress rule. Parameters defined below.
     */
    @JvmName("wrhlxfyvwlwloyxx")
    public suspend fun ingress(argument: List<suspend NetworkAclIngressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkAclIngressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ingress = mapped
    }

    /**
     * @param argument Specifies an ingress rule. Parameters defined below.
     */
    @JvmName("xtwpycbnhbknkrdc")
    public suspend fun ingress(vararg argument: suspend NetworkAclIngressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NetworkAclIngressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ingress = mapped
    }

    /**
     * @param argument Specifies an ingress rule. Parameters defined below.
     */
    @JvmName("pqiosnksbpalcbia")
    public suspend fun ingress(argument: suspend NetworkAclIngressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NetworkAclIngressArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ingress = mapped
    }

    /**
     * @param values Specifies an ingress rule. Parameters defined below.
     */
    @JvmName("qthgwdxoxlyjifvn")
    public suspend fun ingress(vararg values: NetworkAclIngressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingress = mapped
    }

    /**
     * @param value A list of Subnet IDs to apply the ACL to
     */
    @JvmName("ugycqrkjohojluqe")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of Subnet IDs to apply the ACL to
     */
    @JvmName("uakoddwchnjadujg")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kjrrpbxealeqhivy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kdpiutkyfwdjinfk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the associated VPC.
     */
    @JvmName("whxnmpgqubkslmso")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): NetworkAclArgs = NetworkAclArgs(
        egress = egress,
        ingress = ingress,
        subnetIds = subnetIds,
        tags = tags,
        vpcId = vpcId,
    )
}
