@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.NetworkAclAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an network ACL association resource which allows you to associate your network ACL with any subnet(s).
 * > **NOTE on Network ACLs and Network ACL Associations:** the provider provides both a standalone network ACL association resource
 * and a network ACL resource with a `subnet_ids` attribute. Do not use the same subnet ID in both a network ACL
 * resource and a network ACL association resource. Doing so will cause a conflict of associations and will overwrite the association.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.NetworkAclAssociation("main", {
 *     networkAclId: mainAwsNetworkAcl.id,
 *     subnetId: mainAwsSubnet.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.NetworkAclAssociation("main",
 *     network_acl_id=main_aws_network_acl["id"],
 *     subnet_id=main_aws_subnet["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.NetworkAclAssociation("main", new()
 *     {
 *         NetworkAclId = mainAwsNetworkAcl.Id,
 *         SubnetId = mainAwsSubnet.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewNetworkAclAssociation(ctx, "main", &ec2.NetworkAclAssociationArgs{
 * 			NetworkAclId: pulumi.Any(mainAwsNetworkAcl.Id),
 * 			SubnetId:     pulumi.Any(mainAwsSubnet.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkAclAssociation;
 * import com.pulumi.aws.ec2.NetworkAclAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new NetworkAclAssociation("main", NetworkAclAssociationArgs.builder()
 *             .networkAclId(mainAwsNetworkAcl.id())
 *             .subnetId(mainAwsSubnet.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:ec2:NetworkAclAssociation
 *     properties:
 *       networkAclId: ${mainAwsNetworkAcl.id}
 *       subnetId: ${mainAwsSubnet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Network ACL associations using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/networkAclAssociation:NetworkAclAssociation main aclassoc-02baf37f20966b3e6
 * ```
 * @property networkAclId The ID of the network ACL.
 * @property subnetId The ID of the associated Subnet.
 */
public data class NetworkAclAssociationArgs(
    public val networkAclId: Output<String>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.NetworkAclAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.NetworkAclAssociationArgs =
        com.pulumi.aws.ec2.NetworkAclAssociationArgs.builder()
            .networkAclId(networkAclId?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAclAssociationArgs].
 */
@PulumiTagMarker
public class NetworkAclAssociationArgsBuilder internal constructor() {
    private var networkAclId: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value The ID of the network ACL.
     */
    @JvmName("ucopifvopambpdpm")
    public suspend fun networkAclId(`value`: Output<String>) {
        this.networkAclId = value
    }

    /**
     * @param value The ID of the associated Subnet.
     */
    @JvmName("fqtlyhcwyydjhtvy")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The ID of the network ACL.
     */
    @JvmName("gymwkcnpkhaoavyc")
    public suspend fun networkAclId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAclId = mapped
    }

    /**
     * @param value The ID of the associated Subnet.
     */
    @JvmName("yxpsbhvbnshwrdag")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): NetworkAclAssociationArgs = NetworkAclAssociationArgs(
        networkAclId = networkAclId,
        subnetId = subnetId,
    )
}
