@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.NetworkAclRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates an entry (a rule) in a network ACL with the specified rule number.
 * > **NOTE on Network ACLs and Network ACL Rules:** This provider currently
 * provides both a standalone Network ACL Rule resource and a Network ACL resource with rules
 * defined in-line. At this time you cannot use a Network ACL with in-line rules
 * in conjunction with any Network ACL Rule resources. Doing so will cause
 * a conflict of rule settings and will overwrite rules.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const bar = new aws.ec2.NetworkAcl("bar", {vpcId: foo.id});
 * const barNetworkAclRule = new aws.ec2.NetworkAclRule("bar", {
 *     networkAclId: bar.id,
 *     ruleNumber: 200,
 *     egress: false,
 *     protocol: "tcp",
 *     ruleAction: "allow",
 *     cidrBlock: foo.cidrBlock,
 *     fromPort: 22,
 *     toPort: 22,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * bar = aws.ec2.NetworkAcl("bar", vpc_id=foo["id"])
 * bar_network_acl_rule = aws.ec2.NetworkAclRule("bar",
 *     network_acl_id=bar.id,
 *     rule_number=200,
 *     egress=False,
 *     protocol="tcp",
 *     rule_action="allow",
 *     cidr_block=foo["cidrBlock"],
 *     from_port=22,
 *     to_port=22)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bar = new Aws.Ec2.NetworkAcl("bar", new()
 *     {
 *         VpcId = foo.Id,
 *     });
 *     var barNetworkAclRule = new Aws.Ec2.NetworkAclRule("bar", new()
 *     {
 *         NetworkAclId = bar.Id,
 *         RuleNumber = 200,
 *         Egress = false,
 *         Protocol = "tcp",
 *         RuleAction = "allow",
 *         CidrBlock = foo.CidrBlock,
 *         FromPort = 22,
 *         ToPort = 22,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		bar, err := ec2.NewNetworkAcl(ctx, "bar", &ec2.NetworkAclArgs{
 * 			VpcId: pulumi.Any(foo.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewNetworkAclRule(ctx, "bar", &ec2.NetworkAclRuleArgs{
 * 			NetworkAclId: bar.ID(),
 * 			RuleNumber:   pulumi.Int(200),
 * 			Egress:       pulumi.Bool(false),
 * 			Protocol:     pulumi.String("tcp"),
 * 			RuleAction:   pulumi.String("allow"),
 * 			CidrBlock:    pulumi.Any(foo.CidrBlock),
 * 			FromPort:     pulumi.Int(22),
 * 			ToPort:       pulumi.Int(22),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkAcl;
 * import com.pulumi.aws.ec2.NetworkAclArgs;
 * import com.pulumi.aws.ec2.NetworkAclRule;
 * import com.pulumi.aws.ec2.NetworkAclRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new NetworkAcl("bar", NetworkAclArgs.builder()
 *             .vpcId(foo.id())
 *             .build());
 *         var barNetworkAclRule = new NetworkAclRule("barNetworkAclRule", NetworkAclRuleArgs.builder()
 *             .networkAclId(bar.id())
 *             .ruleNumber(200)
 *             .egress(false)
 *             .protocol("tcp")
 *             .ruleAction("allow")
 *             .cidrBlock(foo.cidrBlock())
 *             .fromPort(22)
 *             .toPort(22)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:ec2:NetworkAcl
 *     properties:
 *       vpcId: ${foo.id}
 *   barNetworkAclRule:
 *     type: aws:ec2:NetworkAclRule
 *     name: bar
 *     properties:
 *       networkAclId: ${bar.id}
 *       ruleNumber: 200
 *       egress: false
 *       protocol: tcp
 *       ruleAction: allow
 *       cidrBlock: ${foo.cidrBlock}
 *       fromPort: 22
 *       toPort: 22
 * ```
 * <!--End PulumiCodeChooser -->
 * > **Note:** One of either `cidr_block` or `ipv6_cidr_block` is required.
 * ## Import
 * Using the procotol's decimal value:
 * __Using `pulumi import` to import__ individual rules using `NETWORK_ACL_ID:RULE_NUMBER:PROTOCOL:EGRESS`, where `PROTOCOL` can be a decimal (such as "6") or string (such as "tcp") value. For example:
 * Using the procotol's string value:
 * ```sh
 * $ pulumi import aws:ec2/networkAclRule:NetworkAclRule my_rule acl-7aaabd18:100:tcp:false
 * ```
 * Using the procotol's decimal value:
 * ```sh
 * $ pulumi import aws:ec2/networkAclRule:NetworkAclRule my_rule acl-7aaabd18:100:6:false
 * ```
 * @property cidrBlock The network range to allow or deny, in CIDR notation (for example 172.16.0.0/24 ).
 * @property egress Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet). Default `false`.
 * @property fromPort The from port to match.
 * @property icmpCode ICMP protocol: The ICMP code. Required if specifying ICMP for the protocolE.g., -1
 * > **NOTE:** If the value of `protocol` is `-1` or `all`, the `from_port` and `to_port` values will be ignored and the rule will apply to all ports.
 * > **NOTE:** If the value of `icmp_type` is `-1` (which results in a wildcard ICMP type), the `icmp_code` must also be set to `-1` (wildcard ICMP code).
 * > Note: For more information on ICMP types and codes, see here: https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml
 * @property icmpType ICMP protocol: The ICMP type. Required if specifying ICMP for the protocolE.g., -1
 * @property ipv6CidrBlock The IPv6 CIDR block to allow or deny.
 * @property networkAclId The ID of the network ACL.
 * @property protocol The protocol. A value of -1 means all protocols.
 * @property ruleAction Indicates whether to allow or deny the traffic that matches the rule. Accepted values: `allow` | `deny`
 * @property ruleNumber The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.
 * @property toPort The to port to match.
 */
public data class NetworkAclRuleArgs(
    public val cidrBlock: Output<String>? = null,
    public val egress: Output<Boolean>? = null,
    public val fromPort: Output<Int>? = null,
    public val icmpCode: Output<Int>? = null,
    public val icmpType: Output<Int>? = null,
    public val ipv6CidrBlock: Output<String>? = null,
    public val networkAclId: Output<String>? = null,
    public val protocol: Output<String>? = null,
    public val ruleAction: Output<String>? = null,
    public val ruleNumber: Output<Int>? = null,
    public val toPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.NetworkAclRuleArgs> {
    override fun toJava(): com.pulumi.aws.ec2.NetworkAclRuleArgs =
        com.pulumi.aws.ec2.NetworkAclRuleArgs.builder()
            .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
            .egress(egress?.applyValue({ args0 -> args0 }))
            .fromPort(fromPort?.applyValue({ args0 -> args0 }))
            .icmpCode(icmpCode?.applyValue({ args0 -> args0 }))
            .icmpType(icmpType?.applyValue({ args0 -> args0 }))
            .ipv6CidrBlock(ipv6CidrBlock?.applyValue({ args0 -> args0 }))
            .networkAclId(networkAclId?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .ruleAction(ruleAction?.applyValue({ args0 -> args0 }))
            .ruleNumber(ruleNumber?.applyValue({ args0 -> args0 }))
            .toPort(toPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAclRuleArgs].
 */
@PulumiTagMarker
public class NetworkAclRuleArgsBuilder internal constructor() {
    private var cidrBlock: Output<String>? = null

    private var egress: Output<Boolean>? = null

    private var fromPort: Output<Int>? = null

    private var icmpCode: Output<Int>? = null

    private var icmpType: Output<Int>? = null

    private var ipv6CidrBlock: Output<String>? = null

    private var networkAclId: Output<String>? = null

    private var protocol: Output<String>? = null

    private var ruleAction: Output<String>? = null

    private var ruleNumber: Output<Int>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value The network range to allow or deny, in CIDR notation (for example 172.16.0.0/24 ).
     */
    @JvmName("dftcgodrlyjiitxi")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet). Default `false`.
     */
    @JvmName("nohfwkbpcoxlghtf")
    public suspend fun egress(`value`: Output<Boolean>) {
        this.egress = value
    }

    /**
     * @param value The from port to match.
     */
    @JvmName("tgyugmhofdptxjps")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value ICMP protocol: The ICMP code. Required if specifying ICMP for the protocolE.g., -1
     * > **NOTE:** If the value of `protocol` is `-1` or `all`, the `from_port` and `to_port` values will be ignored and the rule will apply to all ports.
     * > **NOTE:** If the value of `icmp_type` is `-1` (which results in a wildcard ICMP type), the `icmp_code` must also be set to `-1` (wildcard ICMP code).
     * > Note: For more information on ICMP types and codes, see here: https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml
     */
    @JvmName("hmlmouolkgmpfggr")
    public suspend fun icmpCode(`value`: Output<Int>) {
        this.icmpCode = value
    }

    /**
     * @param value ICMP protocol: The ICMP type. Required if specifying ICMP for the protocolE.g., -1
     */
    @JvmName("kksbmfyibkckhdgx")
    public suspend fun icmpType(`value`: Output<Int>) {
        this.icmpType = value
    }

    /**
     * @param value The IPv6 CIDR block to allow or deny.
     */
    @JvmName("uupmpvgtblmivpqs")
    public suspend fun ipv6CidrBlock(`value`: Output<String>) {
        this.ipv6CidrBlock = value
    }

    /**
     * @param value The ID of the network ACL.
     */
    @JvmName("grxnthhiktsdbjuf")
    public suspend fun networkAclId(`value`: Output<String>) {
        this.networkAclId = value
    }

    /**
     * @param value The protocol. A value of -1 means all protocols.
     */
    @JvmName("miyactheoglbggdr")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Indicates whether to allow or deny the traffic that matches the rule. Accepted values: `allow` | `deny`
     */
    @JvmName("vqkexfiaxsgrudvx")
    public suspend fun ruleAction(`value`: Output<String>) {
        this.ruleAction = value
    }

    /**
     * @param value The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.
     */
    @JvmName("eyavpwtagfcxqejt")
    public suspend fun ruleNumber(`value`: Output<Int>) {
        this.ruleNumber = value
    }

    /**
     * @param value The to port to match.
     */
    @JvmName("lcpwoqkjhumjjtxv")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value The network range to allow or deny, in CIDR notation (for example 172.16.0.0/24 ).
     */
    @JvmName("wthjuycwtftehbpa")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet). Default `false`.
     */
    @JvmName("bjfnmjaukqmufmrd")
    public suspend fun egress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egress = mapped
    }

    /**
     * @param value The from port to match.
     */
    @JvmName("efxliuqxbwtxjtwm")
    public suspend fun fromPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value ICMP protocol: The ICMP code. Required if specifying ICMP for the protocolE.g., -1
     * > **NOTE:** If the value of `protocol` is `-1` or `all`, the `from_port` and `to_port` values will be ignored and the rule will apply to all ports.
     * > **NOTE:** If the value of `icmp_type` is `-1` (which results in a wildcard ICMP type), the `icmp_code` must also be set to `-1` (wildcard ICMP code).
     * > Note: For more information on ICMP types and codes, see here: https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml
     */
    @JvmName("nafdgmawwcaaatrg")
    public suspend fun icmpCode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.icmpCode = mapped
    }

    /**
     * @param value ICMP protocol: The ICMP type. Required if specifying ICMP for the protocolE.g., -1
     */
    @JvmName("neggipyuwwqghnih")
    public suspend fun icmpType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.icmpType = mapped
    }

    /**
     * @param value The IPv6 CIDR block to allow or deny.
     */
    @JvmName("iullccgqphcupdjj")
    public suspend fun ipv6CidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlock = mapped
    }

    /**
     * @param value The ID of the network ACL.
     */
    @JvmName("pglcihyukfiwcbrp")
    public suspend fun networkAclId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAclId = mapped
    }

    /**
     * @param value The protocol. A value of -1 means all protocols.
     */
    @JvmName("wonaeqwowybpxcqe")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Indicates whether to allow or deny the traffic that matches the rule. Accepted values: `allow` | `deny`
     */
    @JvmName("wudboajdobijfwgl")
    public suspend fun ruleAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleAction = mapped
    }

    /**
     * @param value The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.
     */
    @JvmName("rrrndqyuivguiinx")
    public suspend fun ruleNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleNumber = mapped
    }

    /**
     * @param value The to port to match.
     */
    @JvmName("lurgbkuljibxpupm")
    public suspend fun toPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): NetworkAclRuleArgs = NetworkAclRuleArgs(
        cidrBlock = cidrBlock,
        egress = egress,
        fromPort = fromPort,
        icmpCode = icmpCode,
        icmpType = icmpType,
        ipv6CidrBlock = ipv6CidrBlock,
        networkAclId = networkAclId,
        protocol = protocol,
        ruleAction = ruleAction,
        ruleNumber = ruleNumber,
        toPort = toPort,
    )
}
