@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.NetworkInsightsAnalysisArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Network Insights Analysis resource. Part of the "Reachability Analyzer" service in the AWS VPC console.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const path = new aws.ec2.NetworkInsightsPath("path", {
 *     source: source.id,
 *     destination: destination.id,
 *     protocol: "tcp",
 * });
 * const analysis = new aws.ec2.NetworkInsightsAnalysis("analysis", {networkInsightsPathId: path.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * path = aws.ec2.NetworkInsightsPath("path",
 *     source=source["id"],
 *     destination=destination["id"],
 *     protocol="tcp")
 * analysis = aws.ec2.NetworkInsightsAnalysis("analysis", network_insights_path_id=path.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var path = new Aws.Ec2.NetworkInsightsPath("path", new()
 *     {
 *         Source = source.Id,
 *         Destination = destination.Id,
 *         Protocol = "tcp",
 *     });
 *     var analysis = new Aws.Ec2.NetworkInsightsAnalysis("analysis", new()
 *     {
 *         NetworkInsightsPathId = path.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		path, err := ec2.NewNetworkInsightsPath(ctx, "path", &ec2.NetworkInsightsPathArgs{
 * 			Source:      pulumi.Any(source.Id),
 * 			Destination: pulumi.Any(destination.Id),
 * 			Protocol:    pulumi.String("tcp"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewNetworkInsightsAnalysis(ctx, "analysis", &ec2.NetworkInsightsAnalysisArgs{
 * 			NetworkInsightsPathId: path.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkInsightsPath;
 * import com.pulumi.aws.ec2.NetworkInsightsPathArgs;
 * import com.pulumi.aws.ec2.NetworkInsightsAnalysis;
 * import com.pulumi.aws.ec2.NetworkInsightsAnalysisArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var path = new NetworkInsightsPath("path", NetworkInsightsPathArgs.builder()
 *             .source(source.id())
 *             .destination(destination.id())
 *             .protocol("tcp")
 *             .build());
 *         var analysis = new NetworkInsightsAnalysis("analysis", NetworkInsightsAnalysisArgs.builder()
 *             .networkInsightsPathId(path.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   path:
 *     type: aws:ec2:NetworkInsightsPath
 *     properties:
 *       source: ${source.id}
 *       destination: ${destination.id}
 *       protocol: tcp
 *   analysis:
 *     type: aws:ec2:NetworkInsightsAnalysis
 *     properties:
 *       networkInsightsPathId: ${path.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Network Insights Analyzes using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/networkInsightsAnalysis:NetworkInsightsAnalysis test nia-0462085c957f11a55
 * ```
 * @property filterInArns A list of ARNs for resources the path must traverse.
 * @property networkInsightsPathId ID of the Network Insights Path to run an analysis on.
 * The following arguments are optional:
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property waitForCompletion If enabled, the resource will wait for the Network Insights Analysis status to change to `succeeded` or `failed`. Setting this to `false` will skip the process. Default: `true`.
 */
public data class NetworkInsightsAnalysisArgs(
    public val filterInArns: Output<List<String>>? = null,
    public val networkInsightsPathId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val waitForCompletion: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.NetworkInsightsAnalysisArgs> {
    override fun toJava(): com.pulumi.aws.ec2.NetworkInsightsAnalysisArgs =
        com.pulumi.aws.ec2.NetworkInsightsAnalysisArgs.builder()
            .filterInArns(filterInArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .networkInsightsPathId(networkInsightsPathId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .waitForCompletion(waitForCompletion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInsightsAnalysisArgs].
 */
@PulumiTagMarker
public class NetworkInsightsAnalysisArgsBuilder internal constructor() {
    private var filterInArns: Output<List<String>>? = null

    private var networkInsightsPathId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var waitForCompletion: Output<Boolean>? = null

    /**
     * @param value A list of ARNs for resources the path must traverse.
     */
    @JvmName("nnuxthmnqcwhdkni")
    public suspend fun filterInArns(`value`: Output<List<String>>) {
        this.filterInArns = value
    }

    @JvmName("rumwamwudixfoywo")
    public suspend fun filterInArns(vararg values: Output<String>) {
        this.filterInArns = Output.all(values.asList())
    }

    /**
     * @param values A list of ARNs for resources the path must traverse.
     */
    @JvmName("tfkusnyvyvqjymfm")
    public suspend fun filterInArns(values: List<Output<String>>) {
        this.filterInArns = Output.all(values)
    }

    /**
     * @param value ID of the Network Insights Path to run an analysis on.
     * The following arguments are optional:
     */
    @JvmName("huieustttfgdrtqr")
    public suspend fun networkInsightsPathId(`value`: Output<String>) {
        this.networkInsightsPathId = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lwpdehgcamxtueqj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value If enabled, the resource will wait for the Network Insights Analysis status to change to `succeeded` or `failed`. Setting this to `false` will skip the process. Default: `true`.
     */
    @JvmName("gllhldtaensllofc")
    public suspend fun waitForCompletion(`value`: Output<Boolean>) {
        this.waitForCompletion = value
    }

    /**
     * @param value A list of ARNs for resources the path must traverse.
     */
    @JvmName("ptogrtxypmwhljas")
    public suspend fun filterInArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterInArns = mapped
    }

    /**
     * @param values A list of ARNs for resources the path must traverse.
     */
    @JvmName("dwrnvvjsojvdekhc")
    public suspend fun filterInArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterInArns = mapped
    }

    /**
     * @param value ID of the Network Insights Path to run an analysis on.
     * The following arguments are optional:
     */
    @JvmName("xlelsfroqpyubrnb")
    public suspend fun networkInsightsPathId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInsightsPathId = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qxtoxkslrsojvfvn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hpxjyktdwputfbjl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value If enabled, the resource will wait for the Network Insights Analysis status to change to `succeeded` or `failed`. Setting this to `false` will skip the process. Default: `true`.
     */
    @JvmName("watmdopmbiauxkjp")
    public suspend fun waitForCompletion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForCompletion = mapped
    }

    internal fun build(): NetworkInsightsAnalysisArgs = NetworkInsightsAnalysisArgs(
        filterInArns = filterInArns,
        networkInsightsPathId = networkInsightsPathId,
        tags = tags,
        waitForCompletion = waitForCompletion,
    )
}
