@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.NetworkInsightsPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Network Insights Path resource. Part of the "Reachability Analyzer" service in the AWS VPC console.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.ec2.NetworkInsightsPath("test", {
 *     source: source.id,
 *     destination: destination.id,
 *     protocol: "tcp",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.ec2.NetworkInsightsPath("test",
 *     source=source["id"],
 *     destination=destination["id"],
 *     protocol="tcp")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Ec2.NetworkInsightsPath("test", new()
 *     {
 *         Source = source.Id,
 *         Destination = destination.Id,
 *         Protocol = "tcp",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewNetworkInsightsPath(ctx, "test", &ec2.NetworkInsightsPathArgs{
 * 			Source:      pulumi.Any(source.Id),
 * 			Destination: pulumi.Any(destination.Id),
 * 			Protocol:    pulumi.String("tcp"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkInsightsPath;
 * import com.pulumi.aws.ec2.NetworkInsightsPathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new NetworkInsightsPath("test", NetworkInsightsPathArgs.builder()
 *             .source(source.id())
 *             .destination(destination.id())
 *             .protocol("tcp")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:ec2:NetworkInsightsPath
 *     properties:
 *       source: ${source.id}
 *       destination: ${destination.id}
 *       protocol: tcp
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Network Insights Paths using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/networkInsightsPath:NetworkInsightsPath test nip-00edfba169923aefd
 * ```
 * @property destination ID or ARN of the resource which is the destination of the path. Can be an Instance, Internet Gateway, Network Interface, Transit Gateway, VPC Endpoint, VPC Peering Connection or VPN Gateway. If the resource is in another account, you must specify an ARN.
 * @property destinationIp IP address of the destination resource.
 * @property destinationPort Destination port to analyze access to.
 * @property protocol Protocol to use for analysis. Valid options are `tcp` or `udp`.
 * The following arguments are optional:
 * @property source ID or ARN of the resource which is the source of the path. Can be an Instance, Internet Gateway, Network Interface, Transit Gateway, VPC Endpoint, VPC Peering Connection or VPN Gateway. If the resource is in another account, you must specify an ARN.
 * @property sourceIp IP address of the source resource.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class NetworkInsightsPathArgs(
    public val destination: Output<String>? = null,
    public val destinationIp: Output<String>? = null,
    public val destinationPort: Output<Int>? = null,
    public val protocol: Output<String>? = null,
    public val source: Output<String>? = null,
    public val sourceIp: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.NetworkInsightsPathArgs> {
    override fun toJava(): com.pulumi.aws.ec2.NetworkInsightsPathArgs =
        com.pulumi.aws.ec2.NetworkInsightsPathArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0 }))
            .destinationIp(destinationIp?.applyValue({ args0 -> args0 }))
            .destinationPort(destinationPort?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .sourceIp(sourceIp?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkInsightsPathArgs].
 */
@PulumiTagMarker
public class NetworkInsightsPathArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    private var destinationIp: Output<String>? = null

    private var destinationPort: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var source: Output<String>? = null

    private var sourceIp: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value ID or ARN of the resource which is the destination of the path. Can be an Instance, Internet Gateway, Network Interface, Transit Gateway, VPC Endpoint, VPC Peering Connection or VPN Gateway. If the resource is in another account, you must specify an ARN.
     */
    @JvmName("ubpoxqjmcjmbnotb")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value IP address of the destination resource.
     */
    @JvmName("vcngukehnmycbxdw")
    public suspend fun destinationIp(`value`: Output<String>) {
        this.destinationIp = value
    }

    /**
     * @param value Destination port to analyze access to.
     */
    @JvmName("gxbqsalbmjiucdcr")
    public suspend fun destinationPort(`value`: Output<Int>) {
        this.destinationPort = value
    }

    /**
     * @param value Protocol to use for analysis. Valid options are `tcp` or `udp`.
     * The following arguments are optional:
     */
    @JvmName("fvuqmtlyoosnsjmx")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value ID or ARN of the resource which is the source of the path. Can be an Instance, Internet Gateway, Network Interface, Transit Gateway, VPC Endpoint, VPC Peering Connection or VPN Gateway. If the resource is in another account, you must specify an ARN.
     */
    @JvmName("duqykqxdukqqyitf")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value IP address of the source resource.
     */
    @JvmName("vrmdvvtyfemwjdsr")
    public suspend fun sourceIp(`value`: Output<String>) {
        this.sourceIp = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xtxbibixfyhdlfmh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ID or ARN of the resource which is the destination of the path. Can be an Instance, Internet Gateway, Network Interface, Transit Gateway, VPC Endpoint, VPC Peering Connection or VPN Gateway. If the resource is in another account, you must specify an ARN.
     */
    @JvmName("srehumffeddlkvmq")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value IP address of the destination resource.
     */
    @JvmName("txmgbvgjkyaqbyjb")
    public suspend fun destinationIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationIp = mapped
    }

    /**
     * @param value Destination port to analyze access to.
     */
    @JvmName("pjwnckhgqtrbuwvf")
    public suspend fun destinationPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPort = mapped
    }

    /**
     * @param value Protocol to use for analysis. Valid options are `tcp` or `udp`.
     * The following arguments are optional:
     */
    @JvmName("tmdnkfsqkdxiielb")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value ID or ARN of the resource which is the source of the path. Can be an Instance, Internet Gateway, Network Interface, Transit Gateway, VPC Endpoint, VPC Peering Connection or VPN Gateway. If the resource is in another account, you must specify an ARN.
     */
    @JvmName("ssbpgatwdepxjnys")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value IP address of the source resource.
     */
    @JvmName("vjwjnuhuibmdmiwk")
    public suspend fun sourceIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIp = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cosphhvhqhayjqli")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("oyikchvylswjcmoy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkInsightsPathArgs = NetworkInsightsPathArgs(
        destination = destination,
        destinationIp = destinationIp,
        destinationPort = destinationPort,
        protocol = protocol,
        source = source,
        sourceIp = sourceIp,
        tags = tags,
    )
}
