@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.NetworkInterfaceAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attach an Elastic network interface (ENI) resource with EC2 instance.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.ec2.NetworkInterfaceAttachment("test", {
 *     instanceId: testAwsInstance.id,
 *     networkInterfaceId: testAwsNetworkInterface.id,
 *     deviceIndex: 0,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.ec2.NetworkInterfaceAttachment("test",
 *     instance_id=test_aws_instance["id"],
 *     network_interface_id=test_aws_network_interface["id"],
 *     device_index=0)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Ec2.NetworkInterfaceAttachment("test", new()
 *     {
 *         InstanceId = testAwsInstance.Id,
 *         NetworkInterfaceId = testAwsNetworkInterface.Id,
 *         DeviceIndex = 0,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewNetworkInterfaceAttachment(ctx, "test", &ec2.NetworkInterfaceAttachmentArgs{
 * 			InstanceId:         pulumi.Any(testAwsInstance.Id),
 * 			NetworkInterfaceId: pulumi.Any(testAwsNetworkInterface.Id),
 * 			DeviceIndex:        pulumi.Int(0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkInterfaceAttachment;
 * import com.pulumi.aws.ec2.NetworkInterfaceAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new NetworkInterfaceAttachment("test", NetworkInterfaceAttachmentArgs.builder()
 *             .instanceId(testAwsInstance.id())
 *             .networkInterfaceId(testAwsNetworkInterface.id())
 *             .deviceIndex(0)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:ec2:NetworkInterfaceAttachment
 *     properties:
 *       instanceId: ${testAwsInstance.id}
 *       networkInterfaceId: ${testAwsNetworkInterface.id}
 *       deviceIndex: 0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Elastic network interface (ENI) Attachments using its Attachment ID. For example:
 * ```sh
 * $ pulumi import aws:ec2/networkInterfaceAttachment:NetworkInterfaceAttachment secondary_nic eni-attach-0a33842b4ec347c4c
 * ```
 * @property deviceIndex Network interface index (int).
 * @property instanceId Instance ID to attach.
 * @property networkInterfaceId ENI ID to attach.
 */
public data class NetworkInterfaceAttachmentArgs(
    public val deviceIndex: Output<Int>? = null,
    public val instanceId: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.NetworkInterfaceAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.ec2.NetworkInterfaceAttachmentArgs =
        com.pulumi.aws.ec2.NetworkInterfaceAttachmentArgs.builder()
            .deviceIndex(deviceIndex?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInterfaceAttachmentArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceAttachmentArgsBuilder internal constructor() {
    private var deviceIndex: Output<Int>? = null

    private var instanceId: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    /**
     * @param value Network interface index (int).
     */
    @JvmName("ftgnwimgyxjpugwk")
    public suspend fun deviceIndex(`value`: Output<Int>) {
        this.deviceIndex = value
    }

    /**
     * @param value Instance ID to attach.
     */
    @JvmName("bxewbtwssvjoutev")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value ENI ID to attach.
     */
    @JvmName("udrqtvsbtxrhmrve")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value Network interface index (int).
     */
    @JvmName("qmikjwagfkpewilx")
    public suspend fun deviceIndex(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceIndex = mapped
    }

    /**
     * @param value Instance ID to attach.
     */
    @JvmName("byonarfqoitssrhv")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value ENI ID to attach.
     */
    @JvmName("ecufdoxywnqhjmws")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    internal fun build(): NetworkInterfaceAttachmentArgs = NetworkInterfaceAttachmentArgs(
        deviceIndex = deviceIndex,
        instanceId = instanceId,
        networkInterfaceId = networkInterfaceId,
    )
}
