@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [PlacementGroup].
 */
@PulumiTagMarker
public class PlacementGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PlacementGroupArgs = PlacementGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PlacementGroupArgsBuilder.() -> Unit) {
        val builder = PlacementGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PlacementGroup {
        val builtJavaResource = com.pulumi.aws.ec2.PlacementGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PlacementGroup(builtJavaResource)
    }
}

/**
 * Provides an EC2 placement group. Read more about placement groups
 * in [AWS Docs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const web = new aws.ec2.PlacementGroup("web", {
 *     name: "hunky-dory-pg",
 *     strategy: aws.ec2.PlacementStrategy.Cluster,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * web = aws.ec2.PlacementGroup("web",
 *     name="hunky-dory-pg",
 *     strategy=aws.ec2.PlacementStrategy.CLUSTER)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var web = new Aws.Ec2.PlacementGroup("web", new()
 *     {
 *         Name = "hunky-dory-pg",
 *         Strategy = Aws.Ec2.PlacementStrategy.Cluster,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewPlacementGroup(ctx, "web", &ec2.PlacementGroupArgs{
 * 			Name:     pulumi.String("hunky-dory-pg"),
 * 			Strategy: pulumi.String(ec2.PlacementStrategyCluster),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.PlacementGroup;
 * import com.pulumi.aws.ec2.PlacementGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var web = new PlacementGroup("web", PlacementGroupArgs.builder()
 *             .name("hunky-dory-pg")
 *             .strategy("cluster")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   web:
 *     type: aws:ec2:PlacementGroup
 *     properties:
 *       name: hunky-dory-pg
 *       strategy: cluster
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import placement groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:ec2/placementGroup:PlacementGroup prod_pg production-placement-group
 * ```
 */
public class PlacementGroup internal constructor(
    override val javaResource: com.pulumi.aws.ec2.PlacementGroup,
) : KotlinCustomResource(javaResource, PlacementGroupMapper) {
    /**
     * Amazon Resource Name (ARN) of the placement group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the placement group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The number of partitions to create in the
     * placement group.  Can only be specified when the `strategy` is set to
     * `partition`.  Valid values are 1 - 7 (default is `2`).
     */
    public val partitionCount: Output<Int>
        get() = javaResource.partitionCount().applyValue({ args0 -> args0 })

    /**
     * The ID of the placement group.
     */
    public val placementGroupId: Output<String>
        get() = javaResource.placementGroupId().applyValue({ args0 -> args0 })

    /**
     * Determines how placement groups spread instances. Can only be used
     * when the `strategy` is set to `spread`. Can be `host` or `rack`. `host` can only be used for Outpost placement groups. Defaults to `rack`.
     */
    public val spreadLevel: Output<String>
        get() = javaResource.spreadLevel().applyValue({ args0 -> args0 })

    /**
     * The placement strategy. Can be `cluster`, `partition` or `spread`.
     */
    public val strategy: Output<String>
        get() = javaResource.strategy().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object PlacementGroupMapper : ResourceMapper<PlacementGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.PlacementGroup::class == javaResource::class

    override fun map(javaResource: Resource): PlacementGroup = PlacementGroup(
        javaResource as
            com.pulumi.aws.ec2.PlacementGroup,
    )
}

/**
 * @see [PlacementGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PlacementGroup].
 */
public suspend fun placementGroup(
    name: String,
    block: suspend PlacementGroupResourceBuilder.() -> Unit,
): PlacementGroup {
    val builder = PlacementGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PlacementGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun placementGroup(name: String): PlacementGroup {
    val builder = PlacementGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
