@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.PlacementGroupArgs.builder
import com.pulumi.aws.ec2.kotlin.enums.PlacementStrategy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an EC2 placement group. Read more about placement groups
 * in [AWS Docs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const web = new aws.ec2.PlacementGroup("web", {
 *     name: "hunky-dory-pg",
 *     strategy: aws.ec2.PlacementStrategy.Cluster,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * web = aws.ec2.PlacementGroup("web",
 *     name="hunky-dory-pg",
 *     strategy=aws.ec2.PlacementStrategy.CLUSTER)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var web = new Aws.Ec2.PlacementGroup("web", new()
 *     {
 *         Name = "hunky-dory-pg",
 *         Strategy = Aws.Ec2.PlacementStrategy.Cluster,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewPlacementGroup(ctx, "web", &ec2.PlacementGroupArgs{
 * 			Name:     pulumi.String("hunky-dory-pg"),
 * 			Strategy: pulumi.String(ec2.PlacementStrategyCluster),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.PlacementGroup;
 * import com.pulumi.aws.ec2.PlacementGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var web = new PlacementGroup("web", PlacementGroupArgs.builder()
 *             .name("hunky-dory-pg")
 *             .strategy("cluster")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   web:
 *     type: aws:ec2:PlacementGroup
 *     properties:
 *       name: hunky-dory-pg
 *       strategy: cluster
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import placement groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:ec2/placementGroup:PlacementGroup prod_pg production-placement-group
 * ```
 * @property name The name of the placement group.
 * @property partitionCount The number of partitions to create in the
 * placement group.  Can only be specified when the `strategy` is set to
 * `partition`.  Valid values are 1 - 7 (default is `2`).
 * @property spreadLevel Determines how placement groups spread instances. Can only be used
 * when the `strategy` is set to `spread`. Can be `host` or `rack`. `host` can only be used for Outpost placement groups. Defaults to `rack`.
 * @property strategy The placement strategy. Can be `cluster`, `partition` or `spread`.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class PlacementGroupArgs(
    public val name: Output<String>? = null,
    public val partitionCount: Output<Int>? = null,
    public val spreadLevel: Output<String>? = null,
    public val strategy: Output<Either<String, PlacementStrategy>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.PlacementGroupArgs> {
    override fun toJava(): com.pulumi.aws.ec2.PlacementGroupArgs =
        com.pulumi.aws.ec2.PlacementGroupArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .partitionCount(partitionCount?.applyValue({ args0 -> args0 }))
            .spreadLevel(spreadLevel?.applyValue({ args0 -> args0 }))
            .strategy(
                strategy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PlacementGroupArgs].
 */
@PulumiTagMarker
public class PlacementGroupArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var partitionCount: Output<Int>? = null

    private var spreadLevel: Output<String>? = null

    private var strategy: Output<Either<String, PlacementStrategy>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the placement group.
     */
    @JvmName("qhxvotrgkxblmsoc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The number of partitions to create in the
     * placement group.  Can only be specified when the `strategy` is set to
     * `partition`.  Valid values are 1 - 7 (default is `2`).
     */
    @JvmName("imjkwfiuqimcqagr")
    public suspend fun partitionCount(`value`: Output<Int>) {
        this.partitionCount = value
    }

    /**
     * @param value Determines how placement groups spread instances. Can only be used
     * when the `strategy` is set to `spread`. Can be `host` or `rack`. `host` can only be used for Outpost placement groups. Defaults to `rack`.
     */
    @JvmName("mojrkjagvypybfiq")
    public suspend fun spreadLevel(`value`: Output<String>) {
        this.spreadLevel = value
    }

    /**
     * @param value The placement strategy. Can be `cluster`, `partition` or `spread`.
     */
    @JvmName("fawutlnqonwknwvc")
    public suspend fun strategy(`value`: Output<Either<String, PlacementStrategy>>) {
        this.strategy = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hoaoiquienbpjpst")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the placement group.
     */
    @JvmName("nihalpfcghklalja")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The number of partitions to create in the
     * placement group.  Can only be specified when the `strategy` is set to
     * `partition`.  Valid values are 1 - 7 (default is `2`).
     */
    @JvmName("sxfuelethcerfhen")
    public suspend fun partitionCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionCount = mapped
    }

    /**
     * @param value Determines how placement groups spread instances. Can only be used
     * when the `strategy` is set to `spread`. Can be `host` or `rack`. `host` can only be used for Outpost placement groups. Defaults to `rack`.
     */
    @JvmName("woshxwopnjdjjmku")
    public suspend fun spreadLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spreadLevel = mapped
    }

    /**
     * @param value The placement strategy. Can be `cluster`, `partition` or `spread`.
     */
    @JvmName("lesgmgfsavfqpdxy")
    public suspend fun strategy(`value`: Either<String, PlacementStrategy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strategy = mapped
    }

    /**
     * @param value The placement strategy. Can be `cluster`, `partition` or `spread`.
     */
    @JvmName("rxkcexudellsoxjc")
    public fun strategy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PlacementStrategy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.strategy = mapped
    }

    /**
     * @param value The placement strategy. Can be `cluster`, `partition` or `spread`.
     */
    @JvmName("qmhqkdxbhpfyikrv")
    public fun strategy(`value`: PlacementStrategy) {
        val toBeMapped = Either.ofRight<String, PlacementStrategy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.strategy = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ouggxgfnrsqvkpbf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("blqrnkclpxjojrrc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PlacementGroupArgs = PlacementGroupArgs(
        name = name,
        partitionCount = partitionCount,
        spreadLevel = spreadLevel,
        strategy = strategy,
        tags = tags,
    )
}
