@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ProxyProtocolPolicy].
 */
@PulumiTagMarker
public class ProxyProtocolPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProxyProtocolPolicyArgs = ProxyProtocolPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProxyProtocolPolicyArgsBuilder.() -> Unit) {
        val builder = ProxyProtocolPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProxyProtocolPolicy {
        val builtJavaResource = com.pulumi.aws.ec2.ProxyProtocolPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProxyProtocolPolicy(builtJavaResource)
    }
}

/**
 * Provides a proxy protocol policy, which allows an ELB to carry a client connection information to a backend.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const lb = new aws.elb.LoadBalancer("lb", {
 *     name: "test-lb",
 *     availabilityZones: ["us-east-1a"],
 *     listeners: [
 *         {
 *             instancePort: 25,
 *             instanceProtocol: "tcp",
 *             lbPort: 25,
 *             lbProtocol: "tcp",
 *         },
 *         {
 *             instancePort: 587,
 *             instanceProtocol: "tcp",
 *             lbPort: 587,
 *             lbProtocol: "tcp",
 *         },
 *     ],
 * });
 * const smtp = new aws.ec2.ProxyProtocolPolicy("smtp", {
 *     loadBalancer: lb.name,
 *     instancePorts: [
 *         "25",
 *         "587",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * lb = aws.elb.LoadBalancer("lb",
 *     name="test-lb",
 *     availability_zones=["us-east-1a"],
 *     listeners=[
 *         {
 *             "instance_port": 25,
 *             "instance_protocol": "tcp",
 *             "lb_port": 25,
 *             "lb_protocol": "tcp",
 *         },
 *         {
 *             "instance_port": 587,
 *             "instance_protocol": "tcp",
 *             "lb_port": 587,
 *             "lb_protocol": "tcp",
 *         },
 *     ])
 * smtp = aws.ec2.ProxyProtocolPolicy("smtp",
 *     load_balancer=lb.name,
 *     instance_ports=[
 *         "25",
 *         "587",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lb = new Aws.Elb.LoadBalancer("lb", new()
 *     {
 *         Name = "test-lb",
 *         AvailabilityZones = new[]
 *         {
 *             "us-east-1a",
 *         },
 *         Listeners = new[]
 *         {
 *             new Aws.Elb.Inputs.LoadBalancerListenerArgs
 *             {
 *                 InstancePort = 25,
 *                 InstanceProtocol = "tcp",
 *                 LbPort = 25,
 *                 LbProtocol = "tcp",
 *             },
 *             new Aws.Elb.Inputs.LoadBalancerListenerArgs
 *             {
 *                 InstancePort = 587,
 *                 InstanceProtocol = "tcp",
 *                 LbPort = 587,
 *                 LbProtocol = "tcp",
 *             },
 *         },
 *     });
 *     var smtp = new Aws.Ec2.ProxyProtocolPolicy("smtp", new()
 *     {
 *         LoadBalancer = lb.Name,
 *         InstancePorts = new[]
 *         {
 *             "25",
 *             "587",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		lb, err := elb.NewLoadBalancer(ctx, "lb", &elb.LoadBalancerArgs{
 * 			Name: pulumi.String("test-lb"),
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("us-east-1a"),
 * 			},
 * 			Listeners: elb.LoadBalancerListenerArray{
 * 				&elb.LoadBalancerListenerArgs{
 * 					InstancePort:     pulumi.Int(25),
 * 					InstanceProtocol: pulumi.String("tcp"),
 * 					LbPort:           pulumi.Int(25),
 * 					LbProtocol:       pulumi.String("tcp"),
 * 				},
 * 				&elb.LoadBalancerListenerArgs{
 * 					InstancePort:     pulumi.Int(587),
 * 					InstanceProtocol: pulumi.String("tcp"),
 * 					LbPort:           pulumi.Int(587),
 * 					LbProtocol:       pulumi.String("tcp"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewProxyProtocolPolicy(ctx, "smtp", &ec2.ProxyProtocolPolicyArgs{
 * 			LoadBalancer: lb.Name,
 * 			InstancePorts: pulumi.StringArray{
 * 				pulumi.String("25"),
 * 				pulumi.String("587"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.ec2.ProxyProtocolPolicy;
 * import com.pulumi.aws.ec2.ProxyProtocolPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lb = new LoadBalancer("lb", LoadBalancerArgs.builder()
 *             .name("test-lb")
 *             .availabilityZones("us-east-1a")
 *             .listeners(
 *                 LoadBalancerListenerArgs.builder()
 *                     .instancePort(25)
 *                     .instanceProtocol("tcp")
 *                     .lbPort(25)
 *                     .lbProtocol("tcp")
 *                     .build(),
 *                 LoadBalancerListenerArgs.builder()
 *                     .instancePort(587)
 *                     .instanceProtocol("tcp")
 *                     .lbPort(587)
 *                     .lbProtocol("tcp")
 *                     .build())
 *             .build());
 *         var smtp = new ProxyProtocolPolicy("smtp", ProxyProtocolPolicyArgs.builder()
 *             .loadBalancer(lb.name())
 *             .instancePorts(
 *                 "25",
 *                 "587")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   lb:
 *     type: aws:elb:LoadBalancer
 *     properties:
 *       name: test-lb
 *       availabilityZones:
 *         - us-east-1a
 *       listeners:
 *         - instancePort: 25
 *           instanceProtocol: tcp
 *           lbPort: 25
 *           lbProtocol: tcp
 *         - instancePort: 587
 *           instanceProtocol: tcp
 *           lbPort: 587
 *           lbProtocol: tcp
 *   smtp:
 *     type: aws:ec2:ProxyProtocolPolicy
 *     properties:
 *       loadBalancer: ${lb.name}
 *       instancePorts:
 *         - '25'
 *         - '587'
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class ProxyProtocolPolicy internal constructor(
    override val javaResource: com.pulumi.aws.ec2.ProxyProtocolPolicy,
) : KotlinCustomResource(javaResource, ProxyProtocolPolicyMapper) {
    /**
     * List of instance ports to which the policy
     * should be applied. This can be specified if the protocol is SSL or TCP.
     */
    public val instancePorts: Output<List<String>>
        get() = javaResource.instancePorts().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The load balancer to which the policy
     * should be attached.
     */
    public val loadBalancer: Output<String>
        get() = javaResource.loadBalancer().applyValue({ args0 -> args0 })
}

public object ProxyProtocolPolicyMapper : ResourceMapper<ProxyProtocolPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.ProxyProtocolPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ProxyProtocolPolicy = ProxyProtocolPolicy(
        javaResource
            as com.pulumi.aws.ec2.ProxyProtocolPolicy,
    )
}

/**
 * @see [ProxyProtocolPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProxyProtocolPolicy].
 */
public suspend fun proxyProtocolPolicy(
    name: String,
    block: suspend ProxyProtocolPolicyResourceBuilder.() -> Unit,
): ProxyProtocolPolicy {
    val builder = ProxyProtocolPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProxyProtocolPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun proxyProtocolPolicy(name: String): ProxyProtocolPolicy {
    val builder = ProxyProtocolPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
