@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.SecurityGroupAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to create an association between a VPC endpoint and a security group.
 * > **NOTE on VPC Endpoints and VPC Endpoint Security Group Associations:** The provider provides
 * both a standalone VPC Endpoint Security Group Association (an association between a VPC endpoint
 * and a single `security_group_id`) and a VPC Endpoint resource with a `security_group_ids`
 * attribute. Do not use the same security group ID in both a VPC Endpoint resource and a VPC Endpoint Security
 * Group Association resource. Doing so will cause a conflict of associations and will overwrite the association.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const sgEc2 = new aws.ec2.SecurityGroupAssociation("sg_ec2", {
 *     vpcEndpointId: ec2.id,
 *     securityGroupId: sg.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * sg_ec2 = aws.ec2.SecurityGroupAssociation("sg_ec2",
 *     vpc_endpoint_id=ec2["id"],
 *     security_group_id=sg["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sgEc2 = new Aws.Ec2.SecurityGroupAssociation("sg_ec2", new()
 *     {
 *         VpcEndpointId = ec2.Id,
 *         SecurityGroupId = sg.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewSecurityGroupAssociation(ctx, "sg_ec2", &ec2.SecurityGroupAssociationArgs{
 * 			VpcEndpointId:   pulumi.Any(ec2.Id),
 * 			SecurityGroupId: pulumi.Any(sg.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroupAssociation;
 * import com.pulumi.aws.ec2.SecurityGroupAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sgEc2 = new SecurityGroupAssociation("sgEc2", SecurityGroupAssociationArgs.builder()
 *             .vpcEndpointId(ec2.id())
 *             .securityGroupId(sg.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   sgEc2:
 *     type: aws:ec2:SecurityGroupAssociation
 *     name: sg_ec2
 *     properties:
 *       vpcEndpointId: ${ec2.id}
 *       securityGroupId: ${sg.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property replaceDefaultAssociation Whether this association should replace the association with the VPC's default security group that is created when no security groups are specified during VPC endpoint creation. At most 1 association per-VPC endpoint should be configured with `replace_default_association = true`.
 * @property securityGroupId The ID of the security group to be associated with the VPC endpoint.
 * @property vpcEndpointId The ID of the VPC endpoint with which the security group will be associated.
 */
public data class SecurityGroupAssociationArgs(
    public val replaceDefaultAssociation: Output<Boolean>? = null,
    public val securityGroupId: Output<String>? = null,
    public val vpcEndpointId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.SecurityGroupAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.SecurityGroupAssociationArgs =
        com.pulumi.aws.ec2.SecurityGroupAssociationArgs.builder()
            .replaceDefaultAssociation(replaceDefaultAssociation?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .vpcEndpointId(vpcEndpointId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityGroupAssociationArgs].
 */
@PulumiTagMarker
public class SecurityGroupAssociationArgsBuilder internal constructor() {
    private var replaceDefaultAssociation: Output<Boolean>? = null

    private var securityGroupId: Output<String>? = null

    private var vpcEndpointId: Output<String>? = null

    /**
     * @param value Whether this association should replace the association with the VPC's default security group that is created when no security groups are specified during VPC endpoint creation. At most 1 association per-VPC endpoint should be configured with `replace_default_association = true`.
     */
    @JvmName("aegjgxapahycqdjq")
    public suspend fun replaceDefaultAssociation(`value`: Output<Boolean>) {
        this.replaceDefaultAssociation = value
    }

    /**
     * @param value The ID of the security group to be associated with the VPC endpoint.
     */
    @JvmName("ajxusrvwttvunwaj")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The ID of the VPC endpoint with which the security group will be associated.
     */
    @JvmName("yibbausqdlpkpkam")
    public suspend fun vpcEndpointId(`value`: Output<String>) {
        this.vpcEndpointId = value
    }

    /**
     * @param value Whether this association should replace the association with the VPC's default security group that is created when no security groups are specified during VPC endpoint creation. At most 1 association per-VPC endpoint should be configured with `replace_default_association = true`.
     */
    @JvmName("rrdbhvmajnrpiugf")
    public suspend fun replaceDefaultAssociation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replaceDefaultAssociation = mapped
    }

    /**
     * @param value The ID of the security group to be associated with the VPC endpoint.
     */
    @JvmName("tkdbdpkuxodnxdbk")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value The ID of the VPC endpoint with which the security group will be associated.
     */
    @JvmName("chybyugmcquikgau")
    public suspend fun vpcEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointId = mapped
    }

    internal fun build(): SecurityGroupAssociationArgs = SecurityGroupAssociationArgs(
        replaceDefaultAssociation = replaceDefaultAssociation,
        securityGroupId = securityGroupId,
        vpcEndpointId = vpcEndpointId,
    )
}
