@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.SpotDatafeedSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * > **Note:** There is only a single subscription allowed per account.
 * To help you understand the charges for your Spot instances, Amazon EC2 provides a data feed that describes your Spot instance usage and pricing.
 * This data feed is sent to an Amazon S3 bucket that you specify when you subscribe to the data feed.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.s3.BucketV2("default", {bucket: "tf-spot-datafeed"});
 * const defaultSpotDatafeedSubscription = new aws.ec2.SpotDatafeedSubscription("default", {
 *     bucket: _default.id,
 *     prefix: "my_subdirectory",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.s3.BucketV2("default", bucket="tf-spot-datafeed")
 * default_spot_datafeed_subscription = aws.ec2.SpotDatafeedSubscription("default",
 *     bucket=default.id,
 *     prefix="my_subdirectory")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.S3.BucketV2("default", new()
 *     {
 *         Bucket = "tf-spot-datafeed",
 *     });
 *     var defaultSpotDatafeedSubscription = new Aws.Ec2.SpotDatafeedSubscription("default", new()
 *     {
 *         Bucket = @default.Id,
 *         Prefix = "my_subdirectory",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := s3.NewBucketV2(ctx, "default", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("tf-spot-datafeed"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewSpotDatafeedSubscription(ctx, "default", &ec2.SpotDatafeedSubscriptionArgs{
 * 			Bucket: _default.ID(),
 * 			Prefix: pulumi.String("my_subdirectory"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.ec2.SpotDatafeedSubscription;
 * import com.pulumi.aws.ec2.SpotDatafeedSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new BucketV2("default", BucketV2Args.builder()
 *             .bucket("tf-spot-datafeed")
 *             .build());
 *         var defaultSpotDatafeedSubscription = new SpotDatafeedSubscription("defaultSpotDatafeedSubscription", SpotDatafeedSubscriptionArgs.builder()
 *             .bucket(default_.id())
 *             .prefix("my_subdirectory")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: tf-spot-datafeed
 *   defaultSpotDatafeedSubscription:
 *     type: aws:ec2:SpotDatafeedSubscription
 *     name: default
 *     properties:
 *       bucket: ${default.id}
 *       prefix: my_subdirectory
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a Spot Datafeed Subscription using the word `spot-datafeed-subscription`. For example:
 * ```sh
 * $ pulumi import aws:ec2/spotDatafeedSubscription:SpotDatafeedSubscription mysubscription spot-datafeed-subscription
 * ```
 * @property bucket The Amazon S3 bucket in which to store the Spot instance data feed.
 * @property prefix Path of folder inside bucket to place spot pricing data.
 */
public data class SpotDatafeedSubscriptionArgs(
    public val bucket: Output<String>? = null,
    public val prefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.SpotDatafeedSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.ec2.SpotDatafeedSubscriptionArgs =
        com.pulumi.aws.ec2.SpotDatafeedSubscriptionArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotDatafeedSubscriptionArgs].
 */
@PulumiTagMarker
public class SpotDatafeedSubscriptionArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value The Amazon S3 bucket in which to store the Spot instance data feed.
     */
    @JvmName("ifdrsrajhwtejfiq")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Path of folder inside bucket to place spot pricing data.
     */
    @JvmName("dkfqbtxspqrryqfo")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The Amazon S3 bucket in which to store the Spot instance data feed.
     */
    @JvmName("ggtedpxsbwmkljrk")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Path of folder inside bucket to place spot pricing data.
     */
    @JvmName("hllgctyuqidjnkaq")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): SpotDatafeedSubscriptionArgs = SpotDatafeedSubscriptionArgs(
        bucket = bucket,
        prefix = prefix,
    )
}
