@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SubnetCidrReservation].
 */
@PulumiTagMarker
public class SubnetCidrReservationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubnetCidrReservationArgs = SubnetCidrReservationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubnetCidrReservationArgsBuilder.() -> Unit) {
        val builder = SubnetCidrReservationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SubnetCidrReservation {
        val builtJavaResource = com.pulumi.aws.ec2.SubnetCidrReservation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SubnetCidrReservation(builtJavaResource)
    }
}

/**
 * Provides a subnet CIDR reservation resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.SubnetCidrReservation("example", {
 *     cidrBlock: "10.0.0.16/28",
 *     reservationType: "prefix",
 *     subnetId: exampleAwsSubnet.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.SubnetCidrReservation("example",
 *     cidr_block="10.0.0.16/28",
 *     reservation_type="prefix",
 *     subnet_id=example_aws_subnet["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.SubnetCidrReservation("example", new()
 *     {
 *         CidrBlock = "10.0.0.16/28",
 *         ReservationType = "prefix",
 *         SubnetId = exampleAwsSubnet.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewSubnetCidrReservation(ctx, "example", &ec2.SubnetCidrReservationArgs{
 * 			CidrBlock:       pulumi.String("10.0.0.16/28"),
 * 			ReservationType: pulumi.String("prefix"),
 * 			SubnetId:        pulumi.Any(exampleAwsSubnet.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SubnetCidrReservation;
 * import com.pulumi.aws.ec2.SubnetCidrReservationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SubnetCidrReservation("example", SubnetCidrReservationArgs.builder()
 *             .cidrBlock("10.0.0.16/28")
 *             .reservationType("prefix")
 *             .subnetId(exampleAwsSubnet.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:SubnetCidrReservation
 *     properties:
 *       cidrBlock: 10.0.0.16/28
 *       reservationType: prefix
 *       subnetId: ${exampleAwsSubnet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Existing CIDR reservations using `SUBNET_ID:RESERVATION_ID`. For example:
 * ```sh
 * $ pulumi import aws:ec2/subnetCidrReservation:SubnetCidrReservation example subnet-01llsxvsxabqiymcz:scr-4mnvz6wb7otksjcs9
 * ```
 */
public class SubnetCidrReservation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.SubnetCidrReservation,
) : KotlinCustomResource(javaResource, SubnetCidrReservationMapper) {
    /**
     * The CIDR block for the reservation.
     */
    public val cidrBlock: Output<String>
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0 })

    /**
     * A brief description of the reservation.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of the AWS account that owns this CIDR reservation.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * The type of reservation to create. Valid values: `explicit`, `prefix`
     */
    public val reservationType: Output<String>
        get() = javaResource.reservationType().applyValue({ args0 -> args0 })

    /**
     * The ID of the subnet to create the reservation for.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })
}

public object SubnetCidrReservationMapper : ResourceMapper<SubnetCidrReservation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.SubnetCidrReservation::class == javaResource::class

    override fun map(javaResource: Resource): SubnetCidrReservation =
        SubnetCidrReservation(javaResource as com.pulumi.aws.ec2.SubnetCidrReservation)
}

/**
 * @see [SubnetCidrReservation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SubnetCidrReservation].
 */
public suspend fun subnetCidrReservation(
    name: String,
    block: suspend SubnetCidrReservationResourceBuilder.() -> Unit,
): SubnetCidrReservation {
    val builder = SubnetCidrReservationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SubnetCidrReservation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun subnetCidrReservation(name: String): SubnetCidrReservation {
    val builder = SubnetCidrReservationResourceBuilder()
    builder.name(name)
    return builder.build()
}
