@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.SubnetCidrReservationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a subnet CIDR reservation resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.SubnetCidrReservation("example", {
 *     cidrBlock: "10.0.0.16/28",
 *     reservationType: "prefix",
 *     subnetId: exampleAwsSubnet.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.SubnetCidrReservation("example",
 *     cidr_block="10.0.0.16/28",
 *     reservation_type="prefix",
 *     subnet_id=example_aws_subnet["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.SubnetCidrReservation("example", new()
 *     {
 *         CidrBlock = "10.0.0.16/28",
 *         ReservationType = "prefix",
 *         SubnetId = exampleAwsSubnet.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewSubnetCidrReservation(ctx, "example", &ec2.SubnetCidrReservationArgs{
 * 			CidrBlock:       pulumi.String("10.0.0.16/28"),
 * 			ReservationType: pulumi.String("prefix"),
 * 			SubnetId:        pulumi.Any(exampleAwsSubnet.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SubnetCidrReservation;
 * import com.pulumi.aws.ec2.SubnetCidrReservationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SubnetCidrReservation("example", SubnetCidrReservationArgs.builder()
 *             .cidrBlock("10.0.0.16/28")
 *             .reservationType("prefix")
 *             .subnetId(exampleAwsSubnet.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:SubnetCidrReservation
 *     properties:
 *       cidrBlock: 10.0.0.16/28
 *       reservationType: prefix
 *       subnetId: ${exampleAwsSubnet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Existing CIDR reservations using `SUBNET_ID:RESERVATION_ID`. For example:
 * ```sh
 * $ pulumi import aws:ec2/subnetCidrReservation:SubnetCidrReservation example subnet-01llsxvsxabqiymcz:scr-4mnvz6wb7otksjcs9
 * ```
 * @property cidrBlock The CIDR block for the reservation.
 * @property description A brief description of the reservation.
 * @property reservationType The type of reservation to create. Valid values: `explicit`, `prefix`
 * @property subnetId The ID of the subnet to create the reservation for.
 */
public data class SubnetCidrReservationArgs(
    public val cidrBlock: Output<String>? = null,
    public val description: Output<String>? = null,
    public val reservationType: Output<String>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.SubnetCidrReservationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.SubnetCidrReservationArgs =
        com.pulumi.aws.ec2.SubnetCidrReservationArgs.builder()
            .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .reservationType(reservationType?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubnetCidrReservationArgs].
 */
@PulumiTagMarker
public class SubnetCidrReservationArgsBuilder internal constructor() {
    private var cidrBlock: Output<String>? = null

    private var description: Output<String>? = null

    private var reservationType: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value The CIDR block for the reservation.
     */
    @JvmName("bfkfxtwjtphhhdvm")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value A brief description of the reservation.
     */
    @JvmName("tbcuhquohesxawuu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The type of reservation to create. Valid values: `explicit`, `prefix`
     */
    @JvmName("bhdtlgbplxtgwmgq")
    public suspend fun reservationType(`value`: Output<String>) {
        this.reservationType = value
    }

    /**
     * @param value The ID of the subnet to create the reservation for.
     */
    @JvmName("mqyfutpsblvtftow")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The CIDR block for the reservation.
     */
    @JvmName("hwxhibtmnffrrfkk")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value A brief description of the reservation.
     */
    @JvmName("sqxudjovxegpmlts")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The type of reservation to create. Valid values: `explicit`, `prefix`
     */
    @JvmName("pqdebqbiqxhjvvpa")
    public suspend fun reservationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reservationType = mapped
    }

    /**
     * @param value The ID of the subnet to create the reservation for.
     */
    @JvmName("mgryifykhgkdkwhv")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): SubnetCidrReservationArgs = SubnetCidrReservationArgs(
        cidrBlock = cidrBlock,
        description = description,
        reservationType = reservationType,
        subnetId = subnetId,
    )
}
