@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Tag].
 */
@PulumiTagMarker
public class TagResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TagArgs = TagArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TagArgsBuilder.() -> Unit) {
        val builder = TagArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Tag {
        val builtJavaResource = com.pulumi.aws.ec2.Tag(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Tag(builtJavaResource)
    }
}

/**
 * Manages an individual EC2 resource tag. This resource should only be used in cases where EC2 resources are created outside the provider (e.g. AMIs), being shared via Resource Access Manager (RAM), or implicitly created by other means (e.g. Transit Gateway VPN Attachments).
 * > **NOTE:** This tagging resource should not be combined with the providers resource for managing the parent resource. For example, using `aws.ec2.Vpc` and `aws.ec2.Tag` to manage tags of the same VPC will cause a perpetual difference where the `aws.ec2.Vpc` resource will try to remove the tag being added by the `aws.ec2.Tag` resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2transitgateway.TransitGateway("example", {});
 * const exampleCustomerGateway = new aws.ec2.CustomerGateway("example", {
 *     bgpAsn: "65000",
 *     ipAddress: "172.0.0.1",
 *     type: "ipsec.1",
 * });
 * const exampleVpnConnection = new aws.ec2.VpnConnection("example", {
 *     customerGatewayId: exampleCustomerGateway.id,
 *     transitGatewayId: example.id,
 *     type: exampleCustomerGateway.type,
 * });
 * const exampleTag = new aws.ec2.Tag("example", {
 *     resourceId: exampleVpnConnection.transitGatewayAttachmentId,
 *     key: "Name",
 *     value: "Hello World",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2transitgateway.TransitGateway("example")
 * example_customer_gateway = aws.ec2.CustomerGateway("example",
 *     bgp_asn="65000",
 *     ip_address="172.0.0.1",
 *     type="ipsec.1")
 * example_vpn_connection = aws.ec2.VpnConnection("example",
 *     customer_gateway_id=example_customer_gateway.id,
 *     transit_gateway_id=example.id,
 *     type=example_customer_gateway.type)
 * example_tag = aws.ec2.Tag("example",
 *     resource_id=example_vpn_connection.transit_gateway_attachment_id,
 *     key="Name",
 *     value="Hello World")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2TransitGateway.TransitGateway("example");
 *     var exampleCustomerGateway = new Aws.Ec2.CustomerGateway("example", new()
 *     {
 *         BgpAsn = "65000",
 *         IpAddress = "172.0.0.1",
 *         Type = "ipsec.1",
 *     });
 *     var exampleVpnConnection = new Aws.Ec2.VpnConnection("example", new()
 *     {
 *         CustomerGatewayId = exampleCustomerGateway.Id,
 *         TransitGatewayId = example.Id,
 *         Type = exampleCustomerGateway.Type,
 *     });
 *     var exampleTag = new Aws.Ec2.Tag("example", new()
 *     {
 *         ResourceId = exampleVpnConnection.TransitGatewayAttachmentId,
 *         Key = "Name",
 *         Value = "Hello World",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2transitgateway.NewTransitGateway(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleCustomerGateway, err := ec2.NewCustomerGateway(ctx, "example", &ec2.CustomerGatewayArgs{
 * 			BgpAsn:    pulumi.String("65000"),
 * 			IpAddress: pulumi.String("172.0.0.1"),
 * 			Type:      pulumi.String("ipsec.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpnConnection, err := ec2.NewVpnConnection(ctx, "example", &ec2.VpnConnectionArgs{
 * 			CustomerGatewayId: exampleCustomerGateway.ID(),
 * 			TransitGatewayId:  example.ID(),
 * 			Type:              exampleCustomerGateway.Type,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewTag(ctx, "example", &ec2.TagArgs{
 * 			ResourceId: exampleVpnConnection.TransitGatewayAttachmentId,
 * 			Key:        pulumi.String("Name"),
 * 			Value:      pulumi.String("Hello World"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2.CustomerGateway;
 * import com.pulumi.aws.ec2.CustomerGatewayArgs;
 * import com.pulumi.aws.ec2.VpnConnection;
 * import com.pulumi.aws.ec2.VpnConnectionArgs;
 * import com.pulumi.aws.ec2.Tag;
 * import com.pulumi.aws.ec2.TagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TransitGateway("example");
 *         var exampleCustomerGateway = new CustomerGateway("exampleCustomerGateway", CustomerGatewayArgs.builder()
 *             .bgpAsn(65000)
 *             .ipAddress("172.0.0.1")
 *             .type("ipsec.1")
 *             .build());
 *         var exampleVpnConnection = new VpnConnection("exampleVpnConnection", VpnConnectionArgs.builder()
 *             .customerGatewayId(exampleCustomerGateway.id())
 *             .transitGatewayId(example.id())
 *             .type(exampleCustomerGateway.type())
 *             .build());
 *         var exampleTag = new Tag("exampleTag", TagArgs.builder()
 *             .resourceId(exampleVpnConnection.transitGatewayAttachmentId())
 *             .key("Name")
 *             .value("Hello World")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2transitgateway:TransitGateway
 *   exampleCustomerGateway:
 *     type: aws:ec2:CustomerGateway
 *     name: example
 *     properties:
 *       bgpAsn: 65000
 *       ipAddress: 172.0.0.1
 *       type: ipsec.1
 *   exampleVpnConnection:
 *     type: aws:ec2:VpnConnection
 *     name: example
 *     properties:
 *       customerGatewayId: ${exampleCustomerGateway.id}
 *       transitGatewayId: ${example.id}
 *       type: ${exampleCustomerGateway.type}
 *   exampleTag:
 *     type: aws:ec2:Tag
 *     name: example
 *     properties:
 *       resourceId: ${exampleVpnConnection.transitGatewayAttachmentId}
 *       key: Name
 *       value: Hello World
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_tag` using the EC2 resource identifier and key, separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:ec2/tag:Tag example tgw-attach-1234567890abcdef,Name
 * ```
 */
public class Tag internal constructor(
    override val javaResource: com.pulumi.aws.ec2.Tag,
) : KotlinCustomResource(javaResource, TagMapper) {
    /**
     * The tag name.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * The ID of the EC2 resource to manage the tag for.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * The value of the tag.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object TagMapper : ResourceMapper<Tag> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.Tag::class == javaResource::class

    override fun map(javaResource: Resource): Tag = Tag(javaResource as com.pulumi.aws.ec2.Tag)
}

/**
 * @see [Tag].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Tag].
 */
public suspend fun tag(name: String, block: suspend TagResourceBuilder.() -> Unit): Tag {
    val builder = TagResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Tag].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tag(name: String): Tag {
    val builder = TagResourceBuilder()
    builder.name(name)
    return builder.build()
}
