@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.TrafficMirrorSessionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Traffic mirror session.
 * Read [limits and considerations](https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-considerations.html) for traffic mirroring
 * ## Example Usage
 * To create a basic traffic mirror session
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const filter = new aws.ec2.TrafficMirrorFilter("filter", {
 *     description: "traffic mirror filter - example",
 *     networkServices: ["amazon-dns"],
 * });
 * const target = new aws.ec2.TrafficMirrorTarget("target", {networkLoadBalancerArn: lb.arn});
 * const session = new aws.ec2.TrafficMirrorSession("session", {
 *     description: "traffic mirror session - example",
 *     networkInterfaceId: test.primaryNetworkInterfaceId,
 *     sessionNumber: 1,
 *     trafficMirrorFilterId: filter.id,
 *     trafficMirrorTargetId: target.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * filter = aws.ec2.TrafficMirrorFilter("filter",
 *     description="traffic mirror filter - example",
 *     network_services=["amazon-dns"])
 * target = aws.ec2.TrafficMirrorTarget("target", network_load_balancer_arn=lb["arn"])
 * session = aws.ec2.TrafficMirrorSession("session",
 *     description="traffic mirror session - example",
 *     network_interface_id=test["primaryNetworkInterfaceId"],
 *     session_number=1,
 *     traffic_mirror_filter_id=filter.id,
 *     traffic_mirror_target_id=target.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var filter = new Aws.Ec2.TrafficMirrorFilter("filter", new()
 *     {
 *         Description = "traffic mirror filter - example",
 *         NetworkServices = new[]
 *         {
 *             "amazon-dns",
 *         },
 *     });
 *     var target = new Aws.Ec2.TrafficMirrorTarget("target", new()
 *     {
 *         NetworkLoadBalancerArn = lb.Arn,
 *     });
 *     var session = new Aws.Ec2.TrafficMirrorSession("session", new()
 *     {
 *         Description = "traffic mirror session - example",
 *         NetworkInterfaceId = test.PrimaryNetworkInterfaceId,
 *         SessionNumber = 1,
 *         TrafficMirrorFilterId = filter.Id,
 *         TrafficMirrorTargetId = target.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		filter, err := ec2.NewTrafficMirrorFilter(ctx, "filter", &ec2.TrafficMirrorFilterArgs{
 * 			Description: pulumi.String("traffic mirror filter - example"),
 * 			NetworkServices: pulumi.StringArray{
 * 				pulumi.String("amazon-dns"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		target, err := ec2.NewTrafficMirrorTarget(ctx, "target", &ec2.TrafficMirrorTargetArgs{
 * 			NetworkLoadBalancerArn: pulumi.Any(lb.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewTrafficMirrorSession(ctx, "session", &ec2.TrafficMirrorSessionArgs{
 * 			Description:           pulumi.String("traffic mirror session - example"),
 * 			NetworkInterfaceId:    pulumi.Any(test.PrimaryNetworkInterfaceId),
 * 			SessionNumber:         pulumi.Int(1),
 * 			TrafficMirrorFilterId: filter.ID(),
 * 			TrafficMirrorTargetId: target.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.TrafficMirrorFilter;
 * import com.pulumi.aws.ec2.TrafficMirrorFilterArgs;
 * import com.pulumi.aws.ec2.TrafficMirrorTarget;
 * import com.pulumi.aws.ec2.TrafficMirrorTargetArgs;
 * import com.pulumi.aws.ec2.TrafficMirrorSession;
 * import com.pulumi.aws.ec2.TrafficMirrorSessionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var filter = new TrafficMirrorFilter("filter", TrafficMirrorFilterArgs.builder()
 *             .description("traffic mirror filter - example")
 *             .networkServices("amazon-dns")
 *             .build());
 *         var target = new TrafficMirrorTarget("target", TrafficMirrorTargetArgs.builder()
 *             .networkLoadBalancerArn(lb.arn())
 *             .build());
 *         var session = new TrafficMirrorSession("session", TrafficMirrorSessionArgs.builder()
 *             .description("traffic mirror session - example")
 *             .networkInterfaceId(test.primaryNetworkInterfaceId())
 *             .sessionNumber(1)
 *             .trafficMirrorFilterId(filter.id())
 *             .trafficMirrorTargetId(target.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   filter:
 *     type: aws:ec2:TrafficMirrorFilter
 *     properties:
 *       description: traffic mirror filter - example
 *       networkServices:
 *         - amazon-dns
 *   target:
 *     type: aws:ec2:TrafficMirrorTarget
 *     properties:
 *       networkLoadBalancerArn: ${lb.arn}
 *   session:
 *     type: aws:ec2:TrafficMirrorSession
 *     properties:
 *       description: traffic mirror session - example
 *       networkInterfaceId: ${test.primaryNetworkInterfaceId}
 *       sessionNumber: 1
 *       trafficMirrorFilterId: ${filter.id}
 *       trafficMirrorTargetId: ${target.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import traffic mirror sessions using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/trafficMirrorSession:TrafficMirrorSession session tms-0d8aa3ca35897b82e
 * ```
 * @property description A description of the traffic mirror session.
 * @property networkInterfaceId ID of the source network interface. Not all network interfaces are eligible as mirror sources. On EC2 instances only nitro based instances support mirroring.
 * @property packetLength The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length (in bytes) that you want to mirror.
 * @property sessionNumber The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property trafficMirrorFilterId ID of the traffic mirror filter to be used
 * @property trafficMirrorTargetId ID of the traffic mirror target to be used
 * @property virtualNetworkId The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see RFC 7348. If you do not specify a VirtualNetworkId, an account-wide unique id is chosen at random.
 */
public data class TrafficMirrorSessionArgs(
    public val description: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val packetLength: Output<Int>? = null,
    public val sessionNumber: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trafficMirrorFilterId: Output<String>? = null,
    public val trafficMirrorTargetId: Output<String>? = null,
    public val virtualNetworkId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.TrafficMirrorSessionArgs> {
    override fun toJava(): com.pulumi.aws.ec2.TrafficMirrorSessionArgs =
        com.pulumi.aws.ec2.TrafficMirrorSessionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .packetLength(packetLength?.applyValue({ args0 -> args0 }))
            .sessionNumber(sessionNumber?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trafficMirrorFilterId(trafficMirrorFilterId?.applyValue({ args0 -> args0 }))
            .trafficMirrorTargetId(trafficMirrorTargetId?.applyValue({ args0 -> args0 }))
            .virtualNetworkId(virtualNetworkId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrafficMirrorSessionArgs].
 */
@PulumiTagMarker
public class TrafficMirrorSessionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    private var packetLength: Output<Int>? = null

    private var sessionNumber: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trafficMirrorFilterId: Output<String>? = null

    private var trafficMirrorTargetId: Output<String>? = null

    private var virtualNetworkId: Output<Int>? = null

    /**
     * @param value A description of the traffic mirror session.
     */
    @JvmName("jdxvkmhiqdlocfrp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value ID of the source network interface. Not all network interfaces are eligible as mirror sources. On EC2 instances only nitro based instances support mirroring.
     */
    @JvmName("gwkldfrfwfkmdspq")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length (in bytes) that you want to mirror.
     */
    @JvmName("pdbvoftywpxrwklg")
    public suspend fun packetLength(`value`: Output<Int>) {
        this.packetLength = value
    }

    /**
     * @param value The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
     */
    @JvmName("yutbbuwlpjqoawbu")
    public suspend fun sessionNumber(`value`: Output<Int>) {
        this.sessionNumber = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pvemvwyqusnjttnl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ID of the traffic mirror filter to be used
     */
    @JvmName("uxxvqrgxjjdlnpso")
    public suspend fun trafficMirrorFilterId(`value`: Output<String>) {
        this.trafficMirrorFilterId = value
    }

    /**
     * @param value ID of the traffic mirror target to be used
     */
    @JvmName("awxlgsnavtodiodc")
    public suspend fun trafficMirrorTargetId(`value`: Output<String>) {
        this.trafficMirrorTargetId = value
    }

    /**
     * @param value The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see RFC 7348. If you do not specify a VirtualNetworkId, an account-wide unique id is chosen at random.
     */
    @JvmName("wnpaachqibjhgmjr")
    public suspend fun virtualNetworkId(`value`: Output<Int>) {
        this.virtualNetworkId = value
    }

    /**
     * @param value A description of the traffic mirror session.
     */
    @JvmName("oswnvfaditfrules")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value ID of the source network interface. Not all network interfaces are eligible as mirror sources. On EC2 instances only nitro based instances support mirroring.
     */
    @JvmName("hckbascynvkibwcl")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length (in bytes) that you want to mirror.
     */
    @JvmName("unlvbwbqfmitkxki")
    public suspend fun packetLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packetLength = mapped
    }

    /**
     * @param value The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
     */
    @JvmName("mxewbhxfuvaweqri")
    public suspend fun sessionNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionNumber = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kdwhippoernaycln")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uvvkylmuqostywne")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value ID of the traffic mirror filter to be used
     */
    @JvmName("gnhmlkeifglbberh")
    public suspend fun trafficMirrorFilterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficMirrorFilterId = mapped
    }

    /**
     * @param value ID of the traffic mirror target to be used
     */
    @JvmName("ukynlgflleyyjomo")
    public suspend fun trafficMirrorTargetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficMirrorTargetId = mapped
    }

    /**
     * @param value The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see RFC 7348. If you do not specify a VirtualNetworkId, an account-wide unique id is chosen at random.
     */
    @JvmName("tgplhhciqidumhwn")
    public suspend fun virtualNetworkId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkId = mapped
    }

    internal fun build(): TrafficMirrorSessionArgs = TrafficMirrorSessionArgs(
        description = description,
        networkInterfaceId = networkInterfaceId,
        packetLength = packetLength,
        sessionNumber = sessionNumber,
        tags = tags,
        trafficMirrorFilterId = trafficMirrorFilterId,
        trafficMirrorTargetId = trafficMirrorTargetId,
        virtualNetworkId = virtualNetworkId,
    )
}
