@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.TrafficMirrorTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Traffic mirror target.
 * Read [limits and considerations](https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-considerations.html) for traffic mirroring
 * ## Example Usage
 * To create a basic traffic mirror session
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const nlb = new aws.ec2.TrafficMirrorTarget("nlb", {
 *     description: "NLB target",
 *     networkLoadBalancerArn: lb.arn,
 * });
 * const eni = new aws.ec2.TrafficMirrorTarget("eni", {
 *     description: "ENI target",
 *     networkInterfaceId: test.primaryNetworkInterfaceId,
 * });
 * const gwlb = new aws.ec2.TrafficMirrorTarget("gwlb", {
 *     description: "GWLB target",
 *     gatewayLoadBalancerEndpointId: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * nlb = aws.ec2.TrafficMirrorTarget("nlb",
 *     description="NLB target",
 *     network_load_balancer_arn=lb["arn"])
 * eni = aws.ec2.TrafficMirrorTarget("eni",
 *     description="ENI target",
 *     network_interface_id=test["primaryNetworkInterfaceId"])
 * gwlb = aws.ec2.TrafficMirrorTarget("gwlb",
 *     description="GWLB target",
 *     gateway_load_balancer_endpoint_id=example["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nlb = new Aws.Ec2.TrafficMirrorTarget("nlb", new()
 *     {
 *         Description = "NLB target",
 *         NetworkLoadBalancerArn = lb.Arn,
 *     });
 *     var eni = new Aws.Ec2.TrafficMirrorTarget("eni", new()
 *     {
 *         Description = "ENI target",
 *         NetworkInterfaceId = test.PrimaryNetworkInterfaceId,
 *     });
 *     var gwlb = new Aws.Ec2.TrafficMirrorTarget("gwlb", new()
 *     {
 *         Description = "GWLB target",
 *         GatewayLoadBalancerEndpointId = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewTrafficMirrorTarget(ctx, "nlb", &ec2.TrafficMirrorTargetArgs{
 * 			Description:            pulumi.String("NLB target"),
 * 			NetworkLoadBalancerArn: pulumi.Any(lb.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewTrafficMirrorTarget(ctx, "eni", &ec2.TrafficMirrorTargetArgs{
 * 			Description:        pulumi.String("ENI target"),
 * 			NetworkInterfaceId: pulumi.Any(test.PrimaryNetworkInterfaceId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewTrafficMirrorTarget(ctx, "gwlb", &ec2.TrafficMirrorTargetArgs{
 * 			Description:                   pulumi.String("GWLB target"),
 * 			GatewayLoadBalancerEndpointId: pulumi.Any(example.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.TrafficMirrorTarget;
 * import com.pulumi.aws.ec2.TrafficMirrorTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nlb = new TrafficMirrorTarget("nlb", TrafficMirrorTargetArgs.builder()
 *             .description("NLB target")
 *             .networkLoadBalancerArn(lb.arn())
 *             .build());
 *         var eni = new TrafficMirrorTarget("eni", TrafficMirrorTargetArgs.builder()
 *             .description("ENI target")
 *             .networkInterfaceId(test.primaryNetworkInterfaceId())
 *             .build());
 *         var gwlb = new TrafficMirrorTarget("gwlb", TrafficMirrorTargetArgs.builder()
 *             .description("GWLB target")
 *             .gatewayLoadBalancerEndpointId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   nlb:
 *     type: aws:ec2:TrafficMirrorTarget
 *     properties:
 *       description: NLB target
 *       networkLoadBalancerArn: ${lb.arn}
 *   eni:
 *     type: aws:ec2:TrafficMirrorTarget
 *     properties:
 *       description: ENI target
 *       networkInterfaceId: ${test.primaryNetworkInterfaceId}
 *   gwlb:
 *     type: aws:ec2:TrafficMirrorTarget
 *     properties:
 *       description: GWLB target
 *       gatewayLoadBalancerEndpointId: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import traffic mirror targets using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/trafficMirrorTarget:TrafficMirrorTarget target tmt-0c13a005422b86606
 * ```
 * @property description A description of the traffic mirror session.
 * @property gatewayLoadBalancerEndpointId The VPC Endpoint Id of the Gateway Load Balancer that is associated with the target.
 * @property networkInterfaceId The network interface ID that is associated with the target.
 * @property networkLoadBalancerArn The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the target.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * **NOTE:** Either `network_interface_id` or `network_load_balancer_arn` should be specified and both should not be specified together
 */
public data class TrafficMirrorTargetArgs(
    public val description: Output<String>? = null,
    public val gatewayLoadBalancerEndpointId: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val networkLoadBalancerArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.TrafficMirrorTargetArgs> {
    override fun toJava(): com.pulumi.aws.ec2.TrafficMirrorTargetArgs =
        com.pulumi.aws.ec2.TrafficMirrorTargetArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .gatewayLoadBalancerEndpointId(gatewayLoadBalancerEndpointId?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .networkLoadBalancerArn(networkLoadBalancerArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TrafficMirrorTargetArgs].
 */
@PulumiTagMarker
public class TrafficMirrorTargetArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var gatewayLoadBalancerEndpointId: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    private var networkLoadBalancerArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A description of the traffic mirror session.
     */
    @JvmName("ttwekjmqwcnvdnox")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The VPC Endpoint Id of the Gateway Load Balancer that is associated with the target.
     */
    @JvmName("mxhkfsxrmlddabuw")
    public suspend fun gatewayLoadBalancerEndpointId(`value`: Output<String>) {
        this.gatewayLoadBalancerEndpointId = value
    }

    /**
     * @param value The network interface ID that is associated with the target.
     */
    @JvmName("togabmjsrxabrblx")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the target.
     */
    @JvmName("shrfgssujdbtrysc")
    public suspend fun networkLoadBalancerArn(`value`: Output<String>) {
        this.networkLoadBalancerArn = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * **NOTE:** Either `network_interface_id` or `network_load_balancer_arn` should be specified and both should not be specified together
     */
    @JvmName("otkdakywslaqaaed")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A description of the traffic mirror session.
     */
    @JvmName("cqoarpwrsnyfxgso")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The VPC Endpoint Id of the Gateway Load Balancer that is associated with the target.
     */
    @JvmName("ennusutukdjhbhvc")
    public suspend fun gatewayLoadBalancerEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayLoadBalancerEndpointId = mapped
    }

    /**
     * @param value The network interface ID that is associated with the target.
     */
    @JvmName("sukhaoeprhspcmev")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the target.
     */
    @JvmName("cvjtabyxnwohvikn")
    public suspend fun networkLoadBalancerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkLoadBalancerArn = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * **NOTE:** Either `network_interface_id` or `network_load_balancer_arn` should be specified and both should not be specified together
     */
    @JvmName("mkiqyxuohtswoujo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * **NOTE:** Either `network_interface_id` or `network_load_balancer_arn` should be specified and both should not be specified together
     */
    @JvmName("qskouvkymgcyauds")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): TrafficMirrorTargetArgs = TrafficMirrorTargetArgs(
        description = description,
        gatewayLoadBalancerEndpointId = gatewayLoadBalancerEndpointId,
        networkInterfaceId = networkInterfaceId,
        networkLoadBalancerArn = networkLoadBalancerArn,
        tags = tags,
    )
}
