@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Vpc].
 */
@PulumiTagMarker
public class VpcResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcArgs = VpcArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcArgsBuilder.() -> Unit) {
        val builder = VpcArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Vpc {
        val builtJavaResource = com.pulumi.aws.ec2.Vpc(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Vpc(builtJavaResource)
    }
}

/**
 * Provides a VPC resource.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.Vpc("main", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 * ```
 * <!--End PulumiCodeChooser -->
 * Basic usage with tags:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.Vpc("main", {
 *     cidrBlock: "10.0.0.0/16",
 *     instanceTenancy: "default",
 *     tags: {
 *         Name: "main",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.Vpc("main",
 *     cidr_block="10.0.0.0/16",
 *     instance_tenancy="default",
 *     tags={
 *         "Name": "main",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.Vpc("main", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *         InstanceTenancy = "default",
 *         Tags =
 *         {
 *             { "Name", "main" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
 * 			CidrBlock:       pulumi.String("10.0.0.0/16"),
 * 			InstanceTenancy: pulumi.String("default"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("main"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .instanceTenancy("default")
 *             .tags(Map.of("Name", "main"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *       instanceTenancy: default
 *       tags:
 *         Name: main
 * ```
 * <!--End PulumiCodeChooser -->
 * VPC with CIDR from AWS IPAM:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getRegion({});
 * const test = new aws.ec2.VpcIpam("test", {operatingRegions: [{
 *     regionName: current.then(current => current.name),
 * }]});
 * const testVpcIpamPool = new aws.ec2.VpcIpamPool("test", {
 *     addressFamily: "ipv4",
 *     ipamScopeId: test.privateDefaultScopeId,
 *     locale: current.then(current => current.name),
 * });
 * const testVpcIpamPoolCidr = new aws.ec2.VpcIpamPoolCidr("test", {
 *     ipamPoolId: testVpcIpamPool.id,
 *     cidr: "172.20.0.0/16",
 * });
 * const testVpc = new aws.ec2.Vpc("test", {
 *     ipv4IpamPoolId: testVpcIpamPool.id,
 *     ipv4NetmaskLength: 28,
 * }, {
 *     dependsOn: [testVpcIpamPoolCidr],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_region()
 * test = aws.ec2.VpcIpam("test", operating_regions=[{
 *     "region_name": current.name,
 * }])
 * test_vpc_ipam_pool = aws.ec2.VpcIpamPool("test",
 *     address_family="ipv4",
 *     ipam_scope_id=test.private_default_scope_id,
 *     locale=current.name)
 * test_vpc_ipam_pool_cidr = aws.ec2.VpcIpamPoolCidr("test",
 *     ipam_pool_id=test_vpc_ipam_pool.id,
 *     cidr="172.20.0.0/16")
 * test_vpc = aws.ec2.Vpc("test",
 *     ipv4_ipam_pool_id=test_vpc_ipam_pool.id,
 *     ipv4_netmask_length=28,
 *     opts = pulumi.ResourceOptions(depends_on=[test_vpc_ipam_pool_cidr]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetRegion.Invoke();
 *     var test = new Aws.Ec2.VpcIpam("test", new()
 *     {
 *         OperatingRegions = new[]
 *         {
 *             new Aws.Ec2.Inputs.VpcIpamOperatingRegionArgs
 *             {
 *                 RegionName = current.Apply(getRegionResult => getRegionResult.Name),
 *             },
 *         },
 *     });
 *     var testVpcIpamPool = new Aws.Ec2.VpcIpamPool("test", new()
 *     {
 *         AddressFamily = "ipv4",
 *         IpamScopeId = test.PrivateDefaultScopeId,
 *         Locale = current.Apply(getRegionResult => getRegionResult.Name),
 *     });
 *     var testVpcIpamPoolCidr = new Aws.Ec2.VpcIpamPoolCidr("test", new()
 *     {
 *         IpamPoolId = testVpcIpamPool.Id,
 *         Cidr = "172.20.0.0/16",
 *     });
 *     var testVpc = new Aws.Ec2.Vpc("test", new()
 *     {
 *         Ipv4IpamPoolId = testVpcIpamPool.Id,
 *         Ipv4NetmaskLength = 28,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             testVpcIpamPoolCidr,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		test, err := ec2.NewVpcIpam(ctx, "test", &ec2.VpcIpamArgs{
 * 			OperatingRegions: ec2.VpcIpamOperatingRegionArray{
 * 				&ec2.VpcIpamOperatingRegionArgs{
 * 					RegionName: pulumi.String(current.Name),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testVpcIpamPool, err := ec2.NewVpcIpamPool(ctx, "test", &ec2.VpcIpamPoolArgs{
 * 			AddressFamily: pulumi.String("ipv4"),
 * 			IpamScopeId:   test.PrivateDefaultScopeId,
 * 			Locale:        pulumi.String(current.Name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testVpcIpamPoolCidr, err := ec2.NewVpcIpamPoolCidr(ctx, "test", &ec2.VpcIpamPoolCidrArgs{
 * 			IpamPoolId: testVpcIpamPool.ID(),
 * 			Cidr:       pulumi.String("172.20.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpc(ctx, "test", &ec2.VpcArgs{
 * 			Ipv4IpamPoolId:    testVpcIpamPool.ID(),
 * 			Ipv4NetmaskLength: pulumi.Int(28),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			testVpcIpamPoolCidr,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamPool;
 * import com.pulumi.aws.ec2.VpcIpamPoolArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidr;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var test = new VpcIpam("test", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var testVpcIpamPool = new VpcIpamPool("testVpcIpamPool", VpcIpamPoolArgs.builder()
 *             .addressFamily("ipv4")
 *             .ipamScopeId(test.privateDefaultScopeId())
 *             .locale(current.applyValue(getRegionResult -> getRegionResult.name()))
 *             .build());
 *         var testVpcIpamPoolCidr = new VpcIpamPoolCidr("testVpcIpamPoolCidr", VpcIpamPoolCidrArgs.builder()
 *             .ipamPoolId(testVpcIpamPool.id())
 *             .cidr("172.20.0.0/16")
 *             .build());
 *         var testVpc = new Vpc("testVpc", VpcArgs.builder()
 *             .ipv4IpamPoolId(testVpcIpamPool.id())
 *             .ipv4NetmaskLength(28)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(testVpcIpamPoolCidr)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:ec2:VpcIpam
 *     properties:
 *       operatingRegions:
 *         - regionName: ${current.name}
 *   testVpcIpamPool:
 *     type: aws:ec2:VpcIpamPool
 *     name: test
 *     properties:
 *       addressFamily: ipv4
 *       ipamScopeId: ${test.privateDefaultScopeId}
 *       locale: ${current.name}
 *   testVpcIpamPoolCidr:
 *     type: aws:ec2:VpcIpamPoolCidr
 *     name: test
 *     properties:
 *       ipamPoolId: ${testVpcIpamPool.id}
 *       cidr: 172.20.0.0/16
 *   testVpc:
 *     type: aws:ec2:Vpc
 *     name: test
 *     properties:
 *       ipv4IpamPoolId: ${testVpcIpamPool.id}
 *       ipv4NetmaskLength: 28
 *     options:
 *       dependson:
 *         - ${testVpcIpamPoolCidr}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPCs using the VPC `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpc:Vpc test_vpc vpc-a01106c2
 * ```
 */
public class Vpc internal constructor(
    override val javaResource: com.pulumi.aws.ec2.Vpc,
) : KotlinCustomResource(javaResource, VpcMapper) {
    /**
     * Amazon Resource Name (ARN) of VPC
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block. Default is `false`. Conflicts with `ipv6_ipam_pool_id`
     */
    public val assignGeneratedIpv6CidrBlock: Output<Boolean>?
        get() = javaResource.assignGeneratedIpv6CidrBlock().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IPv4 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv4_netmask_length`.
     */
    public val cidrBlock: Output<String>
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0 })

    /**
     * The ID of the network ACL created by default on VPC creation
     */
    public val defaultNetworkAclId: Output<String>
        get() = javaResource.defaultNetworkAclId().applyValue({ args0 -> args0 })

    /**
     * The ID of the route table created by default on VPC creation
     */
    public val defaultRouteTableId: Output<String>
        get() = javaResource.defaultRouteTableId().applyValue({ args0 -> args0 })

    /**
     * The ID of the security group created by default on VPC creation
     */
    public val defaultSecurityGroupId: Output<String>
        get() = javaResource.defaultSecurityGroupId().applyValue({ args0 -> args0 })

    /**
     * DHCP options id of the desired VPC.
     */
    public val dhcpOptionsId: Output<String>
        get() = javaResource.dhcpOptionsId().applyValue({ args0 -> args0 })

    /**
     * A boolean flag to enable/disable DNS hostnames in the VPC. Defaults false.
     */
    public val enableDnsHostnames: Output<Boolean>
        get() = javaResource.enableDnsHostnames().applyValue({ args0 -> args0 })

    /**
     * A boolean flag to enable/disable DNS support in the VPC. Defaults to true.
     */
    public val enableDnsSupport: Output<Boolean>?
        get() = javaResource.enableDnsSupport().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether Network Address Usage metrics are enabled for your VPC. Defaults to false.
     */
    public val enableNetworkAddressUsageMetrics: Output<Boolean>
        get() = javaResource.enableNetworkAddressUsageMetrics().applyValue({ args0 -> args0 })

    /**
     * A tenancy option for instances launched into the VPC. Default is `default`, which ensures that EC2 instances launched in this VPC use the EC2 instance tenancy attribute specified when the EC2 instance is launched. The only other option is `dedicated`, which ensures that EC2 instances launched in this VPC are run on dedicated tenancy instances regardless of the tenancy attribute specified at launch. This has a dedicated per region fee of $2 per hour, plus an hourly per instance usage fee.
     */
    public val instanceTenancy: Output<String>?
        get() = javaResource.instanceTenancy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
     */
    public val ipv4IpamPoolId: Output<String>?
        get() = javaResource.ipv4IpamPoolId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a `ipv4_ipam_pool_id`.
     */
    public val ipv4NetmaskLength: Output<Int>?
        get() = javaResource.ipv4NetmaskLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The association ID for the IPv6 CIDR block.
     */
    public val ipv6AssociationId: Output<String>
        get() = javaResource.ipv6AssociationId().applyValue({ args0 -> args0 })

    /**
     * IPv6 CIDR block to request from an IPAM Pool. Can be set explicitly or derived from IPAM using `ipv6_netmask_length`.
     */
    public val ipv6CidrBlock: Output<String>
        get() = javaResource.ipv6CidrBlock().applyValue({ args0 -> args0 })

    /**
     * By default when an IPv6 CIDR is assigned to a VPC a default ipv6_cidr_block_network_border_group will be set to the region of the VPC. This can be changed to restrict advertisement of public addresses to specific Network Border Groups such as LocalZones.
     */
    public val ipv6CidrBlockNetworkBorderGroup: Output<String>
        get() = javaResource.ipv6CidrBlockNetworkBorderGroup().applyValue({ args0 -> args0 })

    /**
     * IPAM Pool ID for a IPv6 pool. Conflicts with `assign_generated_ipv6_cidr_block`.
     */
    public val ipv6IpamPoolId: Output<String>?
        get() = javaResource.ipv6IpamPoolId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Netmask length to request from IPAM Pool. Conflicts with `ipv6_cidr_block`. This can be omitted if IPAM pool as a `allocation_default_netmask_length` set. Valid values are from `44` to `60` in increments of 4.
     */
    public val ipv6NetmaskLength: Output<Int>?
        get() = javaResource.ipv6NetmaskLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the main route table associated with
     * this VPC. Note that you can change a VPC's main route table by using an
     * `aws.ec2.MainRouteTableAssociation`.
     */
    public val mainRouteTableId: Output<String>
        get() = javaResource.mainRouteTableId().applyValue({ args0 -> args0 })

    /**
     * The ID of the AWS account that owns the VPC.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VpcMapper : ResourceMapper<Vpc> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.Vpc::class == javaResource::class

    override fun map(javaResource: Resource): Vpc = Vpc(javaResource as com.pulumi.aws.ec2.Vpc)
}

/**
 * @see [Vpc].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Vpc].
 */
public suspend fun vpc(name: String, block: suspend VpcResourceBuilder.() -> Unit): Vpc {
    val builder = VpcResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Vpc].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpc(name: String): Vpc {
    val builder = VpcResourceBuilder()
    builder.name(name)
    return builder.build()
}
