@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC resource.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.Vpc("main", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 * ```
 * <!--End PulumiCodeChooser -->
 * Basic usage with tags:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.Vpc("main", {
 *     cidrBlock: "10.0.0.0/16",
 *     instanceTenancy: "default",
 *     tags: {
 *         Name: "main",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.Vpc("main",
 *     cidr_block="10.0.0.0/16",
 *     instance_tenancy="default",
 *     tags={
 *         "Name": "main",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.Vpc("main", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *         InstanceTenancy = "default",
 *         Tags =
 *         {
 *             { "Name", "main" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
 * 			CidrBlock:       pulumi.String("10.0.0.0/16"),
 * 			InstanceTenancy: pulumi.String("default"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("main"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .instanceTenancy("default")
 *             .tags(Map.of("Name", "main"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *       instanceTenancy: default
 *       tags:
 *         Name: main
 * ```
 * <!--End PulumiCodeChooser -->
 * VPC with CIDR from AWS IPAM:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getRegion({});
 * const test = new aws.ec2.VpcIpam("test", {operatingRegions: [{
 *     regionName: current.then(current => current.name),
 * }]});
 * const testVpcIpamPool = new aws.ec2.VpcIpamPool("test", {
 *     addressFamily: "ipv4",
 *     ipamScopeId: test.privateDefaultScopeId,
 *     locale: current.then(current => current.name),
 * });
 * const testVpcIpamPoolCidr = new aws.ec2.VpcIpamPoolCidr("test", {
 *     ipamPoolId: testVpcIpamPool.id,
 *     cidr: "172.20.0.0/16",
 * });
 * const testVpc = new aws.ec2.Vpc("test", {
 *     ipv4IpamPoolId: testVpcIpamPool.id,
 *     ipv4NetmaskLength: 28,
 * }, {
 *     dependsOn: [testVpcIpamPoolCidr],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_region()
 * test = aws.ec2.VpcIpam("test", operating_regions=[{
 *     "region_name": current.name,
 * }])
 * test_vpc_ipam_pool = aws.ec2.VpcIpamPool("test",
 *     address_family="ipv4",
 *     ipam_scope_id=test.private_default_scope_id,
 *     locale=current.name)
 * test_vpc_ipam_pool_cidr = aws.ec2.VpcIpamPoolCidr("test",
 *     ipam_pool_id=test_vpc_ipam_pool.id,
 *     cidr="172.20.0.0/16")
 * test_vpc = aws.ec2.Vpc("test",
 *     ipv4_ipam_pool_id=test_vpc_ipam_pool.id,
 *     ipv4_netmask_length=28,
 *     opts = pulumi.ResourceOptions(depends_on=[test_vpc_ipam_pool_cidr]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetRegion.Invoke();
 *     var test = new Aws.Ec2.VpcIpam("test", new()
 *     {
 *         OperatingRegions = new[]
 *         {
 *             new Aws.Ec2.Inputs.VpcIpamOperatingRegionArgs
 *             {
 *                 RegionName = current.Apply(getRegionResult => getRegionResult.Name),
 *             },
 *         },
 *     });
 *     var testVpcIpamPool = new Aws.Ec2.VpcIpamPool("test", new()
 *     {
 *         AddressFamily = "ipv4",
 *         IpamScopeId = test.PrivateDefaultScopeId,
 *         Locale = current.Apply(getRegionResult => getRegionResult.Name),
 *     });
 *     var testVpcIpamPoolCidr = new Aws.Ec2.VpcIpamPoolCidr("test", new()
 *     {
 *         IpamPoolId = testVpcIpamPool.Id,
 *         Cidr = "172.20.0.0/16",
 *     });
 *     var testVpc = new Aws.Ec2.Vpc("test", new()
 *     {
 *         Ipv4IpamPoolId = testVpcIpamPool.Id,
 *         Ipv4NetmaskLength = 28,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             testVpcIpamPoolCidr,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		test, err := ec2.NewVpcIpam(ctx, "test", &ec2.VpcIpamArgs{
 * 			OperatingRegions: ec2.VpcIpamOperatingRegionArray{
 * 				&ec2.VpcIpamOperatingRegionArgs{
 * 					RegionName: pulumi.String(current.Name),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testVpcIpamPool, err := ec2.NewVpcIpamPool(ctx, "test", &ec2.VpcIpamPoolArgs{
 * 			AddressFamily: pulumi.String("ipv4"),
 * 			IpamScopeId:   test.PrivateDefaultScopeId,
 * 			Locale:        pulumi.String(current.Name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testVpcIpamPoolCidr, err := ec2.NewVpcIpamPoolCidr(ctx, "test", &ec2.VpcIpamPoolCidrArgs{
 * 			IpamPoolId: testVpcIpamPool.ID(),
 * 			Cidr:       pulumi.String("172.20.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpc(ctx, "test", &ec2.VpcArgs{
 * 			Ipv4IpamPoolId:    testVpcIpamPool.ID(),
 * 			Ipv4NetmaskLength: pulumi.Int(28),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			testVpcIpamPoolCidr,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamPool;
 * import com.pulumi.aws.ec2.VpcIpamPoolArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidr;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var test = new VpcIpam("test", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var testVpcIpamPool = new VpcIpamPool("testVpcIpamPool", VpcIpamPoolArgs.builder()
 *             .addressFamily("ipv4")
 *             .ipamScopeId(test.privateDefaultScopeId())
 *             .locale(current.applyValue(getRegionResult -> getRegionResult.name()))
 *             .build());
 *         var testVpcIpamPoolCidr = new VpcIpamPoolCidr("testVpcIpamPoolCidr", VpcIpamPoolCidrArgs.builder()
 *             .ipamPoolId(testVpcIpamPool.id())
 *             .cidr("172.20.0.0/16")
 *             .build());
 *         var testVpc = new Vpc("testVpc", VpcArgs.builder()
 *             .ipv4IpamPoolId(testVpcIpamPool.id())
 *             .ipv4NetmaskLength(28)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(testVpcIpamPoolCidr)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:ec2:VpcIpam
 *     properties:
 *       operatingRegions:
 *         - regionName: ${current.name}
 *   testVpcIpamPool:
 *     type: aws:ec2:VpcIpamPool
 *     name: test
 *     properties:
 *       addressFamily: ipv4
 *       ipamScopeId: ${test.privateDefaultScopeId}
 *       locale: ${current.name}
 *   testVpcIpamPoolCidr:
 *     type: aws:ec2:VpcIpamPoolCidr
 *     name: test
 *     properties:
 *       ipamPoolId: ${testVpcIpamPool.id}
 *       cidr: 172.20.0.0/16
 *   testVpc:
 *     type: aws:ec2:Vpc
 *     name: test
 *     properties:
 *       ipv4IpamPoolId: ${testVpcIpamPool.id}
 *       ipv4NetmaskLength: 28
 *     options:
 *       dependson:
 *         - ${testVpcIpamPoolCidr}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPCs using the VPC `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpc:Vpc test_vpc vpc-a01106c2
 * ```
 * @property assignGeneratedIpv6CidrBlock Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block. Default is `false`. Conflicts with `ipv6_ipam_pool_id`
 * @property cidrBlock The IPv4 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv4_netmask_length`.
 * @property enableDnsHostnames A boolean flag to enable/disable DNS hostnames in the VPC. Defaults false.
 * @property enableDnsSupport A boolean flag to enable/disable DNS support in the VPC. Defaults to true.
 * @property enableNetworkAddressUsageMetrics Indicates whether Network Address Usage metrics are enabled for your VPC. Defaults to false.
 * @property instanceTenancy A tenancy option for instances launched into the VPC. Default is `default`, which ensures that EC2 instances launched in this VPC use the EC2 instance tenancy attribute specified when the EC2 instance is launched. The only other option is `dedicated`, which ensures that EC2 instances launched in this VPC are run on dedicated tenancy instances regardless of the tenancy attribute specified at launch. This has a dedicated per region fee of $2 per hour, plus an hourly per instance usage fee.
 * @property ipv4IpamPoolId The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
 * @property ipv4NetmaskLength The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a `ipv4_ipam_pool_id`.
 * @property ipv6CidrBlock IPv6 CIDR block to request from an IPAM Pool. Can be set explicitly or derived from IPAM using `ipv6_netmask_length`.
 * @property ipv6CidrBlockNetworkBorderGroup By default when an IPv6 CIDR is assigned to a VPC a default ipv6_cidr_block_network_border_group will be set to the region of the VPC. This can be changed to restrict advertisement of public addresses to specific Network Border Groups such as LocalZones.
 * @property ipv6IpamPoolId IPAM Pool ID for a IPv6 pool. Conflicts with `assign_generated_ipv6_cidr_block`.
 * @property ipv6NetmaskLength Netmask length to request from IPAM Pool. Conflicts with `ipv6_cidr_block`. This can be omitted if IPAM pool as a `allocation_default_netmask_length` set. Valid values are from `44` to `60` in increments of 4.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VpcArgs(
    public val assignGeneratedIpv6CidrBlock: Output<Boolean>? = null,
    public val cidrBlock: Output<String>? = null,
    public val enableDnsHostnames: Output<Boolean>? = null,
    public val enableDnsSupport: Output<Boolean>? = null,
    public val enableNetworkAddressUsageMetrics: Output<Boolean>? = null,
    public val instanceTenancy: Output<String>? = null,
    public val ipv4IpamPoolId: Output<String>? = null,
    public val ipv4NetmaskLength: Output<Int>? = null,
    public val ipv6CidrBlock: Output<String>? = null,
    public val ipv6CidrBlockNetworkBorderGroup: Output<String>? = null,
    public val ipv6IpamPoolId: Output<String>? = null,
    public val ipv6NetmaskLength: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcArgs = com.pulumi.aws.ec2.VpcArgs.builder()
        .assignGeneratedIpv6CidrBlock(assignGeneratedIpv6CidrBlock?.applyValue({ args0 -> args0 }))
        .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
        .enableDnsHostnames(enableDnsHostnames?.applyValue({ args0 -> args0 }))
        .enableDnsSupport(enableDnsSupport?.applyValue({ args0 -> args0 }))
        .enableNetworkAddressUsageMetrics(enableNetworkAddressUsageMetrics?.applyValue({ args0 -> args0 }))
        .instanceTenancy(instanceTenancy?.applyValue({ args0 -> args0 }))
        .ipv4IpamPoolId(ipv4IpamPoolId?.applyValue({ args0 -> args0 }))
        .ipv4NetmaskLength(ipv4NetmaskLength?.applyValue({ args0 -> args0 }))
        .ipv6CidrBlock(ipv6CidrBlock?.applyValue({ args0 -> args0 }))
        .ipv6CidrBlockNetworkBorderGroup(ipv6CidrBlockNetworkBorderGroup?.applyValue({ args0 -> args0 }))
        .ipv6IpamPoolId(ipv6IpamPoolId?.applyValue({ args0 -> args0 }))
        .ipv6NetmaskLength(ipv6NetmaskLength?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [VpcArgs].
 */
@PulumiTagMarker
public class VpcArgsBuilder internal constructor() {
    private var assignGeneratedIpv6CidrBlock: Output<Boolean>? = null

    private var cidrBlock: Output<String>? = null

    private var enableDnsHostnames: Output<Boolean>? = null

    private var enableDnsSupport: Output<Boolean>? = null

    private var enableNetworkAddressUsageMetrics: Output<Boolean>? = null

    private var instanceTenancy: Output<String>? = null

    private var ipv4IpamPoolId: Output<String>? = null

    private var ipv4NetmaskLength: Output<Int>? = null

    private var ipv6CidrBlock: Output<String>? = null

    private var ipv6CidrBlockNetworkBorderGroup: Output<String>? = null

    private var ipv6IpamPoolId: Output<String>? = null

    private var ipv6NetmaskLength: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block. Default is `false`. Conflicts with `ipv6_ipam_pool_id`
     */
    @JvmName("sttmhxlnnxncgdur")
    public suspend fun assignGeneratedIpv6CidrBlock(`value`: Output<Boolean>) {
        this.assignGeneratedIpv6CidrBlock = value
    }

    /**
     * @param value The IPv4 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv4_netmask_length`.
     */
    @JvmName("mrgrfxpfxkmmheqe")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value A boolean flag to enable/disable DNS hostnames in the VPC. Defaults false.
     */
    @JvmName("ddhwrwhugdtlibxx")
    public suspend fun enableDnsHostnames(`value`: Output<Boolean>) {
        this.enableDnsHostnames = value
    }

    /**
     * @param value A boolean flag to enable/disable DNS support in the VPC. Defaults to true.
     */
    @JvmName("skqiubldpcxdnccp")
    public suspend fun enableDnsSupport(`value`: Output<Boolean>) {
        this.enableDnsSupport = value
    }

    /**
     * @param value Indicates whether Network Address Usage metrics are enabled for your VPC. Defaults to false.
     */
    @JvmName("tfbrlrtjmytubgfl")
    public suspend fun enableNetworkAddressUsageMetrics(`value`: Output<Boolean>) {
        this.enableNetworkAddressUsageMetrics = value
    }

    /**
     * @param value A tenancy option for instances launched into the VPC. Default is `default`, which ensures that EC2 instances launched in this VPC use the EC2 instance tenancy attribute specified when the EC2 instance is launched. The only other option is `dedicated`, which ensures that EC2 instances launched in this VPC are run on dedicated tenancy instances regardless of the tenancy attribute specified at launch. This has a dedicated per region fee of $2 per hour, plus an hourly per instance usage fee.
     */
    @JvmName("rntqlmrqawoftkrr")
    public suspend fun instanceTenancy(`value`: Output<String>) {
        this.instanceTenancy = value
    }

    /**
     * @param value The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
     */
    @JvmName("dkuhvrxibraminrc")
    public suspend fun ipv4IpamPoolId(`value`: Output<String>) {
        this.ipv4IpamPoolId = value
    }

    /**
     * @param value The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a `ipv4_ipam_pool_id`.
     */
    @JvmName("tmwunnstsjcbbgkm")
    public suspend fun ipv4NetmaskLength(`value`: Output<Int>) {
        this.ipv4NetmaskLength = value
    }

    /**
     * @param value IPv6 CIDR block to request from an IPAM Pool. Can be set explicitly or derived from IPAM using `ipv6_netmask_length`.
     */
    @JvmName("nmrgdntqtqhqmlgk")
    public suspend fun ipv6CidrBlock(`value`: Output<String>) {
        this.ipv6CidrBlock = value
    }

    /**
     * @param value By default when an IPv6 CIDR is assigned to a VPC a default ipv6_cidr_block_network_border_group will be set to the region of the VPC. This can be changed to restrict advertisement of public addresses to specific Network Border Groups such as LocalZones.
     */
    @JvmName("abxkfamntkrtbnyw")
    public suspend fun ipv6CidrBlockNetworkBorderGroup(`value`: Output<String>) {
        this.ipv6CidrBlockNetworkBorderGroup = value
    }

    /**
     * @param value IPAM Pool ID for a IPv6 pool. Conflicts with `assign_generated_ipv6_cidr_block`.
     */
    @JvmName("wwbnfenprahwvlli")
    public suspend fun ipv6IpamPoolId(`value`: Output<String>) {
        this.ipv6IpamPoolId = value
    }

    /**
     * @param value Netmask length to request from IPAM Pool. Conflicts with `ipv6_cidr_block`. This can be omitted if IPAM pool as a `allocation_default_netmask_length` set. Valid values are from `44` to `60` in increments of 4.
     */
    @JvmName("ansvirqajmmxsjfk")
    public suspend fun ipv6NetmaskLength(`value`: Output<Int>) {
        this.ipv6NetmaskLength = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ufkygoxyvhaeiaeb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block. Default is `false`. Conflicts with `ipv6_ipam_pool_id`
     */
    @JvmName("bwxpwqeldhuslqhp")
    public suspend fun assignGeneratedIpv6CidrBlock(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignGeneratedIpv6CidrBlock = mapped
    }

    /**
     * @param value The IPv4 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv4_netmask_length`.
     */
    @JvmName("tckmggldhnwerndf")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value A boolean flag to enable/disable DNS hostnames in the VPC. Defaults false.
     */
    @JvmName("cxeddsuavirntnex")
    public suspend fun enableDnsHostnames(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDnsHostnames = mapped
    }

    /**
     * @param value A boolean flag to enable/disable DNS support in the VPC. Defaults to true.
     */
    @JvmName("hyohjxjbdmshwddr")
    public suspend fun enableDnsSupport(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDnsSupport = mapped
    }

    /**
     * @param value Indicates whether Network Address Usage metrics are enabled for your VPC. Defaults to false.
     */
    @JvmName("oovhnbixlttmiwsn")
    public suspend fun enableNetworkAddressUsageMetrics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNetworkAddressUsageMetrics = mapped
    }

    /**
     * @param value A tenancy option for instances launched into the VPC. Default is `default`, which ensures that EC2 instances launched in this VPC use the EC2 instance tenancy attribute specified when the EC2 instance is launched. The only other option is `dedicated`, which ensures that EC2 instances launched in this VPC are run on dedicated tenancy instances regardless of the tenancy attribute specified at launch. This has a dedicated per region fee of $2 per hour, plus an hourly per instance usage fee.
     */
    @JvmName("ygpxhlhhoxougjme")
    public suspend fun instanceTenancy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceTenancy = mapped
    }

    /**
     * @param value The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
     */
    @JvmName("cabrnbblhoqtrmat")
    public suspend fun ipv4IpamPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4IpamPoolId = mapped
    }

    /**
     * @param value The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a `ipv4_ipam_pool_id`.
     */
    @JvmName("vbmvfwkvrstrkrjm")
    public suspend fun ipv4NetmaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4NetmaskLength = mapped
    }

    /**
     * @param value IPv6 CIDR block to request from an IPAM Pool. Can be set explicitly or derived from IPAM using `ipv6_netmask_length`.
     */
    @JvmName("yjwemruiecnqupot")
    public suspend fun ipv6CidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlock = mapped
    }

    /**
     * @param value By default when an IPv6 CIDR is assigned to a VPC a default ipv6_cidr_block_network_border_group will be set to the region of the VPC. This can be changed to restrict advertisement of public addresses to specific Network Border Groups such as LocalZones.
     */
    @JvmName("llrjkrfbbinqdpgd")
    public suspend fun ipv6CidrBlockNetworkBorderGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlockNetworkBorderGroup = mapped
    }

    /**
     * @param value IPAM Pool ID for a IPv6 pool. Conflicts with `assign_generated_ipv6_cidr_block`.
     */
    @JvmName("njjwgcsvkipjywon")
    public suspend fun ipv6IpamPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6IpamPoolId = mapped
    }

    /**
     * @param value Netmask length to request from IPAM Pool. Conflicts with `ipv6_cidr_block`. This can be omitted if IPAM pool as a `allocation_default_netmask_length` set. Valid values are from `44` to `60` in increments of 4.
     */
    @JvmName("wgenfondodwmsvmb")
    public suspend fun ipv6NetmaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6NetmaskLength = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qufsbmvtypyxrtyf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jmtnkuhvmypytnjw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VpcArgs = VpcArgs(
        assignGeneratedIpv6CidrBlock = assignGeneratedIpv6CidrBlock,
        cidrBlock = cidrBlock,
        enableDnsHostnames = enableDnsHostnames,
        enableDnsSupport = enableDnsSupport,
        enableNetworkAddressUsageMetrics = enableNetworkAddressUsageMetrics,
        instanceTenancy = instanceTenancy,
        ipv4IpamPoolId = ipv4IpamPoolId,
        ipv4NetmaskLength = ipv4NetmaskLength,
        ipv6CidrBlock = ipv6CidrBlock,
        ipv6CidrBlockNetworkBorderGroup = ipv6CidrBlockNetworkBorderGroup,
        ipv6IpamPoolId = ipv6IpamPoolId,
        ipv6NetmaskLength = ipv6NetmaskLength,
        tags = tags,
    )
}
