@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcDhcpOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC DHCP Options resource.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const dnsResolver = new aws.ec2.VpcDhcpOptions("dns_resolver", {domainNameServers: [
 *     "8.8.8.8",
 *     "8.8.4.4",
 * ]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * dns_resolver = aws.ec2.VpcDhcpOptions("dns_resolver", domain_name_servers=[
 *     "8.8.8.8",
 *     "8.8.4.4",
 * ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dnsResolver = new Aws.Ec2.VpcDhcpOptions("dns_resolver", new()
 *     {
 *         DomainNameServers = new[]
 *         {
 *             "8.8.8.8",
 *             "8.8.4.4",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcDhcpOptions(ctx, "dns_resolver", &ec2.VpcDhcpOptionsArgs{
 * 			DomainNameServers: pulumi.StringArray{
 * 				pulumi.String("8.8.8.8"),
 * 				pulumi.String("8.8.4.4"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcDhcpOptions;
 * import com.pulumi.aws.ec2.VpcDhcpOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dnsResolver = new VpcDhcpOptions("dnsResolver", VpcDhcpOptionsArgs.builder()
 *             .domainNameServers(
 *                 "8.8.8.8",
 *                 "8.8.4.4")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   dnsResolver:
 *     type: aws:ec2:VpcDhcpOptions
 *     name: dns_resolver
 *     properties:
 *       domainNameServers:
 *         - 8.8.8.8
 *         - 8.8.4.4
 * ```
 * <!--End PulumiCodeChooser -->
 * Full usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.ec2.VpcDhcpOptions("foo", {
 *     domainName: "service.consul",
 *     domainNameServers: [
 *         "127.0.0.1",
 *         "10.0.0.2",
 *     ],
 *     ipv6AddressPreferredLeaseTime: "1440",
 *     ntpServers: ["127&#46;0&#46;0&#46;1"],
 *     netbiosNameServers: ["127&#46;0&#46;0&#46;1"],
 *     netbiosNodeType: "2",
 *     tags: {
 *         Name: "foo-name",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.ec2.VpcDhcpOptions("foo",
 *     domain_name="service.consul",
 *     domain_name_servers=[
 *         "127.0.0.1",
 *         "10.0.0.2",
 *     ],
 *     ipv6_address_preferred_lease_time="1440",
 *     ntp_servers=["127&#46;0&#46;0&#46;1"],
 *     netbios_name_servers=["127&#46;0&#46;0&#46;1"],
 *     netbios_node_type="2",
 *     tags={
 *         "Name": "foo-name",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.Ec2.VpcDhcpOptions("foo", new()
 *     {
 *         DomainName = "service.consul",
 *         DomainNameServers = new[]
 *         {
 *             "127.0.0.1",
 *             "10.0.0.2",
 *         },
 *         Ipv6AddressPreferredLeaseTime = "1440",
 *         NtpServers = new[]
 *         {
 *             "127.0.0.1",
 *         },
 *         NetbiosNameServers = new[]
 *         {
 *             "127.0.0.1",
 *         },
 *         NetbiosNodeType = "2",
 *         Tags =
 *         {
 *             { "Name", "foo-name" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcDhcpOptions(ctx, "foo", &ec2.VpcDhcpOptionsArgs{
 * 			DomainName: pulumi.String("service.consul"),
 * 			DomainNameServers: pulumi.StringArray{
 * 				pulumi.String("127.0.0.1"),
 * 				pulumi.String("10.0.0.2"),
 * 			},
 * 			Ipv6AddressPreferredLeaseTime: pulumi.String("1440"),
 * 			NtpServers: pulumi.StringArray{
 * 				pulumi.String("127.0.0.1"),
 * 			},
 * 			NetbiosNameServers: pulumi.StringArray{
 * 				pulumi.String("127.0.0.1"),
 * 			},
 * 			NetbiosNodeType: pulumi.String("2"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("foo-name"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcDhcpOptions;
 * import com.pulumi.aws.ec2.VpcDhcpOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new VpcDhcpOptions("foo", VpcDhcpOptionsArgs.builder()
 *             .domainName("service.consul")
 *             .domainNameServers(
 *                 "127.0.0.1",
 *                 "10.0.0.2")
 *             .ipv6AddressPreferredLeaseTime(1440)
 *             .ntpServers("127.0.0.1")
 *             .netbiosNameServers("127.0.0.1")
 *             .netbiosNodeType(2)
 *             .tags(Map.of("Name", "foo-name"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:ec2:VpcDhcpOptions
 *     properties:
 *       domainName: service.consul
 *       domainNameServers:
 *         - 127.0.0.1
 *         - 10.0.0.2
 *       ipv6AddressPreferredLeaseTime: 1440
 *       ntpServers:
 *         - 127.0.0.1
 *       netbiosNameServers:
 *         - 127.0.0.1
 *       netbiosNodeType: 2
 *       tags:
 *         Name: foo-name
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Remarks
 * * Notice that all arguments are optional but you have to specify at least one argument.
 * * `domain_name_servers`, `netbios_name_servers`, `ntp_servers` are limited by AWS to maximum four servers only.
 * * To actually use the DHCP Options Set you need to associate it to a VPC using `aws.ec2.VpcDhcpOptionsAssociation`.
 * * If you delete a DHCP Options Set, all VPCs using it will be associated to AWS's `default` DHCP Option Set.
 * * In most cases unless you're configuring your own DNS you'll want to set `domain_name_servers` to `AmazonProvidedDNS`.
 * ## Import
 * Using `pulumi import`, import VPC DHCP Options using the DHCP Options `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcDhcpOptions:VpcDhcpOptions my_options dopt-d9070ebb
 * ```
 * @property domainName the suffix domain name to use by default when resolving non Fully Qualified Domain Names. In other words, this is what ends up being the `search` value in the `/etc/resolv.conf` file.
 * @property domainNameServers List of name servers to configure in `/etc/resolv.conf`. If you want to use the default AWS nameservers you should set this to `AmazonProvidedDNS`.
 * @property ipv6AddressPreferredLeaseTime How frequently, in seconds, a running instance with an IPv6 assigned to it goes through DHCPv6 lease renewal. Acceptable values are between 140 and 2147483647 (approximately 68 years). If no value is entered, the default lease time is 140 seconds. If you use long-term addressing for EC2 instances, you can increase the lease time and avoid frequent lease renewal requests. Lease renewal typically occurs when half of the lease time has elapsed.
 * @property netbiosNameServers List of NETBIOS name servers.
 * @property netbiosNodeType The NetBIOS node type (1, 2, 4, or 8). AWS recommends to specify 2 since broadcast and multicast are not supported in their network. For more information about these node types, see [RFC 2132](http://www.ietf.org/rfc/rfc2132.txt).
 * @property ntpServers List of NTP servers to configure.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VpcDhcpOptionsArgs(
    public val domainName: Output<String>? = null,
    public val domainNameServers: Output<List<String>>? = null,
    public val ipv6AddressPreferredLeaseTime: Output<String>? = null,
    public val netbiosNameServers: Output<List<String>>? = null,
    public val netbiosNodeType: Output<String>? = null,
    public val ntpServers: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcDhcpOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcDhcpOptionsArgs =
        com.pulumi.aws.ec2.VpcDhcpOptionsArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .domainNameServers(domainNameServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv6AddressPreferredLeaseTime(ipv6AddressPreferredLeaseTime?.applyValue({ args0 -> args0 }))
            .netbiosNameServers(netbiosNameServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .netbiosNodeType(netbiosNodeType?.applyValue({ args0 -> args0 }))
            .ntpServers(ntpServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VpcDhcpOptionsArgs].
 */
@PulumiTagMarker
public class VpcDhcpOptionsArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var domainNameServers: Output<List<String>>? = null

    private var ipv6AddressPreferredLeaseTime: Output<String>? = null

    private var netbiosNameServers: Output<List<String>>? = null

    private var netbiosNodeType: Output<String>? = null

    private var ntpServers: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value the suffix domain name to use by default when resolving non Fully Qualified Domain Names. In other words, this is what ends up being the `search` value in the `/etc/resolv.conf` file.
     */
    @JvmName("labhxufuwlhwvyak")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value List of name servers to configure in `/etc/resolv.conf`. If you want to use the default AWS nameservers you should set this to `AmazonProvidedDNS`.
     */
    @JvmName("cqmjowgacawtfjop")
    public suspend fun domainNameServers(`value`: Output<List<String>>) {
        this.domainNameServers = value
    }

    @JvmName("rmohldkmjmpkvlyw")
    public suspend fun domainNameServers(vararg values: Output<String>) {
        this.domainNameServers = Output.all(values.asList())
    }

    /**
     * @param values List of name servers to configure in `/etc/resolv.conf`. If you want to use the default AWS nameservers you should set this to `AmazonProvidedDNS`.
     */
    @JvmName("nspdeqmewlsccwgm")
    public suspend fun domainNameServers(values: List<Output<String>>) {
        this.domainNameServers = Output.all(values)
    }

    /**
     * @param value How frequently, in seconds, a running instance with an IPv6 assigned to it goes through DHCPv6 lease renewal. Acceptable values are between 140 and 2147483647 (approximately 68 years). If no value is entered, the default lease time is 140 seconds. If you use long-term addressing for EC2 instances, you can increase the lease time and avoid frequent lease renewal requests. Lease renewal typically occurs when half of the lease time has elapsed.
     */
    @JvmName("lwxpcvcfcossjblg")
    public suspend fun ipv6AddressPreferredLeaseTime(`value`: Output<String>) {
        this.ipv6AddressPreferredLeaseTime = value
    }

    /**
     * @param value List of NETBIOS name servers.
     */
    @JvmName("gmcwjsbufnnyocqo")
    public suspend fun netbiosNameServers(`value`: Output<List<String>>) {
        this.netbiosNameServers = value
    }

    @JvmName("xdkksctpbwucjixy")
    public suspend fun netbiosNameServers(vararg values: Output<String>) {
        this.netbiosNameServers = Output.all(values.asList())
    }

    /**
     * @param values List of NETBIOS name servers.
     */
    @JvmName("hjetndrwcfhskhmv")
    public suspend fun netbiosNameServers(values: List<Output<String>>) {
        this.netbiosNameServers = Output.all(values)
    }

    /**
     * @param value The NetBIOS node type (1, 2, 4, or 8). AWS recommends to specify 2 since broadcast and multicast are not supported in their network. For more information about these node types, see [RFC 2132](http://www.ietf.org/rfc/rfc2132.txt).
     */
    @JvmName("wrssxqtakpjvlwet")
    public suspend fun netbiosNodeType(`value`: Output<String>) {
        this.netbiosNodeType = value
    }

    /**
     * @param value List of NTP servers to configure.
     */
    @JvmName("cuonlwyhqhvwtnev")
    public suspend fun ntpServers(`value`: Output<List<String>>) {
        this.ntpServers = value
    }

    @JvmName("aesuhyjhhhlqbcpl")
    public suspend fun ntpServers(vararg values: Output<String>) {
        this.ntpServers = Output.all(values.asList())
    }

    /**
     * @param values List of NTP servers to configure.
     */
    @JvmName("adfexojjoajfubgy")
    public suspend fun ntpServers(values: List<Output<String>>) {
        this.ntpServers = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ptyuinlqvrrbsvaf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value the suffix domain name to use by default when resolving non Fully Qualified Domain Names. In other words, this is what ends up being the `search` value in the `/etc/resolv.conf` file.
     */
    @JvmName("ncpblcskpkrpsskl")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value List of name servers to configure in `/etc/resolv.conf`. If you want to use the default AWS nameservers you should set this to `AmazonProvidedDNS`.
     */
    @JvmName("etwxfmbngohglkuh")
    public suspend fun domainNameServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainNameServers = mapped
    }

    /**
     * @param values List of name servers to configure in `/etc/resolv.conf`. If you want to use the default AWS nameservers you should set this to `AmazonProvidedDNS`.
     */
    @JvmName("orwqlkrvubunmbpv")
    public suspend fun domainNameServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainNameServers = mapped
    }

    /**
     * @param value How frequently, in seconds, a running instance with an IPv6 assigned to it goes through DHCPv6 lease renewal. Acceptable values are between 140 and 2147483647 (approximately 68 years). If no value is entered, the default lease time is 140 seconds. If you use long-term addressing for EC2 instances, you can increase the lease time and avoid frequent lease renewal requests. Lease renewal typically occurs when half of the lease time has elapsed.
     */
    @JvmName("ykpqebgupxiqphdt")
    public suspend fun ipv6AddressPreferredLeaseTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressPreferredLeaseTime = mapped
    }

    /**
     * @param value List of NETBIOS name servers.
     */
    @JvmName("lxdulbleetqoamvs")
    public suspend fun netbiosNameServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netbiosNameServers = mapped
    }

    /**
     * @param values List of NETBIOS name servers.
     */
    @JvmName("lchsdddfdoraoylw")
    public suspend fun netbiosNameServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.netbiosNameServers = mapped
    }

    /**
     * @param value The NetBIOS node type (1, 2, 4, or 8). AWS recommends to specify 2 since broadcast and multicast are not supported in their network. For more information about these node types, see [RFC 2132](http://www.ietf.org/rfc/rfc2132.txt).
     */
    @JvmName("hvkjiqwvhkulgncw")
    public suspend fun netbiosNodeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netbiosNodeType = mapped
    }

    /**
     * @param value List of NTP servers to configure.
     */
    @JvmName("okaxkslpwcqwdoyy")
    public suspend fun ntpServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ntpServers = mapped
    }

    /**
     * @param values List of NTP servers to configure.
     */
    @JvmName("yuipxbpxjegspasi")
    public suspend fun ntpServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ntpServers = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ovvhofhxdbvuisvq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("acwllaxgfqlhyukh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VpcDhcpOptionsArgs = VpcDhcpOptionsArgs(
        domainName = domainName,
        domainNameServers = domainNameServers,
        ipv6AddressPreferredLeaseTime = ipv6AddressPreferredLeaseTime,
        netbiosNameServers = netbiosNameServers,
        netbiosNodeType = netbiosNodeType,
        ntpServers = ntpServers,
        tags = tags,
    )
}
