@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcDhcpOptionsAssociation].
 */
@PulumiTagMarker
public class VpcDhcpOptionsAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcDhcpOptionsAssociationArgs = VpcDhcpOptionsAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcDhcpOptionsAssociationArgsBuilder.() -> Unit) {
        val builder = VpcDhcpOptionsAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcDhcpOptionsAssociation {
        val builtJavaResource = com.pulumi.aws.ec2.VpcDhcpOptionsAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcDhcpOptionsAssociation(builtJavaResource)
    }
}

/**
 * Provides a VPC DHCP Options Association resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const dnsResolver = new aws.ec2.VpcDhcpOptionsAssociation("dns_resolver", {
 *     vpcId: fooAwsVpc.id,
 *     dhcpOptionsId: foo.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * dns_resolver = aws.ec2.VpcDhcpOptionsAssociation("dns_resolver",
 *     vpc_id=foo_aws_vpc["id"],
 *     dhcp_options_id=foo["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dnsResolver = new Aws.Ec2.VpcDhcpOptionsAssociation("dns_resolver", new()
 *     {
 *         VpcId = fooAwsVpc.Id,
 *         DhcpOptionsId = foo.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcDhcpOptionsAssociation(ctx, "dns_resolver", &ec2.VpcDhcpOptionsAssociationArgs{
 * 			VpcId:         pulumi.Any(fooAwsVpc.Id),
 * 			DhcpOptionsId: pulumi.Any(foo.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcDhcpOptionsAssociation;
 * import com.pulumi.aws.ec2.VpcDhcpOptionsAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dnsResolver = new VpcDhcpOptionsAssociation("dnsResolver", VpcDhcpOptionsAssociationArgs.builder()
 *             .vpcId(fooAwsVpc.id())
 *             .dhcpOptionsId(foo.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   dnsResolver:
 *     type: aws:ec2:VpcDhcpOptionsAssociation
 *     name: dns_resolver
 *     properties:
 *       vpcId: ${fooAwsVpc.id}
 *       dhcpOptionsId: ${foo.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Remarks
 * * You can only associate one DHCP Options Set to a given VPC ID.
 * * Removing the DHCP Options Association automatically sets AWS's `default` DHCP Options Set to the VPC.
 * ## Import
 * Using `pulumi import`, import DHCP associations using the VPC ID associated with the options. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcDhcpOptionsAssociation:VpcDhcpOptionsAssociation imported vpc-0f001273ec18911b1
 * ```
 */
public class VpcDhcpOptionsAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcDhcpOptionsAssociation,
) : KotlinCustomResource(javaResource, VpcDhcpOptionsAssociationMapper) {
    /**
     * The ID of the DHCP Options Set to associate to the VPC.
     */
    public val dhcpOptionsId: Output<String>
        get() = javaResource.dhcpOptionsId().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC to which we would like to associate a DHCP Options Set.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object VpcDhcpOptionsAssociationMapper : ResourceMapper<VpcDhcpOptionsAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcDhcpOptionsAssociation::class == javaResource::class

    override fun map(javaResource: Resource): VpcDhcpOptionsAssociation =
        VpcDhcpOptionsAssociation(javaResource as com.pulumi.aws.ec2.VpcDhcpOptionsAssociation)
}

/**
 * @see [VpcDhcpOptionsAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcDhcpOptionsAssociation].
 */
public suspend fun vpcDhcpOptionsAssociation(
    name: String,
    block: suspend VpcDhcpOptionsAssociationResourceBuilder.() -> Unit,
): VpcDhcpOptionsAssociation {
    val builder = VpcDhcpOptionsAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcDhcpOptionsAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcDhcpOptionsAssociation(name: String): VpcDhcpOptionsAssociation {
    val builder = VpcDhcpOptionsAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
