@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.VpcEndpointDnsEntry
import com.pulumi.aws.ec2.kotlin.outputs.VpcEndpointDnsOptions
import com.pulumi.aws.ec2.kotlin.outputs.VpcEndpointSubnetConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.VpcEndpointDnsEntry.Companion.toKotlin as vpcEndpointDnsEntryToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.VpcEndpointDnsOptions.Companion.toKotlin as vpcEndpointDnsOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.VpcEndpointSubnetConfiguration.Companion.toKotlin as vpcEndpointSubnetConfigurationToKotlin

/**
 * Builder for [VpcEndpoint].
 */
@PulumiTagMarker
public class VpcEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcEndpointArgs = VpcEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcEndpointArgsBuilder.() -> Unit) {
        val builder = VpcEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcEndpoint {
        val builtJavaResource = com.pulumi.aws.ec2.VpcEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcEndpoint(builtJavaResource)
    }
}

/**
 * Provides a VPC Endpoint resource.
 * > **NOTE on VPC Endpoints and VPC Endpoint Associations:** The provider provides both standalone VPC Endpoint Associations for
 * Route Tables - (an association between a VPC endpoint and a single `route_table_id`),
 * Security Groups - (an association between a VPC endpoint and a single `security_group_id`),
 * and Subnets - (an association between a VPC endpoint and a single `subnet_id`) and
 * a VPC Endpoint resource with `route_table_ids` and `subnet_ids` attributes.
 * Do not use the same resource ID in both a VPC Endpoint resource and a VPC Endpoint Association resource.
 * Doing so will cause a conflict of associations and will overwrite the association.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const s3 = new aws.ec2.VpcEndpoint("s3", {
 *     vpcId: main.id,
 *     serviceName: "com.amazonaws.us-west-2.s3",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * s3 = aws.ec2.VpcEndpoint("s3",
 *     vpc_id=main["id"],
 *     service_name="com.amazonaws.us-west-2.s3")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var s3 = new Aws.Ec2.VpcEndpoint("s3", new()
 *     {
 *         VpcId = main.Id,
 *         ServiceName = "com.amazonaws.us-west-2.s3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcEndpoint(ctx, "s3", &ec2.VpcEndpointArgs{
 * 			VpcId:       pulumi.Any(main.Id),
 * 			ServiceName: pulumi.String("com.amazonaws.us-west-2.s3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var s3 = new VpcEndpoint("s3", VpcEndpointArgs.builder()
 *             .vpcId(main.id())
 *             .serviceName("com.amazonaws.us-west-2.s3")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   s3:
 *     type: aws:ec2:VpcEndpoint
 *     properties:
 *       vpcId: ${main.id}
 *       serviceName: com.amazonaws.us-west-2.s3
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic w/ Tags
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const s3 = new aws.ec2.VpcEndpoint("s3", {
 *     vpcId: main.id,
 *     serviceName: "com.amazonaws.us-west-2.s3",
 *     tags: {
 *         Environment: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * s3 = aws.ec2.VpcEndpoint("s3",
 *     vpc_id=main["id"],
 *     service_name="com.amazonaws.us-west-2.s3",
 *     tags={
 *         "Environment": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var s3 = new Aws.Ec2.VpcEndpoint("s3", new()
 *     {
 *         VpcId = main.Id,
 *         ServiceName = "com.amazonaws.us-west-2.s3",
 *         Tags =
 *         {
 *             { "Environment", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcEndpoint(ctx, "s3", &ec2.VpcEndpointArgs{
 * 			VpcId:       pulumi.Any(main.Id),
 * 			ServiceName: pulumi.String("com.amazonaws.us-west-2.s3"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var s3 = new VpcEndpoint("s3", VpcEndpointArgs.builder()
 *             .vpcId(main.id())
 *             .serviceName("com.amazonaws.us-west-2.s3")
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   s3:
 *     type: aws:ec2:VpcEndpoint
 *     properties:
 *       vpcId: ${main.id}
 *       serviceName: com.amazonaws.us-west-2.s3
 *       tags:
 *         Environment: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Interface Endpoint Type
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ec2 = new aws.ec2.VpcEndpoint("ec2", {
 *     vpcId: main.id,
 *     serviceName: "com.amazonaws.us-west-2.ec2",
 *     vpcEndpointType: "Interface",
 *     securityGroupIds: [sg1&#46;id],
 *     privateDnsEnabled: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ec2 = aws.ec2.VpcEndpoint("ec2",
 *     vpc_id=main["id"],
 *     service_name="com.amazonaws.us-west-2.ec2",
 *     vpc_endpoint_type="Interface",
 *     security_group_ids=[sg1["id"]],
 *     private_dns_enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ec2 = new Aws.Ec2.VpcEndpoint("ec2", new()
 *     {
 *         VpcId = main.Id,
 *         ServiceName = "com.amazonaws.us-west-2.ec2",
 *         VpcEndpointType = "Interface",
 *         SecurityGroupIds = new[]
 *         {
 *             sg1.Id,
 *         },
 *         PrivateDnsEnabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcEndpoint(ctx, "ec2", &ec2.VpcEndpointArgs{
 * 			VpcId:           pulumi.Any(main.Id),
 * 			ServiceName:     pulumi.String("com.amazonaws.us-west-2.ec2"),
 * 			VpcEndpointType: pulumi.String("Interface"),
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				sg1.Id,
 * 			},
 * 			PrivateDnsEnabled: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ec2 = new VpcEndpoint("ec2", VpcEndpointArgs.builder()
 *             .vpcId(main.id())
 *             .serviceName("com.amazonaws.us-west-2.ec2")
 *             .vpcEndpointType("Interface")
 *             .securityGroupIds(sg1.id())
 *             .privateDnsEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   ec2:
 *     type: aws:ec2:VpcEndpoint
 *     properties:
 *       vpcId: ${main.id}
 *       serviceName: com.amazonaws.us-west-2.ec2
 *       vpcEndpointType: Interface
 *       securityGroupIds:
 *         - ${sg1.id}
 *       privateDnsEnabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Interface Endpoint Type with User-Defined IP Address
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ec2 = new aws.ec2.VpcEndpoint("ec2", {
 *     vpcId: example.id,
 *     serviceName: "com.amazonaws.us-west-2.ec2",
 *     vpcEndpointType: "Interface",
 *     subnetConfigurations: [
 *         {
 *             ipv4: "10.0.1.10",
 *             subnetId: example1.id,
 *         },
 *         {
 *             ipv4: "10.0.2.10",
 *             subnetId: example2.id,
 *         },
 *     ],
 *     subnetIds: [
 *         example1.id,
 *         example2.id,
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ec2 = aws.ec2.VpcEndpoint("ec2",
 *     vpc_id=example["id"],
 *     service_name="com.amazonaws.us-west-2.ec2",
 *     vpc_endpoint_type="Interface",
 *     subnet_configurations=[
 *         {
 *             "ipv4": "10.0.1.10",
 *             "subnet_id": example1["id"],
 *         },
 *         {
 *             "ipv4": "10.0.2.10",
 *             "subnet_id": example2["id"],
 *         },
 *     ],
 *     subnet_ids=[
 *         example1["id"],
 *         example2["id"],
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ec2 = new Aws.Ec2.VpcEndpoint("ec2", new()
 *     {
 *         VpcId = example.Id,
 *         ServiceName = "com.amazonaws.us-west-2.ec2",
 *         VpcEndpointType = "Interface",
 *         SubnetConfigurations = new[]
 *         {
 *             new Aws.Ec2.Inputs.VpcEndpointSubnetConfigurationArgs
 *             {
 *                 Ipv4 = "10.0.1.10",
 *                 SubnetId = example1.Id,
 *             },
 *             new Aws.Ec2.Inputs.VpcEndpointSubnetConfigurationArgs
 *             {
 *                 Ipv4 = "10.0.2.10",
 *                 SubnetId = example2.Id,
 *             },
 *         },
 *         SubnetIds = new[]
 *         {
 *             example1.Id,
 *             example2.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcEndpoint(ctx, "ec2", &ec2.VpcEndpointArgs{
 * 			VpcId:           pulumi.Any(example.Id),
 * 			ServiceName:     pulumi.String("com.amazonaws.us-west-2.ec2"),
 * 			VpcEndpointType: pulumi.String("Interface"),
 * 			SubnetConfigurations: ec2.VpcEndpointSubnetConfigurationArray{
 * 				&ec2.VpcEndpointSubnetConfigurationArgs{
 * 					Ipv4:     pulumi.String("10.0.1.10"),
 * 					SubnetId: pulumi.Any(example1.Id),
 * 				},
 * 				&ec2.VpcEndpointSubnetConfigurationArgs{
 * 					Ipv4:     pulumi.String("10.0.2.10"),
 * 					SubnetId: pulumi.Any(example2.Id),
 * 				},
 * 			},
 * 			SubnetIds: pulumi.StringArray{
 * 				example1.Id,
 * 				example2.Id,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import com.pulumi.aws.ec2.inputs.VpcEndpointSubnetConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ec2 = new VpcEndpoint("ec2", VpcEndpointArgs.builder()
 *             .vpcId(example.id())
 *             .serviceName("com.amazonaws.us-west-2.ec2")
 *             .vpcEndpointType("Interface")
 *             .subnetConfigurations(
 *                 VpcEndpointSubnetConfigurationArgs.builder()
 *                     .ipv4("10.0.1.10")
 *                     .subnetId(example1.id())
 *                     .build(),
 *                 VpcEndpointSubnetConfigurationArgs.builder()
 *                     .ipv4("10.0.2.10")
 *                     .subnetId(example2.id())
 *                     .build())
 *             .subnetIds(
 *                 example1.id(),
 *                 example2.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   ec2:
 *     type: aws:ec2:VpcEndpoint
 *     properties:
 *       vpcId: ${example.id}
 *       serviceName: com.amazonaws.us-west-2.ec2
 *       vpcEndpointType: Interface
 *       subnetConfigurations:
 *         - ipv4: 10.0.1.10
 *           subnetId: ${example1.id}
 *         - ipv4: 10.0.2.10
 *           subnetId: ${example2.id}
 *       subnetIds:
 *         - ${example1.id}
 *         - ${example2.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Gateway Load Balancer Endpoint Type
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const example = new aws.ec2.VpcEndpointService("example", {
 *     acceptanceRequired: false,
 *     allowedPrincipals: [current&#46;then(current => current&#46;arn)],
 *     gatewayLoadBalancerArns: [exampleAwsLb&#46;arn],
 * });
 * const exampleVpcEndpoint = new aws.ec2.VpcEndpoint("example", {
 *     serviceName: example.serviceName,
 *     subnetIds: [exampleAwsSubnet&#46;id],
 *     vpcEndpointType: example.serviceType,
 *     vpcId: exampleAwsVpc.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * example = aws.ec2.VpcEndpointService("example",
 *     acceptance_required=False,
 *     allowed_principals=[current&#46;arn],
 *     gateway_load_balancer_arns=[example_aws_lb["arn"]])
 * example_vpc_endpoint = aws.ec2.VpcEndpoint("example",
 *     service_name=example.service_name,
 *     subnet_ids=[example_aws_subnet["id"]],
 *     vpc_endpoint_type=example.service_type,
 *     vpc_id=example_aws_vpc["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var example = new Aws.Ec2.VpcEndpointService("example", new()
 *     {
 *         AcceptanceRequired = false,
 *         AllowedPrincipals = new[]
 *         {
 *             current.Apply(getCallerIdentityResult => getCallerIdentityResult.Arn),
 *         },
 *         GatewayLoadBalancerArns = new[]
 *         {
 *             exampleAwsLb.Arn,
 *         },
 *     });
 *     var exampleVpcEndpoint = new Aws.Ec2.VpcEndpoint("example", new()
 *     {
 *         ServiceName = example.ServiceName,
 *         SubnetIds = new[]
 *         {
 *             exampleAwsSubnet.Id,
 *         },
 *         VpcEndpointType = example.ServiceType,
 *         VpcId = exampleAwsVpc.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := ec2.NewVpcEndpointService(ctx, "example", &ec2.VpcEndpointServiceArgs{
 * 			AcceptanceRequired: pulumi.Bool(false),
 * 			AllowedPrincipals: pulumi.StringArray{
 * 				pulumi.String(current.Arn),
 * 			},
 * 			GatewayLoadBalancerArns: pulumi.StringArray{
 * 				exampleAwsLb.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpcEndpoint(ctx, "example", &ec2.VpcEndpointArgs{
 * 			ServiceName: example.ServiceName,
 * 			SubnetIds: pulumi.StringArray{
 * 				exampleAwsSubnet.Id,
 * 			},
 * 			VpcEndpointType: example.ServiceType,
 * 			VpcId:           pulumi.Any(exampleAwsVpc.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.VpcEndpointService;
 * import com.pulumi.aws.ec2.VpcEndpointServiceArgs;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var example = new VpcEndpointService("example", VpcEndpointServiceArgs.builder()
 *             .acceptanceRequired(false)
 *             .allowedPrincipals(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.arn()))
 *             .gatewayLoadBalancerArns(exampleAwsLb.arn())
 *             .build());
 *         var exampleVpcEndpoint = new VpcEndpoint("exampleVpcEndpoint", VpcEndpointArgs.builder()
 *             .serviceName(example.serviceName())
 *             .subnetIds(exampleAwsSubnet.id())
 *             .vpcEndpointType(example.serviceType())
 *             .vpcId(exampleAwsVpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:VpcEndpointService
 *     properties:
 *       acceptanceRequired: false
 *       allowedPrincipals:
 *         - ${current.arn}
 *       gatewayLoadBalancerArns:
 *         - ${exampleAwsLb.arn}
 *   exampleVpcEndpoint:
 *     type: aws:ec2:VpcEndpoint
 *     name: example
 *     properties:
 *       serviceName: ${example.serviceName}
 *       subnetIds:
 *         - ${exampleAwsSubnet.id}
 *       vpcEndpointType: ${example.serviceType}
 *       vpcId: ${exampleAwsVpc.id}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Endpoints using the VPC endpoint `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcEndpoint:VpcEndpoint endpoint1 vpce-3ecf2a57
 * ```
 */
public class VpcEndpoint internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcEndpoint,
) : KotlinCustomResource(javaResource, VpcEndpointMapper) {
    /**
     * The Amazon Resource Name (ARN) of the VPC endpoint.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Accept the VPC endpoint (the VPC endpoint and service need to be in the same AWS account).
     */
    public val autoAccept: Output<Boolean>?
        get() = javaResource.autoAccept().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of CIDR blocks for the exposed AWS service. Applicable for endpoints of type `Gateway`.
     */
    public val cidrBlocks: Output<List<String>>
        get() = javaResource.cidrBlocks().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The DNS entries for the VPC Endpoint. Applicable for endpoints of type `Interface`. DNS blocks are documented below.
     */
    public val dnsEntries: Output<List<VpcEndpointDnsEntry>>
        get() = javaResource.dnsEntries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    vpcEndpointDnsEntryToKotlin(args0)
                })
            })
        })

    /**
     * The DNS options for the endpoint. See dns_options below.
     */
    public val dnsOptions: Output<VpcEndpointDnsOptions>
        get() = javaResource.dnsOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                vpcEndpointDnsOptionsToKotlin(args0)
            })
        })

    /**
     * The IP address type for the endpoint. Valid values are `ipv4`, `dualstack`, and `ipv6`.
     */
    public val ipAddressType: Output<String>
        get() = javaResource.ipAddressType().applyValue({ args0 -> args0 })

    /**
     * One or more network interfaces for the VPC Endpoint. Applicable for endpoints of type `Interface`.
     */
    public val networkInterfaceIds: Output<List<String>>
        get() = javaResource.networkInterfaceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of the AWS account that owns the VPC endpoint.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * A policy to attach to the endpoint that controls access to the service. This is a JSON formatted string. Defaults to full access. All `Gateway` and some `Interface` endpoints support policies - see the [relevant AWS documentation](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-access.html) for more details.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The prefix list ID of the exposed AWS service. Applicable for endpoints of type `Gateway`.
     */
    public val prefixListId: Output<String>
        get() = javaResource.prefixListId().applyValue({ args0 -> args0 })

    /**
     * Whether or not to associate a private hosted zone with the specified VPC. Applicable for endpoints of type `Interface`. Most users will want this enabled to allow services within the VPC to automatically use the endpoint.
     * Defaults to `false`.
     */
    public val privateDnsEnabled: Output<Boolean>
        get() = javaResource.privateDnsEnabled().applyValue({ args0 -> args0 })

    /**
     * Whether or not the VPC Endpoint is being managed by its service - `true` or `false`.
     */
    public val requesterManaged: Output<Boolean>
        get() = javaResource.requesterManaged().applyValue({ args0 -> args0 })

    /**
     * One or more route table IDs. Applicable for endpoints of type `Gateway`.
     */
    public val routeTableIds: Output<List<String>>
        get() = javaResource.routeTableIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of one or more security groups to associate with the network interface. Applicable for endpoints of type `Interface`.
     * If no security groups are specified, the VPC's [default security group](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#DefaultSecurityGroup) is associated with the endpoint.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The service name. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
     */
    public val serviceName: Output<String>
        get() = javaResource.serviceName().applyValue({ args0 -> args0 })

    /**
     * The state of the VPC endpoint.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Subnet configuration for the endpoint, used to select specific IPv4 and/or IPv6 addresses to the endpoint. See subnet_configuration below.
     */
    public val subnetConfigurations: Output<List<VpcEndpointSubnetConfiguration>>
        get() = javaResource.subnetConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> vpcEndpointSubnetConfigurationToKotlin(args0) })
            })
        })

    /**
     * The ID of one or more subnets in which to create a network interface for the endpoint. Applicable for endpoints of type `GatewayLoadBalancer` and `Interface`. Interface type endpoints cannot function without being assigned to a subnet.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The VPC endpoint type, `Gateway`, `GatewayLoadBalancer`, or `Interface`. Defaults to `Gateway`.
     */
    public val vpcEndpointType: Output<String>?
        get() = javaResource.vpcEndpointType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the VPC in which the endpoint will be used.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object VpcEndpointMapper : ResourceMapper<VpcEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): VpcEndpoint = VpcEndpoint(
        javaResource as
            com.pulumi.aws.ec2.VpcEndpoint,
    )
}

/**
 * @see [VpcEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcEndpoint].
 */
public suspend fun vpcEndpoint(name: String, block: suspend VpcEndpointResourceBuilder.() -> Unit): VpcEndpoint {
    val builder = VpcEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcEndpoint(name: String): VpcEndpoint {
    val builder = VpcEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
