@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VpcEndpointConnectionNotification].
 */
@PulumiTagMarker
public class VpcEndpointConnectionNotificationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcEndpointConnectionNotificationArgs = VpcEndpointConnectionNotificationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcEndpointConnectionNotificationArgsBuilder.() -> Unit) {
        val builder = VpcEndpointConnectionNotificationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcEndpointConnectionNotification {
        val builtJavaResource =
            com.pulumi.aws.ec2.VpcEndpointConnectionNotification(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VpcEndpointConnectionNotification(builtJavaResource)
    }
}

/**
 * Provides a VPC Endpoint connection notification resource.
 * Connection notifications notify subscribers of VPC Endpoint events.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const topic = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["vpce&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["SNS:Publish"],
 *         resources: ["arn:aws:sns:*:*:vpce-notification-topic"],
 *     }],
 * });
 * const topicTopic = new aws.sns.Topic("topic", {
 *     name: "vpce-notification-topic",
 *     policy: topic.then(topic => topic.json),
 * });
 * const foo = new aws.ec2.VpcEndpointService("foo", {
 *     acceptanceRequired: false,
 *     networkLoadBalancerArns: [test&#46;arn],
 * });
 * const fooVpcEndpointConnectionNotification = new aws.ec2.VpcEndpointConnectionNotification("foo", {
 *     vpcEndpointServiceId: foo.id,
 *     connectionNotificationArn: topicTopic.arn,
 *     connectionEvents: [
 *         "Accept",
 *         "Reject",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * topic = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["vpce&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["SNS:Publish"],
 *     "resources": ["arn:aws:sns:*:*:vpce-notification-topic"],
 * }])
 * topic_topic = aws.sns.Topic("topic",
 *     name="vpce-notification-topic",
 *     policy=topic.json)
 * foo = aws.ec2.VpcEndpointService("foo",
 *     acceptance_required=False,
 *     network_load_balancer_arns=[test["arn"]])
 * foo_vpc_endpoint_connection_notification = aws.ec2.VpcEndpointConnectionNotification("foo",
 *     vpc_endpoint_service_id=foo.id,
 *     connection_notification_arn=topic_topic.arn,
 *     connection_events=[
 *         "Accept",
 *         "Reject",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var topic = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "vpce.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "SNS:Publish",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:sns:*:*:vpce-notification-topic",
 *                 },
 *             },
 *         },
 *     });
 *     var topicTopic = new Aws.Sns.Topic("topic", new()
 *     {
 *         Name = "vpce-notification-topic",
 *         Policy = topic.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var foo = new Aws.Ec2.VpcEndpointService("foo", new()
 *     {
 *         AcceptanceRequired = false,
 *         NetworkLoadBalancerArns = new[]
 *         {
 *             test.Arn,
 *         },
 *     });
 *     var fooVpcEndpointConnectionNotification = new Aws.Ec2.VpcEndpointConnectionNotification("foo", new()
 *     {
 *         VpcEndpointServiceId = foo.Id,
 *         ConnectionNotificationArn = topicTopic.Arn,
 *         ConnectionEvents = new[]
 *         {
 *             "Accept",
 *             "Reject",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		topic, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"vpce.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"SNS:Publish",
 * 					},
 * 					Resources: []string{
 * 						"arn:aws:sns:*:*:vpce-notification-topic",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		topicTopic, err := sns.NewTopic(ctx, "topic", &sns.TopicArgs{
 * 			Name:   pulumi.String("vpce-notification-topic"),
 * 			Policy: pulumi.String(topic.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		foo, err := ec2.NewVpcEndpointService(ctx, "foo", &ec2.VpcEndpointServiceArgs{
 * 			AcceptanceRequired: pulumi.Bool(false),
 * 			NetworkLoadBalancerArns: pulumi.StringArray{
 * 				test.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpcEndpointConnectionNotification(ctx, "foo", &ec2.VpcEndpointConnectionNotificationArgs{
 * 			VpcEndpointServiceId:      foo.ID(),
 * 			ConnectionNotificationArn: topicTopic.Arn,
 * 			ConnectionEvents: pulumi.StringArray{
 * 				pulumi.String("Accept"),
 * 				pulumi.String("Reject"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.ec2.VpcEndpointService;
 * import com.pulumi.aws.ec2.VpcEndpointServiceArgs;
 * import com.pulumi.aws.ec2.VpcEndpointConnectionNotification;
 * import com.pulumi.aws.ec2.VpcEndpointConnectionNotificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var topic = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("vpce.amazonaws.com")
 *                     .build())
 *                 .actions("SNS:Publish")
 *                 .resources("arn:aws:sns:*:*:vpce-notification-topic")
 *                 .build())
 *             .build());
 *         var topicTopic = new Topic("topicTopic", TopicArgs.builder()
 *             .name("vpce-notification-topic")
 *             .policy(topic.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var foo = new VpcEndpointService("foo", VpcEndpointServiceArgs.builder()
 *             .acceptanceRequired(false)
 *             .networkLoadBalancerArns(test.arn())
 *             .build());
 *         var fooVpcEndpointConnectionNotification = new VpcEndpointConnectionNotification("fooVpcEndpointConnectionNotification", VpcEndpointConnectionNotificationArgs.builder()
 *             .vpcEndpointServiceId(foo.id())
 *             .connectionNotificationArn(topicTopic.arn())
 *             .connectionEvents(
 *                 "Accept",
 *                 "Reject")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   topicTopic:
 *     type: aws:sns:Topic
 *     name: topic
 *     properties:
 *       name: vpce-notification-topic
 *       policy: ${topic.json}
 *   foo:
 *     type: aws:ec2:VpcEndpointService
 *     properties:
 *       acceptanceRequired: false
 *       networkLoadBalancerArns:
 *         - ${test.arn}
 *   fooVpcEndpointConnectionNotification:
 *     type: aws:ec2:VpcEndpointConnectionNotification
 *     name: foo
 *     properties:
 *       vpcEndpointServiceId: ${foo.id}
 *       connectionNotificationArn: ${topicTopic.arn}
 *       connectionEvents:
 *         - Accept
 *         - Reject
 * variables:
 *   topic:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - vpce.amazonaws.com
 *             actions:
 *               - SNS:Publish
 *             resources:
 *               - arn:aws:sns:*:*:vpce-notification-topic
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Endpoint connection notifications using the VPC endpoint connection notification `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcEndpointConnectionNotification:VpcEndpointConnectionNotification foo vpce-nfn-09e6ed3b4efba2263
 * ```
 */
public class VpcEndpointConnectionNotification internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcEndpointConnectionNotification,
) : KotlinCustomResource(javaResource, VpcEndpointConnectionNotificationMapper) {
    /**
     * One or more endpoint [events](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointConnectionNotification.html#API_CreateVpcEndpointConnectionNotification_RequestParameters) for which to receive notifications.
     * > **NOTE:** One of `vpc_endpoint_service_id` or `vpc_endpoint_id` must be specified.
     */
    public val connectionEvents: Output<List<String>>
        get() = javaResource.connectionEvents().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ARN of the SNS topic for the notifications.
     */
    public val connectionNotificationArn: Output<String>
        get() = javaResource.connectionNotificationArn().applyValue({ args0 -> args0 })

    /**
     * The type of notification.
     */
    public val notificationType: Output<String>
        get() = javaResource.notificationType().applyValue({ args0 -> args0 })

    /**
     * The state of the notification.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC Endpoint to receive notifications for.
     */
    public val vpcEndpointId: Output<String>?
        get() = javaResource.vpcEndpointId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the VPC Endpoint Service to receive notifications for.
     */
    public val vpcEndpointServiceId: Output<String>?
        get() = javaResource.vpcEndpointServiceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VpcEndpointConnectionNotificationMapper :
    ResourceMapper<VpcEndpointConnectionNotification> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcEndpointConnectionNotification::class == javaResource::class

    override fun map(javaResource: Resource): VpcEndpointConnectionNotification =
        VpcEndpointConnectionNotification(
            javaResource as
                com.pulumi.aws.ec2.VpcEndpointConnectionNotification,
        )
}

/**
 * @see [VpcEndpointConnectionNotification].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcEndpointConnectionNotification].
 */
public suspend fun vpcEndpointConnectionNotification(
    name: String,
    block: suspend VpcEndpointConnectionNotificationResourceBuilder.() -> Unit,
): VpcEndpointConnectionNotification {
    val builder = VpcEndpointConnectionNotificationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcEndpointConnectionNotification].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcEndpointConnectionNotification(name: String): VpcEndpointConnectionNotification {
    val builder = VpcEndpointConnectionNotificationResourceBuilder()
    builder.name(name)
    return builder.build()
}
