@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcEndpointConnectionNotificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a VPC Endpoint connection notification resource.
 * Connection notifications notify subscribers of VPC Endpoint events.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const topic = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["vpce&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["SNS:Publish"],
 *         resources: ["arn:aws:sns:*:*:vpce-notification-topic"],
 *     }],
 * });
 * const topicTopic = new aws.sns.Topic("topic", {
 *     name: "vpce-notification-topic",
 *     policy: topic.then(topic => topic.json),
 * });
 * const foo = new aws.ec2.VpcEndpointService("foo", {
 *     acceptanceRequired: false,
 *     networkLoadBalancerArns: [test&#46;arn],
 * });
 * const fooVpcEndpointConnectionNotification = new aws.ec2.VpcEndpointConnectionNotification("foo", {
 *     vpcEndpointServiceId: foo.id,
 *     connectionNotificationArn: topicTopic.arn,
 *     connectionEvents: [
 *         "Accept",
 *         "Reject",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * topic = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["vpce&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["SNS:Publish"],
 *     "resources": ["arn:aws:sns:*:*:vpce-notification-topic"],
 * }])
 * topic_topic = aws.sns.Topic("topic",
 *     name="vpce-notification-topic",
 *     policy=topic.json)
 * foo = aws.ec2.VpcEndpointService("foo",
 *     acceptance_required=False,
 *     network_load_balancer_arns=[test["arn"]])
 * foo_vpc_endpoint_connection_notification = aws.ec2.VpcEndpointConnectionNotification("foo",
 *     vpc_endpoint_service_id=foo.id,
 *     connection_notification_arn=topic_topic.arn,
 *     connection_events=[
 *         "Accept",
 *         "Reject",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var topic = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "vpce.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "SNS:Publish",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:sns:*:*:vpce-notification-topic",
 *                 },
 *             },
 *         },
 *     });
 *     var topicTopic = new Aws.Sns.Topic("topic", new()
 *     {
 *         Name = "vpce-notification-topic",
 *         Policy = topic.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var foo = new Aws.Ec2.VpcEndpointService("foo", new()
 *     {
 *         AcceptanceRequired = false,
 *         NetworkLoadBalancerArns = new[]
 *         {
 *             test.Arn,
 *         },
 *     });
 *     var fooVpcEndpointConnectionNotification = new Aws.Ec2.VpcEndpointConnectionNotification("foo", new()
 *     {
 *         VpcEndpointServiceId = foo.Id,
 *         ConnectionNotificationArn = topicTopic.Arn,
 *         ConnectionEvents = new[]
 *         {
 *             "Accept",
 *             "Reject",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		topic, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"vpce.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"SNS:Publish",
 * 					},
 * 					Resources: []string{
 * 						"arn:aws:sns:*:*:vpce-notification-topic",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		topicTopic, err := sns.NewTopic(ctx, "topic", &sns.TopicArgs{
 * 			Name:   pulumi.String("vpce-notification-topic"),
 * 			Policy: pulumi.String(topic.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		foo, err := ec2.NewVpcEndpointService(ctx, "foo", &ec2.VpcEndpointServiceArgs{
 * 			AcceptanceRequired: pulumi.Bool(false),
 * 			NetworkLoadBalancerArns: pulumi.StringArray{
 * 				test.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpcEndpointConnectionNotification(ctx, "foo", &ec2.VpcEndpointConnectionNotificationArgs{
 * 			VpcEndpointServiceId:      foo.ID(),
 * 			ConnectionNotificationArn: topicTopic.Arn,
 * 			ConnectionEvents: pulumi.StringArray{
 * 				pulumi.String("Accept"),
 * 				pulumi.String("Reject"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.ec2.VpcEndpointService;
 * import com.pulumi.aws.ec2.VpcEndpointServiceArgs;
 * import com.pulumi.aws.ec2.VpcEndpointConnectionNotification;
 * import com.pulumi.aws.ec2.VpcEndpointConnectionNotificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var topic = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("vpce.amazonaws.com")
 *                     .build())
 *                 .actions("SNS:Publish")
 *                 .resources("arn:aws:sns:*:*:vpce-notification-topic")
 *                 .build())
 *             .build());
 *         var topicTopic = new Topic("topicTopic", TopicArgs.builder()
 *             .name("vpce-notification-topic")
 *             .policy(topic.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var foo = new VpcEndpointService("foo", VpcEndpointServiceArgs.builder()
 *             .acceptanceRequired(false)
 *             .networkLoadBalancerArns(test.arn())
 *             .build());
 *         var fooVpcEndpointConnectionNotification = new VpcEndpointConnectionNotification("fooVpcEndpointConnectionNotification", VpcEndpointConnectionNotificationArgs.builder()
 *             .vpcEndpointServiceId(foo.id())
 *             .connectionNotificationArn(topicTopic.arn())
 *             .connectionEvents(
 *                 "Accept",
 *                 "Reject")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   topicTopic:
 *     type: aws:sns:Topic
 *     name: topic
 *     properties:
 *       name: vpce-notification-topic
 *       policy: ${topic.json}
 *   foo:
 *     type: aws:ec2:VpcEndpointService
 *     properties:
 *       acceptanceRequired: false
 *       networkLoadBalancerArns:
 *         - ${test.arn}
 *   fooVpcEndpointConnectionNotification:
 *     type: aws:ec2:VpcEndpointConnectionNotification
 *     name: foo
 *     properties:
 *       vpcEndpointServiceId: ${foo.id}
 *       connectionNotificationArn: ${topicTopic.arn}
 *       connectionEvents:
 *         - Accept
 *         - Reject
 * variables:
 *   topic:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - vpce.amazonaws.com
 *             actions:
 *               - SNS:Publish
 *             resources:
 *               - arn:aws:sns:*:*:vpce-notification-topic
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Endpoint connection notifications using the VPC endpoint connection notification `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcEndpointConnectionNotification:VpcEndpointConnectionNotification foo vpce-nfn-09e6ed3b4efba2263
 * ```
 * @property connectionEvents One or more endpoint [events](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointConnectionNotification.html#API_CreateVpcEndpointConnectionNotification_RequestParameters) for which to receive notifications.
 * > **NOTE:** One of `vpc_endpoint_service_id` or `vpc_endpoint_id` must be specified.
 * @property connectionNotificationArn The ARN of the SNS topic for the notifications.
 * @property vpcEndpointId The ID of the VPC Endpoint to receive notifications for.
 * @property vpcEndpointServiceId The ID of the VPC Endpoint Service to receive notifications for.
 */
public data class VpcEndpointConnectionNotificationArgs(
    public val connectionEvents: Output<List<String>>? = null,
    public val connectionNotificationArn: Output<String>? = null,
    public val vpcEndpointId: Output<String>? = null,
    public val vpcEndpointServiceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcEndpointConnectionNotificationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcEndpointConnectionNotificationArgs =
        com.pulumi.aws.ec2.VpcEndpointConnectionNotificationArgs.builder()
            .connectionEvents(connectionEvents?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectionNotificationArn(connectionNotificationArn?.applyValue({ args0 -> args0 }))
            .vpcEndpointId(vpcEndpointId?.applyValue({ args0 -> args0 }))
            .vpcEndpointServiceId(vpcEndpointServiceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcEndpointConnectionNotificationArgs].
 */
@PulumiTagMarker
public class VpcEndpointConnectionNotificationArgsBuilder internal constructor() {
    private var connectionEvents: Output<List<String>>? = null

    private var connectionNotificationArn: Output<String>? = null

    private var vpcEndpointId: Output<String>? = null

    private var vpcEndpointServiceId: Output<String>? = null

    /**
     * @param value One or more endpoint [events](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointConnectionNotification.html#API_CreateVpcEndpointConnectionNotification_RequestParameters) for which to receive notifications.
     * > **NOTE:** One of `vpc_endpoint_service_id` or `vpc_endpoint_id` must be specified.
     */
    @JvmName("uwewrrlbnyixostd")
    public suspend fun connectionEvents(`value`: Output<List<String>>) {
        this.connectionEvents = value
    }

    @JvmName("xbnesdvkeaicrbub")
    public suspend fun connectionEvents(vararg values: Output<String>) {
        this.connectionEvents = Output.all(values.asList())
    }

    /**
     * @param values One or more endpoint [events](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointConnectionNotification.html#API_CreateVpcEndpointConnectionNotification_RequestParameters) for which to receive notifications.
     * > **NOTE:** One of `vpc_endpoint_service_id` or `vpc_endpoint_id` must be specified.
     */
    @JvmName("emyuxmjhtttqhyqt")
    public suspend fun connectionEvents(values: List<Output<String>>) {
        this.connectionEvents = Output.all(values)
    }

    /**
     * @param value The ARN of the SNS topic for the notifications.
     */
    @JvmName("oytjwgrmslvnfgdo")
    public suspend fun connectionNotificationArn(`value`: Output<String>) {
        this.connectionNotificationArn = value
    }

    /**
     * @param value The ID of the VPC Endpoint to receive notifications for.
     */
    @JvmName("hqnwaqnjsuunexps")
    public suspend fun vpcEndpointId(`value`: Output<String>) {
        this.vpcEndpointId = value
    }

    /**
     * @param value The ID of the VPC Endpoint Service to receive notifications for.
     */
    @JvmName("ruljgxxrnpcmtgsa")
    public suspend fun vpcEndpointServiceId(`value`: Output<String>) {
        this.vpcEndpointServiceId = value
    }

    /**
     * @param value One or more endpoint [events](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointConnectionNotification.html#API_CreateVpcEndpointConnectionNotification_RequestParameters) for which to receive notifications.
     * > **NOTE:** One of `vpc_endpoint_service_id` or `vpc_endpoint_id` must be specified.
     */
    @JvmName("xxrgwlwhbhfreqon")
    public suspend fun connectionEvents(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionEvents = mapped
    }

    /**
     * @param values One or more endpoint [events](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointConnectionNotification.html#API_CreateVpcEndpointConnectionNotification_RequestParameters) for which to receive notifications.
     * > **NOTE:** One of `vpc_endpoint_service_id` or `vpc_endpoint_id` must be specified.
     */
    @JvmName("vhdhqawkkqwthnxk")
    public suspend fun connectionEvents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionEvents = mapped
    }

    /**
     * @param value The ARN of the SNS topic for the notifications.
     */
    @JvmName("tepgvhxfuwtrdwxa")
    public suspend fun connectionNotificationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionNotificationArn = mapped
    }

    /**
     * @param value The ID of the VPC Endpoint to receive notifications for.
     */
    @JvmName("amurepwrgmkduajb")
    public suspend fun vpcEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointId = mapped
    }

    /**
     * @param value The ID of the VPC Endpoint Service to receive notifications for.
     */
    @JvmName("ufslsodhquporbmt")
    public suspend fun vpcEndpointServiceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointServiceId = mapped
    }

    internal fun build(): VpcEndpointConnectionNotificationArgs =
        VpcEndpointConnectionNotificationArgs(
            connectionEvents = connectionEvents,
            connectionNotificationArn = connectionNotificationArn,
            vpcEndpointId = vpcEndpointId,
            vpcEndpointServiceId = vpcEndpointServiceId,
        )
}
