@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcEndpointPolicy].
 */
@PulumiTagMarker
public class VpcEndpointPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcEndpointPolicyArgs = VpcEndpointPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcEndpointPolicyArgsBuilder.() -> Unit) {
        val builder = VpcEndpointPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcEndpointPolicy {
        val builtJavaResource = com.pulumi.aws.ec2.VpcEndpointPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcEndpointPolicy(builtJavaResource)
    }
}

/**
 * Provides a VPC Endpoint Policy resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ec2.getVpcEndpointService({
 *     service: "dynamodb",
 * });
 * const exampleVpc = new aws.ec2.Vpc("example", {cidrBlock: "10.0.0.0/16"});
 * const exampleVpcEndpoint = new aws.ec2.VpcEndpoint("example", {
 *     serviceName: example.then(example => example.serviceName),
 *     vpcId: exampleVpc.id,
 * });
 * const exampleVpcEndpointPolicy = new aws.ec2.VpcEndpointPolicy("example", {
 *     vpcEndpointId: exampleVpcEndpoint.id,
 *     policy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Sid: "AllowAll",
 *             Effect: "Allow",
 *             Principal: {
 *                 AWS: "*",
 *             },
 *             Action: ["dynamodb:*"],
 *             Resource: "*",
 *         }],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.ec2.get_vpc_endpoint_service(service="dynamodb")
 * example_vpc = aws.ec2.Vpc("example", cidr_block="10.0.0.0/16")
 * example_vpc_endpoint = aws.ec2.VpcEndpoint("example",
 *     service_name=example.service_name,
 *     vpc_id=example_vpc.id)
 * example_vpc_endpoint_policy = aws.ec2.VpcEndpointPolicy("example",
 *     vpc_endpoint_id=example_vpc_endpoint.id,
 *     policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Sid": "AllowAll",
 *             "Effect": "Allow",
 *             "Principal": {
 *                 "AWS": "*",
 *             },
 *             "Action": ["dynamodb:*"],
 *             "Resource": "*",
 *         }],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.Ec2.GetVpcEndpointService.Invoke(new()
 *     {
 *         Service = "dynamodb",
 *     });
 *     var exampleVpc = new Aws.Ec2.Vpc("example", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var exampleVpcEndpoint = new Aws.Ec2.VpcEndpoint("example", new()
 *     {
 *         ServiceName = example.Apply(getVpcEndpointServiceResult => getVpcEndpointServiceResult.ServiceName),
 *         VpcId = exampleVpc.Id,
 *     });
 *     var exampleVpcEndpointPolicy = new Aws.Ec2.VpcEndpointPolicy("example", new()
 *     {
 *         VpcEndpointId = exampleVpcEndpoint.Id,
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "AllowAll",
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["AWS"] = "*",
 *                     },
 *                     ["Action"] = new[]
 *                     {
 *                         "dynamodb:*",
 *                     },
 *                     ["Resource"] = "*",
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.LookupVpcEndpointService(ctx, &ec2.LookupVpcEndpointServiceArgs{
 * 			Service: pulumi.StringRef("dynamodb"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpc, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpcEndpoint, err := ec2.NewVpcEndpoint(ctx, "example", &ec2.VpcEndpointArgs{
 * 			ServiceName: pulumi.String(example.ServiceName),
 * 			VpcId:       exampleVpc.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Sid":    "AllowAll",
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"AWS": "*",
 * 					},
 * 					"Action": []string{
 * 						"dynamodb:*",
 * 					},
 * 					"Resource": "*",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = ec2.NewVpcEndpointPolicy(ctx, "example", &ec2.VpcEndpointPolicyArgs{
 * 			VpcEndpointId: exampleVpcEndpoint.ID(),
 * 			Policy:        pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetVpcEndpointServiceArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import com.pulumi.aws.ec2.VpcEndpointPolicy;
 * import com.pulumi.aws.ec2.VpcEndpointPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = Ec2Functions.getVpcEndpointService(GetVpcEndpointServiceArgs.builder()
 *             .service("dynamodb")
 *             .build());
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var exampleVpcEndpoint = new VpcEndpoint("exampleVpcEndpoint", VpcEndpointArgs.builder()
 *             .serviceName(example.applyValue(getVpcEndpointServiceResult -> getVpcEndpointServiceResult.serviceName()))
 *             .vpcId(exampleVpc.id())
 *             .build());
 *         var exampleVpcEndpointPolicy = new VpcEndpointPolicy("exampleVpcEndpointPolicy", VpcEndpointPolicyArgs.builder()
 *             .vpcEndpointId(exampleVpcEndpoint.id())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", "AllowAll"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", "*")
 *                         )),
 *                         jsonProperty("Action", jsonArray("dynamodb:*")),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleVpc:
 *     type: aws:ec2:Vpc
 *     name: example
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *   exampleVpcEndpoint:
 *     type: aws:ec2:VpcEndpoint
 *     name: example
 *     properties:
 *       serviceName: ${example.serviceName}
 *       vpcId: ${exampleVpc.id}
 *   exampleVpcEndpointPolicy:
 *     type: aws:ec2:VpcEndpointPolicy
 *     name: example
 *     properties:
 *       vpcEndpointId: ${exampleVpcEndpoint.id}
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Sid: AllowAll
 *               Effect: Allow
 *               Principal:
 *                 AWS: '*'
 *               Action:
 *                 - dynamodb:*
 *               Resource: '*'
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ec2:getVpcEndpointService
 *       Arguments:
 *         service: dynamodb
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Endpoint Policies using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcEndpointPolicy:VpcEndpointPolicy example vpce-3ecf2a57
 * ```
 */
public class VpcEndpointPolicy internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcEndpointPolicy,
) : KotlinCustomResource(javaResource, VpcEndpointPolicyMapper) {
    /**
     * A policy to attach to the endpoint that controls access to the service. Defaults to full access. All `Gateway` and some `Interface` endpoints support policies - see the [relevant AWS documentation](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-access.html) for more details.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The VPC Endpoint ID.
     */
    public val vpcEndpointId: Output<String>
        get() = javaResource.vpcEndpointId().applyValue({ args0 -> args0 })
}

public object VpcEndpointPolicyMapper : ResourceMapper<VpcEndpointPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcEndpointPolicy::class == javaResource::class

    override fun map(javaResource: Resource): VpcEndpointPolicy = VpcEndpointPolicy(
        javaResource as
            com.pulumi.aws.ec2.VpcEndpointPolicy,
    )
}

/**
 * @see [VpcEndpointPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcEndpointPolicy].
 */
public suspend fun vpcEndpointPolicy(
    name: String,
    block: suspend VpcEndpointPolicyResourceBuilder.() -> Unit,
): VpcEndpointPolicy {
    val builder = VpcEndpointPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcEndpointPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcEndpointPolicy(name: String): VpcEndpointPolicy {
    val builder = VpcEndpointPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
