@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcEndpointRouteTableAssociation].
 */
@PulumiTagMarker
public class VpcEndpointRouteTableAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcEndpointRouteTableAssociationArgs = VpcEndpointRouteTableAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcEndpointRouteTableAssociationArgsBuilder.() -> Unit) {
        val builder = VpcEndpointRouteTableAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcEndpointRouteTableAssociation {
        val builtJavaResource =
            com.pulumi.aws.ec2.VpcEndpointRouteTableAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VpcEndpointRouteTableAssociation(builtJavaResource)
    }
}

/**
 * Manages a VPC Endpoint Route Table Association
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.VpcEndpointRouteTableAssociation("example", {
 *     routeTableId: exampleAwsRouteTable.id,
 *     vpcEndpointId: exampleAwsVpcEndpoint.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.VpcEndpointRouteTableAssociation("example",
 *     route_table_id=example_aws_route_table["id"],
 *     vpc_endpoint_id=example_aws_vpc_endpoint["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.VpcEndpointRouteTableAssociation("example", new()
 *     {
 *         RouteTableId = exampleAwsRouteTable.Id,
 *         VpcEndpointId = exampleAwsVpcEndpoint.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcEndpointRouteTableAssociation(ctx, "example", &ec2.VpcEndpointRouteTableAssociationArgs{
 * 			RouteTableId:  pulumi.Any(exampleAwsRouteTable.Id),
 * 			VpcEndpointId: pulumi.Any(exampleAwsVpcEndpoint.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpointRouteTableAssociation;
 * import com.pulumi.aws.ec2.VpcEndpointRouteTableAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcEndpointRouteTableAssociation("example", VpcEndpointRouteTableAssociationArgs.builder()
 *             .routeTableId(exampleAwsRouteTable.id())
 *             .vpcEndpointId(exampleAwsVpcEndpoint.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:VpcEndpointRouteTableAssociation
 *     properties:
 *       routeTableId: ${exampleAwsRouteTable.id}
 *       vpcEndpointId: ${exampleAwsVpcEndpoint.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Endpoint Route Table Associations using `vpc_endpoint_id` together with `route_table_id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcEndpointRouteTableAssociation:VpcEndpointRouteTableAssociation example vpce-aaaaaaaa/rtb-bbbbbbbb
 * ```
 */
public class VpcEndpointRouteTableAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcEndpointRouteTableAssociation,
) : KotlinCustomResource(javaResource, VpcEndpointRouteTableAssociationMapper) {
    /**
     * Identifier of the EC2 Route Table to be associated with the VPC Endpoint.
     */
    public val routeTableId: Output<String>
        get() = javaResource.routeTableId().applyValue({ args0 -> args0 })

    /**
     * Identifier of the VPC Endpoint with which the EC2 Route Table will be associated.
     */
    public val vpcEndpointId: Output<String>
        get() = javaResource.vpcEndpointId().applyValue({ args0 -> args0 })
}

public object VpcEndpointRouteTableAssociationMapper :
    ResourceMapper<VpcEndpointRouteTableAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcEndpointRouteTableAssociation::class == javaResource::class

    override fun map(javaResource: Resource): VpcEndpointRouteTableAssociation =
        VpcEndpointRouteTableAssociation(
            javaResource as
                com.pulumi.aws.ec2.VpcEndpointRouteTableAssociation,
        )
}

/**
 * @see [VpcEndpointRouteTableAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcEndpointRouteTableAssociation].
 */
public suspend fun vpcEndpointRouteTableAssociation(
    name: String,
    block: suspend VpcEndpointRouteTableAssociationResourceBuilder.() -> Unit,
): VpcEndpointRouteTableAssociation {
    val builder = VpcEndpointRouteTableAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcEndpointRouteTableAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcEndpointRouteTableAssociation(name: String): VpcEndpointRouteTableAssociation {
    val builder = VpcEndpointRouteTableAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
