@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcEndpointRouteTableAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a VPC Endpoint Route Table Association
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.VpcEndpointRouteTableAssociation("example", {
 *     routeTableId: exampleAwsRouteTable.id,
 *     vpcEndpointId: exampleAwsVpcEndpoint.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.VpcEndpointRouteTableAssociation("example",
 *     route_table_id=example_aws_route_table["id"],
 *     vpc_endpoint_id=example_aws_vpc_endpoint["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.VpcEndpointRouteTableAssociation("example", new()
 *     {
 *         RouteTableId = exampleAwsRouteTable.Id,
 *         VpcEndpointId = exampleAwsVpcEndpoint.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcEndpointRouteTableAssociation(ctx, "example", &ec2.VpcEndpointRouteTableAssociationArgs{
 * 			RouteTableId:  pulumi.Any(exampleAwsRouteTable.Id),
 * 			VpcEndpointId: pulumi.Any(exampleAwsVpcEndpoint.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpointRouteTableAssociation;
 * import com.pulumi.aws.ec2.VpcEndpointRouteTableAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcEndpointRouteTableAssociation("example", VpcEndpointRouteTableAssociationArgs.builder()
 *             .routeTableId(exampleAwsRouteTable.id())
 *             .vpcEndpointId(exampleAwsVpcEndpoint.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:VpcEndpointRouteTableAssociation
 *     properties:
 *       routeTableId: ${exampleAwsRouteTable.id}
 *       vpcEndpointId: ${exampleAwsVpcEndpoint.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Endpoint Route Table Associations using `vpc_endpoint_id` together with `route_table_id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcEndpointRouteTableAssociation:VpcEndpointRouteTableAssociation example vpce-aaaaaaaa/rtb-bbbbbbbb
 * ```
 * @property routeTableId Identifier of the EC2 Route Table to be associated with the VPC Endpoint.
 * @property vpcEndpointId Identifier of the VPC Endpoint with which the EC2 Route Table will be associated.
 */
public data class VpcEndpointRouteTableAssociationArgs(
    public val routeTableId: Output<String>? = null,
    public val vpcEndpointId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcEndpointRouteTableAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcEndpointRouteTableAssociationArgs =
        com.pulumi.aws.ec2.VpcEndpointRouteTableAssociationArgs.builder()
            .routeTableId(routeTableId?.applyValue({ args0 -> args0 }))
            .vpcEndpointId(vpcEndpointId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcEndpointRouteTableAssociationArgs].
 */
@PulumiTagMarker
public class VpcEndpointRouteTableAssociationArgsBuilder internal constructor() {
    private var routeTableId: Output<String>? = null

    private var vpcEndpointId: Output<String>? = null

    /**
     * @param value Identifier of the EC2 Route Table to be associated with the VPC Endpoint.
     */
    @JvmName("baovykdajspayffp")
    public suspend fun routeTableId(`value`: Output<String>) {
        this.routeTableId = value
    }

    /**
     * @param value Identifier of the VPC Endpoint with which the EC2 Route Table will be associated.
     */
    @JvmName("kqfptxoevjwifijc")
    public suspend fun vpcEndpointId(`value`: Output<String>) {
        this.vpcEndpointId = value
    }

    /**
     * @param value Identifier of the EC2 Route Table to be associated with the VPC Endpoint.
     */
    @JvmName("jowimgbwpfceshfr")
    public suspend fun routeTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableId = mapped
    }

    /**
     * @param value Identifier of the VPC Endpoint with which the EC2 Route Table will be associated.
     */
    @JvmName("xcgtfkeshbtdjwcs")
    public suspend fun vpcEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointId = mapped
    }

    internal fun build(): VpcEndpointRouteTableAssociationArgs = VpcEndpointRouteTableAssociationArgs(
        routeTableId = routeTableId,
        vpcEndpointId = vpcEndpointId,
    )
}
