@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcEndpointServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC Endpoint Service resource.
 * Service consumers can create an _Interface_ VPC Endpoint to connect to the service.
 * > **NOTE on VPC Endpoint Services and VPC Endpoint Service Allowed Principals:** This provider provides
 * both a standalone VPC Endpoint Service Allowed Principal resource
 * and a VPC Endpoint Service resource with an `allowed_principals` attribute. Do not use the same principal ARN in both
 * a VPC Endpoint Service resource and a VPC Endpoint Service Allowed Principal resource. Doing so will cause a conflict
 * and will overwrite the association.
 * ## Example Usage
 * ### Network Load Balancers
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.VpcEndpointService("example", {
 *     acceptanceRequired: false,
 *     networkLoadBalancerArns: [exampleAwsLb&#46;arn],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.VpcEndpointService("example",
 *     acceptance_required=False,
 *     network_load_balancer_arns=[example_aws_lb["arn"]])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.VpcEndpointService("example", new()
 *     {
 *         AcceptanceRequired = false,
 *         NetworkLoadBalancerArns = new[]
 *         {
 *             exampleAwsLb.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcEndpointService(ctx, "example", &ec2.VpcEndpointServiceArgs{
 * 			AcceptanceRequired: pulumi.Bool(false),
 * 			NetworkLoadBalancerArns: pulumi.StringArray{
 * 				exampleAwsLb.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpointService;
 * import com.pulumi.aws.ec2.VpcEndpointServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcEndpointService("example", VpcEndpointServiceArgs.builder()
 *             .acceptanceRequired(false)
 *             .networkLoadBalancerArns(exampleAwsLb.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:VpcEndpointService
 *     properties:
 *       acceptanceRequired: false
 *       networkLoadBalancerArns:
 *         - ${exampleAwsLb.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Gateway Load Balancers
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.VpcEndpointService("example", {
 *     acceptanceRequired: false,
 *     gatewayLoadBalancerArns: [exampleAwsLb&#46;arn],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.VpcEndpointService("example",
 *     acceptance_required=False,
 *     gateway_load_balancer_arns=[example_aws_lb["arn"]])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.VpcEndpointService("example", new()
 *     {
 *         AcceptanceRequired = false,
 *         GatewayLoadBalancerArns = new[]
 *         {
 *             exampleAwsLb.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcEndpointService(ctx, "example", &ec2.VpcEndpointServiceArgs{
 * 			AcceptanceRequired: pulumi.Bool(false),
 * 			GatewayLoadBalancerArns: pulumi.StringArray{
 * 				exampleAwsLb.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpointService;
 * import com.pulumi.aws.ec2.VpcEndpointServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcEndpointService("example", VpcEndpointServiceArgs.builder()
 *             .acceptanceRequired(false)
 *             .gatewayLoadBalancerArns(exampleAwsLb.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:VpcEndpointService
 *     properties:
 *       acceptanceRequired: false
 *       gatewayLoadBalancerArns:
 *         - ${exampleAwsLb.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Endpoint Services using the VPC endpoint service `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcEndpointService:VpcEndpointService foo vpce-svc-0f97a19d3fa8220bc
 * ```
 * @property acceptanceRequired Whether or not VPC endpoint connection requests to the service must be accepted by the service owner - `true` or `false`.
 * @property allowedPrincipals The ARNs of one or more principals allowed to discover the endpoint service.
 * @property gatewayLoadBalancerArns Amazon Resource Names (ARNs) of one or more Gateway Load Balancers for the endpoint service.
 * @property networkLoadBalancerArns Amazon Resource Names (ARNs) of one or more Network Load Balancers for the endpoint service.
 * @property privateDnsName The private DNS name for the service.
 * @property supportedIpAddressTypes The supported IP address types. The possible values are `ipv4` and `ipv6`.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VpcEndpointServiceArgs(
    public val acceptanceRequired: Output<Boolean>? = null,
    public val allowedPrincipals: Output<List<String>>? = null,
    public val gatewayLoadBalancerArns: Output<List<String>>? = null,
    public val networkLoadBalancerArns: Output<List<String>>? = null,
    public val privateDnsName: Output<String>? = null,
    public val supportedIpAddressTypes: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcEndpointServiceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcEndpointServiceArgs =
        com.pulumi.aws.ec2.VpcEndpointServiceArgs.builder()
            .acceptanceRequired(acceptanceRequired?.applyValue({ args0 -> args0 }))
            .allowedPrincipals(allowedPrincipals?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .gatewayLoadBalancerArns(
                gatewayLoadBalancerArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .networkLoadBalancerArns(
                networkLoadBalancerArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .privateDnsName(privateDnsName?.applyValue({ args0 -> args0 }))
            .supportedIpAddressTypes(
                supportedIpAddressTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VpcEndpointServiceArgs].
 */
@PulumiTagMarker
public class VpcEndpointServiceArgsBuilder internal constructor() {
    private var acceptanceRequired: Output<Boolean>? = null

    private var allowedPrincipals: Output<List<String>>? = null

    private var gatewayLoadBalancerArns: Output<List<String>>? = null

    private var networkLoadBalancerArns: Output<List<String>>? = null

    private var privateDnsName: Output<String>? = null

    private var supportedIpAddressTypes: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Whether or not VPC endpoint connection requests to the service must be accepted by the service owner - `true` or `false`.
     */
    @JvmName("ulfadkremibauxrq")
    public suspend fun acceptanceRequired(`value`: Output<Boolean>) {
        this.acceptanceRequired = value
    }

    /**
     * @param value The ARNs of one or more principals allowed to discover the endpoint service.
     */
    @JvmName("ajfekfsdqygqvgqh")
    public suspend fun allowedPrincipals(`value`: Output<List<String>>) {
        this.allowedPrincipals = value
    }

    @JvmName("eqoxuvspdrtkvnfm")
    public suspend fun allowedPrincipals(vararg values: Output<String>) {
        this.allowedPrincipals = Output.all(values.asList())
    }

    /**
     * @param values The ARNs of one or more principals allowed to discover the endpoint service.
     */
    @JvmName("orxcybsaijmnscvu")
    public suspend fun allowedPrincipals(values: List<Output<String>>) {
        this.allowedPrincipals = Output.all(values)
    }

    /**
     * @param value Amazon Resource Names (ARNs) of one or more Gateway Load Balancers for the endpoint service.
     */
    @JvmName("qgxsowrtxiogwlbo")
    public suspend fun gatewayLoadBalancerArns(`value`: Output<List<String>>) {
        this.gatewayLoadBalancerArns = value
    }

    @JvmName("msoqxsklnnfmalbi")
    public suspend fun gatewayLoadBalancerArns(vararg values: Output<String>) {
        this.gatewayLoadBalancerArns = Output.all(values.asList())
    }

    /**
     * @param values Amazon Resource Names (ARNs) of one or more Gateway Load Balancers for the endpoint service.
     */
    @JvmName("uiptkyshjodqbiln")
    public suspend fun gatewayLoadBalancerArns(values: List<Output<String>>) {
        this.gatewayLoadBalancerArns = Output.all(values)
    }

    /**
     * @param value Amazon Resource Names (ARNs) of one or more Network Load Balancers for the endpoint service.
     */
    @JvmName("tdiehsjreauwkadd")
    public suspend fun networkLoadBalancerArns(`value`: Output<List<String>>) {
        this.networkLoadBalancerArns = value
    }

    @JvmName("uqdvfrqrtnvfpsww")
    public suspend fun networkLoadBalancerArns(vararg values: Output<String>) {
        this.networkLoadBalancerArns = Output.all(values.asList())
    }

    /**
     * @param values Amazon Resource Names (ARNs) of one or more Network Load Balancers for the endpoint service.
     */
    @JvmName("bjgiradxanfcdest")
    public suspend fun networkLoadBalancerArns(values: List<Output<String>>) {
        this.networkLoadBalancerArns = Output.all(values)
    }

    /**
     * @param value The private DNS name for the service.
     */
    @JvmName("mbktqqufneebbmhi")
    public suspend fun privateDnsName(`value`: Output<String>) {
        this.privateDnsName = value
    }

    /**
     * @param value The supported IP address types. The possible values are `ipv4` and `ipv6`.
     */
    @JvmName("sdyjervnwnmyiwns")
    public suspend fun supportedIpAddressTypes(`value`: Output<List<String>>) {
        this.supportedIpAddressTypes = value
    }

    @JvmName("imvpiwnrivcoaqeu")
    public suspend fun supportedIpAddressTypes(vararg values: Output<String>) {
        this.supportedIpAddressTypes = Output.all(values.asList())
    }

    /**
     * @param values The supported IP address types. The possible values are `ipv4` and `ipv6`.
     */
    @JvmName("knrfbyarrilfdoib")
    public suspend fun supportedIpAddressTypes(values: List<Output<String>>) {
        this.supportedIpAddressTypes = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qdvxcwlfghgmkbif")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether or not VPC endpoint connection requests to the service must be accepted by the service owner - `true` or `false`.
     */
    @JvmName("liadpbjbvosjjpta")
    public suspend fun acceptanceRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptanceRequired = mapped
    }

    /**
     * @param value The ARNs of one or more principals allowed to discover the endpoint service.
     */
    @JvmName("nwtcjqupjodgbglo")
    public suspend fun allowedPrincipals(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedPrincipals = mapped
    }

    /**
     * @param values The ARNs of one or more principals allowed to discover the endpoint service.
     */
    @JvmName("okbilqmwnkomliyq")
    public suspend fun allowedPrincipals(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedPrincipals = mapped
    }

    /**
     * @param value Amazon Resource Names (ARNs) of one or more Gateway Load Balancers for the endpoint service.
     */
    @JvmName("snlnvaftesvqsikc")
    public suspend fun gatewayLoadBalancerArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayLoadBalancerArns = mapped
    }

    /**
     * @param values Amazon Resource Names (ARNs) of one or more Gateway Load Balancers for the endpoint service.
     */
    @JvmName("gttegyenhtrkqgxn")
    public suspend fun gatewayLoadBalancerArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gatewayLoadBalancerArns = mapped
    }

    /**
     * @param value Amazon Resource Names (ARNs) of one or more Network Load Balancers for the endpoint service.
     */
    @JvmName("myjiquwmuhpurpcw")
    public suspend fun networkLoadBalancerArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkLoadBalancerArns = mapped
    }

    /**
     * @param values Amazon Resource Names (ARNs) of one or more Network Load Balancers for the endpoint service.
     */
    @JvmName("nxkgavawyaiudkmu")
    public suspend fun networkLoadBalancerArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkLoadBalancerArns = mapped
    }

    /**
     * @param value The private DNS name for the service.
     */
    @JvmName("edxcxapmiaajvqvg")
    public suspend fun privateDnsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateDnsName = mapped
    }

    /**
     * @param value The supported IP address types. The possible values are `ipv4` and `ipv6`.
     */
    @JvmName("gswgpfuawqeqiehs")
    public suspend fun supportedIpAddressTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportedIpAddressTypes = mapped
    }

    /**
     * @param values The supported IP address types. The possible values are `ipv4` and `ipv6`.
     */
    @JvmName("pwyytcactmxkweum")
    public suspend fun supportedIpAddressTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportedIpAddressTypes = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ugvxsskdunndelaf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kwntvtskphwbqafl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VpcEndpointServiceArgs = VpcEndpointServiceArgs(
        acceptanceRequired = acceptanceRequired,
        allowedPrincipals = allowedPrincipals,
        gatewayLoadBalancerArns = gatewayLoadBalancerArns,
        networkLoadBalancerArns = networkLoadBalancerArns,
        privateDnsName = privateDnsName,
        supportedIpAddressTypes = supportedIpAddressTypes,
        tags = tags,
    )
}
