@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcEndpointSubnetAssociation].
 */
@PulumiTagMarker
public class VpcEndpointSubnetAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcEndpointSubnetAssociationArgs = VpcEndpointSubnetAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcEndpointSubnetAssociationArgsBuilder.() -> Unit) {
        val builder = VpcEndpointSubnetAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcEndpointSubnetAssociation {
        val builtJavaResource = com.pulumi.aws.ec2.VpcEndpointSubnetAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcEndpointSubnetAssociation(builtJavaResource)
    }
}

/**
 * Provides a resource to create an association between a VPC endpoint and a subnet.
 * > **NOTE on VPC Endpoints and VPC Endpoint Subnet Associations:** This provider provides
 * both a standalone VPC Endpoint Subnet Association (an association between a VPC endpoint
 * and a single `subnet_id`) and a VPC Endpoint resource with a `subnet_ids`
 * attribute. Do not use the same subnet ID in both a VPC Endpoint resource and a VPC Endpoint Subnet
 * Association resource. Doing so will cause a conflict of associations and will overwrite the association.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const snEc2 = new aws.ec2.VpcEndpointSubnetAssociation("sn_ec2", {
 *     vpcEndpointId: ec2.id,
 *     subnetId: sn.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * sn_ec2 = aws.ec2.VpcEndpointSubnetAssociation("sn_ec2",
 *     vpc_endpoint_id=ec2["id"],
 *     subnet_id=sn["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snEc2 = new Aws.Ec2.VpcEndpointSubnetAssociation("sn_ec2", new()
 *     {
 *         VpcEndpointId = ec2.Id,
 *         SubnetId = sn.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcEndpointSubnetAssociation(ctx, "sn_ec2", &ec2.VpcEndpointSubnetAssociationArgs{
 * 			VpcEndpointId: pulumi.Any(ec2.Id),
 * 			SubnetId:      pulumi.Any(sn.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpointSubnetAssociation;
 * import com.pulumi.aws.ec2.VpcEndpointSubnetAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snEc2 = new VpcEndpointSubnetAssociation("snEc2", VpcEndpointSubnetAssociationArgs.builder()
 *             .vpcEndpointId(ec2.id())
 *             .subnetId(sn.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   snEc2:
 *     type: aws:ec2:VpcEndpointSubnetAssociation
 *     name: sn_ec2
 *     properties:
 *       vpcEndpointId: ${ec2.id}
 *       subnetId: ${sn.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Endpoint Subnet Associations using `vpc_endpoint_id` together with `subnet_id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcEndpointSubnetAssociation:VpcEndpointSubnetAssociation example vpce-aaaaaaaa/subnet-bbbbbbbbbbbbbbbbb
 * ```
 */
public class VpcEndpointSubnetAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcEndpointSubnetAssociation,
) : KotlinCustomResource(javaResource, VpcEndpointSubnetAssociationMapper) {
    /**
     * The ID of the subnet to be associated with the VPC endpoint.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC endpoint with which the subnet will be associated.
     */
    public val vpcEndpointId: Output<String>
        get() = javaResource.vpcEndpointId().applyValue({ args0 -> args0 })
}

public object VpcEndpointSubnetAssociationMapper : ResourceMapper<VpcEndpointSubnetAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcEndpointSubnetAssociation::class == javaResource::class

    override fun map(javaResource: Resource): VpcEndpointSubnetAssociation =
        VpcEndpointSubnetAssociation(javaResource as com.pulumi.aws.ec2.VpcEndpointSubnetAssociation)
}

/**
 * @see [VpcEndpointSubnetAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcEndpointSubnetAssociation].
 */
public suspend fun vpcEndpointSubnetAssociation(
    name: String,
    block: suspend VpcEndpointSubnetAssociationResourceBuilder.() -> Unit,
): VpcEndpointSubnetAssociation {
    val builder = VpcEndpointSubnetAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcEndpointSubnetAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcEndpointSubnetAssociation(name: String): VpcEndpointSubnetAssociation {
    val builder = VpcEndpointSubnetAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
