@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcEndpointSubnetAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to create an association between a VPC endpoint and a subnet.
 * > **NOTE on VPC Endpoints and VPC Endpoint Subnet Associations:** This provider provides
 * both a standalone VPC Endpoint Subnet Association (an association between a VPC endpoint
 * and a single `subnet_id`) and a VPC Endpoint resource with a `subnet_ids`
 * attribute. Do not use the same subnet ID in both a VPC Endpoint resource and a VPC Endpoint Subnet
 * Association resource. Doing so will cause a conflict of associations and will overwrite the association.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const snEc2 = new aws.ec2.VpcEndpointSubnetAssociation("sn_ec2", {
 *     vpcEndpointId: ec2.id,
 *     subnetId: sn.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * sn_ec2 = aws.ec2.VpcEndpointSubnetAssociation("sn_ec2",
 *     vpc_endpoint_id=ec2["id"],
 *     subnet_id=sn["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snEc2 = new Aws.Ec2.VpcEndpointSubnetAssociation("sn_ec2", new()
 *     {
 *         VpcEndpointId = ec2.Id,
 *         SubnetId = sn.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcEndpointSubnetAssociation(ctx, "sn_ec2", &ec2.VpcEndpointSubnetAssociationArgs{
 * 			VpcEndpointId: pulumi.Any(ec2.Id),
 * 			SubnetId:      pulumi.Any(sn.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpointSubnetAssociation;
 * import com.pulumi.aws.ec2.VpcEndpointSubnetAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snEc2 = new VpcEndpointSubnetAssociation("snEc2", VpcEndpointSubnetAssociationArgs.builder()
 *             .vpcEndpointId(ec2.id())
 *             .subnetId(sn.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   snEc2:
 *     type: aws:ec2:VpcEndpointSubnetAssociation
 *     name: sn_ec2
 *     properties:
 *       vpcEndpointId: ${ec2.id}
 *       subnetId: ${sn.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Endpoint Subnet Associations using `vpc_endpoint_id` together with `subnet_id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcEndpointSubnetAssociation:VpcEndpointSubnetAssociation example vpce-aaaaaaaa/subnet-bbbbbbbbbbbbbbbbb
 * ```
 * @property subnetId The ID of the subnet to be associated with the VPC endpoint.
 * @property vpcEndpointId The ID of the VPC endpoint with which the subnet will be associated.
 */
public data class VpcEndpointSubnetAssociationArgs(
    public val subnetId: Output<String>? = null,
    public val vpcEndpointId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcEndpointSubnetAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcEndpointSubnetAssociationArgs =
        com.pulumi.aws.ec2.VpcEndpointSubnetAssociationArgs.builder()
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .vpcEndpointId(vpcEndpointId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcEndpointSubnetAssociationArgs].
 */
@PulumiTagMarker
public class VpcEndpointSubnetAssociationArgsBuilder internal constructor() {
    private var subnetId: Output<String>? = null

    private var vpcEndpointId: Output<String>? = null

    /**
     * @param value The ID of the subnet to be associated with the VPC endpoint.
     */
    @JvmName("jlhxwypxqkfmklev")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The ID of the VPC endpoint with which the subnet will be associated.
     */
    @JvmName("wsughhreumldvvhl")
    public suspend fun vpcEndpointId(`value`: Output<String>) {
        this.vpcEndpointId = value
    }

    /**
     * @param value The ID of the subnet to be associated with the VPC endpoint.
     */
    @JvmName("bcegnjfhgcbyrinf")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value The ID of the VPC endpoint with which the subnet will be associated.
     */
    @JvmName("wneuuceqnrjpwcea")
    public suspend fun vpcEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointId = mapped
    }

    internal fun build(): VpcEndpointSubnetAssociationArgs = VpcEndpointSubnetAssociationArgs(
        subnetId = subnetId,
        vpcEndpointId = vpcEndpointId,
    )
}
