@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.VpcIpamOperatingRegion
import com.pulumi.aws.ec2.kotlin.outputs.VpcIpamOperatingRegion.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VpcIpam].
 */
@PulumiTagMarker
public class VpcIpamResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIpamArgs = VpcIpamArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIpamArgsBuilder.() -> Unit) {
        val builder = VpcIpamArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcIpam {
        val builtJavaResource = com.pulumi.aws.ec2.VpcIpam(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcIpam(builtJavaResource)
    }
}

/**
 * Provides an IPAM resource.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getRegion({});
 * const main = new aws.ec2.VpcIpam("main", {
 *     description: "My IPAM",
 *     operatingRegions: [{
 *         regionName: current.then(current => current.name),
 *     }],
 *     tags: {
 *         Test: "Main",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_region()
 * main = aws.ec2.VpcIpam("main",
 *     description="My IPAM",
 *     operating_regions=[{
 *         "region_name": current.name,
 *     }],
 *     tags={
 *         "Test": "Main",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetRegion.Invoke();
 *     var main = new Aws.Ec2.VpcIpam("main", new()
 *     {
 *         Description = "My IPAM",
 *         OperatingRegions = new[]
 *         {
 *             new Aws.Ec2.Inputs.VpcIpamOperatingRegionArgs
 *             {
 *                 RegionName = current.Apply(getRegionResult => getRegionResult.Name),
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Test", "Main" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpcIpam(ctx, "main", &ec2.VpcIpamArgs{
 * 			Description: pulumi.String("My IPAM"),
 * 			OperatingRegions: ec2.VpcIpamOperatingRegionArray{
 * 				&ec2.VpcIpamOperatingRegionArgs{
 * 					RegionName: pulumi.String(current.Name),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Test": pulumi.String("Main"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var main = new VpcIpam("main", VpcIpamArgs.builder()
 *             .description("My IPAM")
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .tags(Map.of("Test", "Main"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:ec2:VpcIpam
 *     properties:
 *       description: My IPAM
 *       operatingRegions:
 *         - regionName: ${current.name}
 *       tags:
 *         Test: Main
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * Shared with multiple operating_regions:
 * ## Import
 * Using `pulumi import`, import IPAMs using the IPAM `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcIpam:VpcIpam example ipam-0178368ad2146a492
 * ```
 */
public class VpcIpam internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcIpam,
) : KotlinCustomResource(javaResource, VpcIpamMapper) {
    /**
     * Amazon Resource Name (ARN) of IPAM
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Enables you to quickly delete an IPAM, private scopes, pools in private scopes, and any allocations in the pools in private scopes.
     */
    public val cascade: Output<Boolean>?
        get() = javaResource.cascade().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The IPAM's default resource discovery association ID.
     */
    public val defaultResourceDiscoveryAssociationId: Output<String>
        get() = javaResource.defaultResourceDiscoveryAssociationId().applyValue({ args0 -> args0 })

    /**
     * The IPAM's default resource discovery ID.
     */
    public val defaultResourceDiscoveryId: Output<String>
        get() = javaResource.defaultResourceDiscoveryId().applyValue({ args0 -> args0 })

    /**
     * A description for the IPAM.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    public val operatingRegions: Output<List<VpcIpamOperatingRegion>>
        get() = javaResource.operatingRegions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The ID of the IPAM's private scope. A scope is a top-level container in IPAM. Each scope represents an IP-independent network. Scopes enable you to represent networks where you have overlapping IP space. When you create an IPAM, IPAM automatically creates two scopes: public and private. The private scope is intended for private IP space. The public scope is intended for all internet-routable IP space.
     */
    public val privateDefaultScopeId: Output<String>
        get() = javaResource.privateDefaultScopeId().applyValue({ args0 -> args0 })

    /**
     * The ID of the IPAM's public scope. A scope is a top-level container in IPAM. Each scope represents an IP-independent network. Scopes enable you to represent networks where you have overlapping IP space. When you create an IPAM, IPAM automatically creates two scopes: public and private. The private scope is intended for private
     * IP space. The public scope is intended for all internet-routable IP space.
     */
    public val publicDefaultScopeId: Output<String>
        get() = javaResource.publicDefaultScopeId().applyValue({ args0 -> args0 })

    /**
     * The number of scopes in the IPAM.
     */
    public val scopeCount: Output<Int>
        get() = javaResource.scopeCount().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * specifies the IPAM tier. Valid options include `free` and `advanced`. Default is `advanced`.
     */
    public val tier: Output<String>?
        get() = javaResource.tier().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object VpcIpamMapper : ResourceMapper<VpcIpam> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcIpam::class == javaResource::class

    override fun map(javaResource: Resource): VpcIpam = VpcIpam(
        javaResource as
            com.pulumi.aws.ec2.VpcIpam,
    )
}

/**
 * @see [VpcIpam].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIpam].
 */
public suspend fun vpcIpam(name: String, block: suspend VpcIpamResourceBuilder.() -> Unit): VpcIpam {
    val builder = VpcIpamResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIpam].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIpam(name: String): VpcIpam {
    val builder = VpcIpamResourceBuilder()
    builder.name(name)
    return builder.build()
}
