@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcIpamArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.VpcIpamOperatingRegionArgs
import com.pulumi.aws.ec2.kotlin.inputs.VpcIpamOperatingRegionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an IPAM resource.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getRegion({});
 * const main = new aws.ec2.VpcIpam("main", {
 *     description: "My IPAM",
 *     operatingRegions: [{
 *         regionName: current.then(current => current.name),
 *     }],
 *     tags: {
 *         Test: "Main",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_region()
 * main = aws.ec2.VpcIpam("main",
 *     description="My IPAM",
 *     operating_regions=[{
 *         "region_name": current.name,
 *     }],
 *     tags={
 *         "Test": "Main",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetRegion.Invoke();
 *     var main = new Aws.Ec2.VpcIpam("main", new()
 *     {
 *         Description = "My IPAM",
 *         OperatingRegions = new[]
 *         {
 *             new Aws.Ec2.Inputs.VpcIpamOperatingRegionArgs
 *             {
 *                 RegionName = current.Apply(getRegionResult => getRegionResult.Name),
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Test", "Main" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpcIpam(ctx, "main", &ec2.VpcIpamArgs{
 * 			Description: pulumi.String("My IPAM"),
 * 			OperatingRegions: ec2.VpcIpamOperatingRegionArray{
 * 				&ec2.VpcIpamOperatingRegionArgs{
 * 					RegionName: pulumi.String(current.Name),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Test": pulumi.String("Main"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var main = new VpcIpam("main", VpcIpamArgs.builder()
 *             .description("My IPAM")
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .tags(Map.of("Test", "Main"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:ec2:VpcIpam
 *     properties:
 *       description: My IPAM
 *       operatingRegions:
 *         - regionName: ${current.name}
 *       tags:
 *         Test: Main
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * Shared with multiple operating_regions:
 * ## Import
 * Using `pulumi import`, import IPAMs using the IPAM `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcIpam:VpcIpam example ipam-0178368ad2146a492
 * ```
 * @property cascade Enables you to quickly delete an IPAM, private scopes, pools in private scopes, and any allocations in the pools in private scopes.
 * @property description A description for the IPAM.
 * @property operatingRegions Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tier specifies the IPAM tier. Valid options include `free` and `advanced`. Default is `advanced`.
 */
public data class VpcIpamArgs(
    public val cascade: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val operatingRegions: Output<List<VpcIpamOperatingRegionArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcIpamArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcIpamArgs = com.pulumi.aws.ec2.VpcIpamArgs.builder()
        .cascade(cascade?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .operatingRegions(
            operatingRegions?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcIpamArgs].
 */
@PulumiTagMarker
public class VpcIpamArgsBuilder internal constructor() {
    private var cascade: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var operatingRegions: Output<List<VpcIpamOperatingRegionArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tier: Output<String>? = null

    /**
     * @param value Enables you to quickly delete an IPAM, private scopes, pools in private scopes, and any allocations in the pools in private scopes.
     */
    @JvmName("iyqtylkpurmpswdl")
    public suspend fun cascade(`value`: Output<Boolean>) {
        this.cascade = value
    }

    /**
     * @param value A description for the IPAM.
     */
    @JvmName("upkmfnrcpbtvtocj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    @JvmName("sjbjvhkfmtscbjsp")
    public suspend fun operatingRegions(`value`: Output<List<VpcIpamOperatingRegionArgs>>) {
        this.operatingRegions = value
    }

    @JvmName("uovjeqqpdeewnvhg")
    public suspend fun operatingRegions(vararg values: Output<VpcIpamOperatingRegionArgs>) {
        this.operatingRegions = Output.all(values.asList())
    }

    /**
     * @param values Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    @JvmName("rclfurcqifvegadc")
    public suspend fun operatingRegions(values: List<Output<VpcIpamOperatingRegionArgs>>) {
        this.operatingRegions = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("grmpsjgqeircmmww")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value specifies the IPAM tier. Valid options include `free` and `advanced`. Default is `advanced`.
     */
    @JvmName("axpitvilhjwganuv")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value Enables you to quickly delete an IPAM, private scopes, pools in private scopes, and any allocations in the pools in private scopes.
     */
    @JvmName("ysgfbvbgxubdieot")
    public suspend fun cascade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cascade = mapped
    }

    /**
     * @param value A description for the IPAM.
     */
    @JvmName("ndhamdmusdxhnksc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    @JvmName("ojqrcgxcfldkuxbx")
    public suspend fun operatingRegions(`value`: List<VpcIpamOperatingRegionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatingRegions = mapped
    }

    /**
     * @param argument Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    @JvmName("ncujwyiycvuuosdd")
    public suspend fun operatingRegions(argument: List<suspend VpcIpamOperatingRegionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpcIpamOperatingRegionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.operatingRegions = mapped
    }

    /**
     * @param argument Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    @JvmName("bxideyrtbjxttkax")
    public suspend fun operatingRegions(vararg argument: suspend VpcIpamOperatingRegionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VpcIpamOperatingRegionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.operatingRegions = mapped
    }

    /**
     * @param argument Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    @JvmName("qlfyyxqikwaqwgod")
    public suspend fun operatingRegions(argument: suspend VpcIpamOperatingRegionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VpcIpamOperatingRegionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.operatingRegions = mapped
    }

    /**
     * @param values Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    @JvmName("rpxtqqoqovhmtjwv")
    public suspend fun operatingRegions(vararg values: VpcIpamOperatingRegionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatingRegions = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ndokgehnebgxwnrw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pwqqqjvndbqaxmfd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value specifies the IPAM tier. Valid options include `free` and `advanced`. Default is `advanced`.
     */
    @JvmName("eiovjwrchywlwrka")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): VpcIpamArgs = VpcIpamArgs(
        cascade = cascade,
        description = description,
        operatingRegions = operatingRegions,
        tags = tags,
        tier = tier,
    )
}
