@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.VpcIpamPoolCidrCidrAuthorizationContext
import com.pulumi.aws.ec2.kotlin.outputs.VpcIpamPoolCidrCidrAuthorizationContext.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcIpamPoolCidr].
 */
@PulumiTagMarker
public class VpcIpamPoolCidrResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIpamPoolCidrArgs = VpcIpamPoolCidrArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIpamPoolCidrArgsBuilder.() -> Unit) {
        val builder = VpcIpamPoolCidrArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcIpamPoolCidr {
        val builtJavaResource = com.pulumi.aws.ec2.VpcIpamPoolCidr(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcIpamPoolCidr(builtJavaResource)
    }
}

/**
 * Provisions a CIDR from an IPAM address pool.
 * > **NOTE:** Provisioning Public IPv4 or Public IPv6 require [steps outside the scope of this resource](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#prepare-for-byoip). The resource accepts `message` and `signature` as part of the `cidr_authorization_context` attribute but those must be generated ahead of time. Public IPv6 CIDRs that are provisioned into a Pool with `publicly_advertisable = true` and all public IPv4 CIDRs also require creating a Route Origin Authorization (ROA) object in your Regional Internet Registry (RIR).
 * > **NOTE:** In order to deprovision CIDRs all Allocations must be released. Allocations created by a VPC take up to 30 minutes to be released. However, for IPAM to properly manage the removal of allocation records created by VPCs and other resources, you must [grant it permissions](https://docs.aws.amazon.com/vpc/latest/ipam/choose-single-user-or-orgs-ipam.html) in
 * either a single account or organizationally. If you are unable to deprovision a cidr after waiting over 30 minutes, you may be missing the Service Linked Role.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getRegion({});
 * const example = new aws.ec2.VpcIpam("example", {operatingRegions: [{
 *     regionName: current.then(current => current.name),
 * }]});
 * const exampleVpcIpamPool = new aws.ec2.VpcIpamPool("example", {
 *     addressFamily: "ipv4",
 *     ipamScopeId: example.privateDefaultScopeId,
 *     locale: current.then(current => current.name),
 * });
 * const exampleVpcIpamPoolCidr = new aws.ec2.VpcIpamPoolCidr("example", {
 *     ipamPoolId: exampleVpcIpamPool.id,
 *     cidr: "172.20.0.0/16",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_region()
 * example = aws.ec2.VpcIpam("example", operating_regions=[{
 *     "region_name": current.name,
 * }])
 * example_vpc_ipam_pool = aws.ec2.VpcIpamPool("example",
 *     address_family="ipv4",
 *     ipam_scope_id=example.private_default_scope_id,
 *     locale=current.name)
 * example_vpc_ipam_pool_cidr = aws.ec2.VpcIpamPoolCidr("example",
 *     ipam_pool_id=example_vpc_ipam_pool.id,
 *     cidr="172.20.0.0/16")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetRegion.Invoke();
 *     var example = new Aws.Ec2.VpcIpam("example", new()
 *     {
 *         OperatingRegions = new[]
 *         {
 *             new Aws.Ec2.Inputs.VpcIpamOperatingRegionArgs
 *             {
 *                 RegionName = current.Apply(getRegionResult => getRegionResult.Name),
 *             },
 *         },
 *     });
 *     var exampleVpcIpamPool = new Aws.Ec2.VpcIpamPool("example", new()
 *     {
 *         AddressFamily = "ipv4",
 *         IpamScopeId = example.PrivateDefaultScopeId,
 *         Locale = current.Apply(getRegionResult => getRegionResult.Name),
 *     });
 *     var exampleVpcIpamPoolCidr = new Aws.Ec2.VpcIpamPoolCidr("example", new()
 *     {
 *         IpamPoolId = exampleVpcIpamPool.Id,
 *         Cidr = "172.20.0.0/16",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := ec2.NewVpcIpam(ctx, "example", &ec2.VpcIpamArgs{
 * 			OperatingRegions: ec2.VpcIpamOperatingRegionArray{
 * 				&ec2.VpcIpamOperatingRegionArgs{
 * 					RegionName: pulumi.String(current.Name),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpcIpamPool, err := ec2.NewVpcIpamPool(ctx, "example", &ec2.VpcIpamPoolArgs{
 * 			AddressFamily: pulumi.String("ipv4"),
 * 			IpamScopeId:   example.PrivateDefaultScopeId,
 * 			Locale:        pulumi.String(current.Name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpcIpamPoolCidr(ctx, "example", &ec2.VpcIpamPoolCidrArgs{
 * 			IpamPoolId: exampleVpcIpamPool.ID(),
 * 			Cidr:       pulumi.String("172.20.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamPool;
 * import com.pulumi.aws.ec2.VpcIpamPoolArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidr;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var example = new VpcIpam("example", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var exampleVpcIpamPool = new VpcIpamPool("exampleVpcIpamPool", VpcIpamPoolArgs.builder()
 *             .addressFamily("ipv4")
 *             .ipamScopeId(example.privateDefaultScopeId())
 *             .locale(current.applyValue(getRegionResult -> getRegionResult.name()))
 *             .build());
 *         var exampleVpcIpamPoolCidr = new VpcIpamPoolCidr("exampleVpcIpamPoolCidr", VpcIpamPoolCidrArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .cidr("172.20.0.0/16")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:VpcIpam
 *     properties:
 *       operatingRegions:
 *         - regionName: ${current.name}
 *   exampleVpcIpamPool:
 *     type: aws:ec2:VpcIpamPool
 *     name: example
 *     properties:
 *       addressFamily: ipv4
 *       ipamScopeId: ${example.privateDefaultScopeId}
 *       locale: ${current.name}
 *   exampleVpcIpamPoolCidr:
 *     type: aws:ec2:VpcIpamPoolCidr
 *     name: example
 *     properties:
 *       ipamPoolId: ${exampleVpcIpamPool.id}
 *       cidr: 172.20.0.0/16
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * Provision Public IPv6 Pool CIDRs:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getRegion({});
 * const example = new aws.ec2.VpcIpam("example", {operatingRegions: [{
 *     regionName: current.then(current => current.name),
 * }]});
 * const ipv6TestPublic = new aws.ec2.VpcIpamPool("ipv6_test_public", {
 *     addressFamily: "ipv6",
 *     ipamScopeId: example.publicDefaultScopeId,
 *     locale: "us-east-1",
 *     description: "public ipv6",
 *     publiclyAdvertisable: false,
 *     publicIpSource: "amazon",
 *     awsService: "ec2",
 * });
 * const ipv6TestPublicVpcIpamPoolCidr = new aws.ec2.VpcIpamPoolCidr("ipv6_test_public", {
 *     ipamPoolId: ipv6TestPublic.id,
 *     netmaskLength: 52,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_region()
 * example = aws.ec2.VpcIpam("example", operating_regions=[{
 *     "region_name": current.name,
 * }])
 * ipv6_test_public = aws.ec2.VpcIpamPool("ipv6_test_public",
 *     address_family="ipv6",
 *     ipam_scope_id=example.public_default_scope_id,
 *     locale="us-east-1",
 *     description="public ipv6",
 *     publicly_advertisable=False,
 *     public_ip_source="amazon",
 *     aws_service="ec2")
 * ipv6_test_public_vpc_ipam_pool_cidr = aws.ec2.VpcIpamPoolCidr("ipv6_test_public",
 *     ipam_pool_id=ipv6_test_public.id,
 *     netmask_length=52)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetRegion.Invoke();
 *     var example = new Aws.Ec2.VpcIpam("example", new()
 *     {
 *         OperatingRegions = new[]
 *         {
 *             new Aws.Ec2.Inputs.VpcIpamOperatingRegionArgs
 *             {
 *                 RegionName = current.Apply(getRegionResult => getRegionResult.Name),
 *             },
 *         },
 *     });
 *     var ipv6TestPublic = new Aws.Ec2.VpcIpamPool("ipv6_test_public", new()
 *     {
 *         AddressFamily = "ipv6",
 *         IpamScopeId = example.PublicDefaultScopeId,
 *         Locale = "us-east-1",
 *         Description = "public ipv6",
 *         PubliclyAdvertisable = false,
 *         PublicIpSource = "amazon",
 *         AwsService = "ec2",
 *     });
 *     var ipv6TestPublicVpcIpamPoolCidr = new Aws.Ec2.VpcIpamPoolCidr("ipv6_test_public", new()
 *     {
 *         IpamPoolId = ipv6TestPublic.Id,
 *         NetmaskLength = 52,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := ec2.NewVpcIpam(ctx, "example", &ec2.VpcIpamArgs{
 * 			OperatingRegions: ec2.VpcIpamOperatingRegionArray{
 * 				&ec2.VpcIpamOperatingRegionArgs{
 * 					RegionName: pulumi.String(current.Name),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		ipv6TestPublic, err := ec2.NewVpcIpamPool(ctx, "ipv6_test_public", &ec2.VpcIpamPoolArgs{
 * 			AddressFamily:        pulumi.String("ipv6"),
 * 			IpamScopeId:          example.PublicDefaultScopeId,
 * 			Locale:               pulumi.String("us-east-1"),
 * 			Description:          pulumi.String("public ipv6"),
 * 			PubliclyAdvertisable: pulumi.Bool(false),
 * 			PublicIpSource:       pulumi.String("amazon"),
 * 			AwsService:           pulumi.String("ec2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpcIpamPoolCidr(ctx, "ipv6_test_public", &ec2.VpcIpamPoolCidrArgs{
 * 			IpamPoolId:    ipv6TestPublic.ID(),
 * 			NetmaskLength: pulumi.Int(52),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamPool;
 * import com.pulumi.aws.ec2.VpcIpamPoolArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidr;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var example = new VpcIpam("example", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var ipv6TestPublic = new VpcIpamPool("ipv6TestPublic", VpcIpamPoolArgs.builder()
 *             .addressFamily("ipv6")
 *             .ipamScopeId(example.publicDefaultScopeId())
 *             .locale("us-east-1")
 *             .description("public ipv6")
 *             .publiclyAdvertisable(false)
 *             .publicIpSource("amazon")
 *             .awsService("ec2")
 *             .build());
 *         var ipv6TestPublicVpcIpamPoolCidr = new VpcIpamPoolCidr("ipv6TestPublicVpcIpamPoolCidr", VpcIpamPoolCidrArgs.builder()
 *             .ipamPoolId(ipv6TestPublic.id())
 *             .netmaskLength(52)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:VpcIpam
 *     properties:
 *       operatingRegions:
 *         - regionName: ${current.name}
 *   ipv6TestPublic:
 *     type: aws:ec2:VpcIpamPool
 *     name: ipv6_test_public
 *     properties:
 *       addressFamily: ipv6
 *       ipamScopeId: ${example.publicDefaultScopeId}
 *       locale: us-east-1
 *       description: public ipv6
 *       publiclyAdvertisable: false
 *       publicIpSource: amazon
 *       awsService: ec2
 *   ipv6TestPublicVpcIpamPoolCidr:
 *     type: aws:ec2:VpcIpamPoolCidr
 *     name: ipv6_test_public
 *     properties:
 *       ipamPoolId: ${ipv6TestPublic.id}
 *       netmaskLength: 52
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IPAMs using the `<cidr>_<ipam-pool-id>`. For example:
 * __NOTE:__ Do not use the IPAM Pool Cidr ID as this was introduced after the resource already existed.
 * ```sh
 * $ pulumi import aws:ec2/vpcIpamPoolCidr:VpcIpamPoolCidr example 172.20.0.0/24_ipam-pool-0e634f5a1517cccdc
 * ```
 */
public class VpcIpamPoolCidr internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcIpamPoolCidr,
) : KotlinCustomResource(javaResource, VpcIpamPoolCidrMapper) {
    /**
     * The CIDR you want to assign to the pool. Conflicts with `netmask_length`.
     */
    public val cidr: Output<String>
        get() = javaResource.cidr().applyValue({ args0 -> args0 })

    /**
     * A signed document that proves that you are authorized to bring the specified IP address range to Amazon using BYOIP. This is not stored in the state file. See cidr_authorization_context for more information.
     */
    public val cidrAuthorizationContext: Output<VpcIpamPoolCidrCidrAuthorizationContext>?
        get() = javaResource.cidrAuthorizationContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The unique ID generated by AWS for the pool cidr. Typically this is the resource `id` but this attribute was added to the API calls after the fact and is therefore not used as the resource id.
     */
    public val ipamPoolCidrId: Output<String>
        get() = javaResource.ipamPoolCidrId().applyValue({ args0 -> args0 })

    /**
     * The ID of the pool to which you want to assign a CIDR.
     */
    public val ipamPoolId: Output<String>
        get() = javaResource.ipamPoolId().applyValue({ args0 -> args0 })

    /**
     * If provided, the cidr provisioned into the specified pool will be the next available cidr given this declared netmask length. Conflicts with `cidr`.
     */
    public val netmaskLength: Output<Int>?
        get() = javaResource.netmaskLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VpcIpamPoolCidrMapper : ResourceMapper<VpcIpamPoolCidr> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcIpamPoolCidr::class == javaResource::class

    override fun map(javaResource: Resource): VpcIpamPoolCidr = VpcIpamPoolCidr(
        javaResource as
            com.pulumi.aws.ec2.VpcIpamPoolCidr,
    )
}

/**
 * @see [VpcIpamPoolCidr].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIpamPoolCidr].
 */
public suspend fun vpcIpamPoolCidr(
    name: String,
    block: suspend VpcIpamPoolCidrResourceBuilder.() -> Unit,
): VpcIpamPoolCidr {
    val builder = VpcIpamPoolCidrResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIpamPoolCidr].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIpamPoolCidr(name: String): VpcIpamPoolCidr {
    val builder = VpcIpamPoolCidrResourceBuilder()
    builder.name(name)
    return builder.build()
}
