@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VpcIpamPoolCidrAllocation].
 */
@PulumiTagMarker
public class VpcIpamPoolCidrAllocationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIpamPoolCidrAllocationArgs = VpcIpamPoolCidrAllocationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIpamPoolCidrAllocationArgsBuilder.() -> Unit) {
        val builder = VpcIpamPoolCidrAllocationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcIpamPoolCidrAllocation {
        val builtJavaResource = com.pulumi.aws.ec2.VpcIpamPoolCidrAllocation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcIpamPoolCidrAllocation(builtJavaResource)
    }
}

/**
 * Allocates (reserves) a CIDR from an IPAM address pool, preventing usage by IPAM. Only works for private IPv4.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getRegion({});
 * const exampleVpcIpam = new aws.ec2.VpcIpam("example", {operatingRegions: [{
 *     regionName: current.then(current => current.name),
 * }]});
 * const exampleVpcIpamPool = new aws.ec2.VpcIpamPool("example", {
 *     addressFamily: "ipv4",
 *     ipamScopeId: exampleVpcIpam.privateDefaultScopeId,
 *     locale: current.then(current => current.name),
 * });
 * const exampleVpcIpamPoolCidr = new aws.ec2.VpcIpamPoolCidr("example", {
 *     ipamPoolId: exampleVpcIpamPool.id,
 *     cidr: "172.20.0.0/16",
 * });
 * const example = new aws.ec2.VpcIpamPoolCidrAllocation("example", {
 *     ipamPoolId: exampleVpcIpamPool.id,
 *     cidr: "172.20.0.0/24",
 * }, {
 *     dependsOn: [exampleVpcIpamPoolCidr],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_region()
 * example_vpc_ipam = aws.ec2.VpcIpam("example", operating_regions=[{
 *     "region_name": current.name,
 * }])
 * example_vpc_ipam_pool = aws.ec2.VpcIpamPool("example",
 *     address_family="ipv4",
 *     ipam_scope_id=example_vpc_ipam.private_default_scope_id,
 *     locale=current.name)
 * example_vpc_ipam_pool_cidr = aws.ec2.VpcIpamPoolCidr("example",
 *     ipam_pool_id=example_vpc_ipam_pool.id,
 *     cidr="172.20.0.0/16")
 * example = aws.ec2.VpcIpamPoolCidrAllocation("example",
 *     ipam_pool_id=example_vpc_ipam_pool.id,
 *     cidr="172.20.0.0/24",
 *     opts = pulumi.ResourceOptions(depends_on=[example_vpc_ipam_pool_cidr]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetRegion.Invoke();
 *     var exampleVpcIpam = new Aws.Ec2.VpcIpam("example", new()
 *     {
 *         OperatingRegions = new[]
 *         {
 *             new Aws.Ec2.Inputs.VpcIpamOperatingRegionArgs
 *             {
 *                 RegionName = current.Apply(getRegionResult => getRegionResult.Name),
 *             },
 *         },
 *     });
 *     var exampleVpcIpamPool = new Aws.Ec2.VpcIpamPool("example", new()
 *     {
 *         AddressFamily = "ipv4",
 *         IpamScopeId = exampleVpcIpam.PrivateDefaultScopeId,
 *         Locale = current.Apply(getRegionResult => getRegionResult.Name),
 *     });
 *     var exampleVpcIpamPoolCidr = new Aws.Ec2.VpcIpamPoolCidr("example", new()
 *     {
 *         IpamPoolId = exampleVpcIpamPool.Id,
 *         Cidr = "172.20.0.0/16",
 *     });
 *     var example = new Aws.Ec2.VpcIpamPoolCidrAllocation("example", new()
 *     {
 *         IpamPoolId = exampleVpcIpamPool.Id,
 *         Cidr = "172.20.0.0/24",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleVpcIpamPoolCidr,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpcIpam, err := ec2.NewVpcIpam(ctx, "example", &ec2.VpcIpamArgs{
 * 			OperatingRegions: ec2.VpcIpamOperatingRegionArray{
 * 				&ec2.VpcIpamOperatingRegionArgs{
 * 					RegionName: pulumi.String(current.Name),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpcIpamPool, err := ec2.NewVpcIpamPool(ctx, "example", &ec2.VpcIpamPoolArgs{
 * 			AddressFamily: pulumi.String("ipv4"),
 * 			IpamScopeId:   exampleVpcIpam.PrivateDefaultScopeId,
 * 			Locale:        pulumi.String(current.Name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpcIpamPoolCidr, err := ec2.NewVpcIpamPoolCidr(ctx, "example", &ec2.VpcIpamPoolCidrArgs{
 * 			IpamPoolId: exampleVpcIpamPool.ID(),
 * 			Cidr:       pulumi.String("172.20.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpcIpamPoolCidrAllocation(ctx, "example", &ec2.VpcIpamPoolCidrAllocationArgs{
 * 			IpamPoolId: exampleVpcIpamPool.ID(),
 * 			Cidr:       pulumi.String("172.20.0.0/24"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleVpcIpamPoolCidr,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamPool;
 * import com.pulumi.aws.ec2.VpcIpamPoolArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidr;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrAllocation;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrAllocationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var exampleVpcIpam = new VpcIpam("exampleVpcIpam", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var exampleVpcIpamPool = new VpcIpamPool("exampleVpcIpamPool", VpcIpamPoolArgs.builder()
 *             .addressFamily("ipv4")
 *             .ipamScopeId(exampleVpcIpam.privateDefaultScopeId())
 *             .locale(current.applyValue(getRegionResult -> getRegionResult.name()))
 *             .build());
 *         var exampleVpcIpamPoolCidr = new VpcIpamPoolCidr("exampleVpcIpamPoolCidr", VpcIpamPoolCidrArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .cidr("172.20.0.0/16")
 *             .build());
 *         var example = new VpcIpamPoolCidrAllocation("example", VpcIpamPoolCidrAllocationArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .cidr("172.20.0.0/24")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleVpcIpamPoolCidr)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:VpcIpamPoolCidrAllocation
 *     properties:
 *       ipamPoolId: ${exampleVpcIpamPool.id}
 *       cidr: 172.20.0.0/24
 *     options:
 *       dependson:
 *         - ${exampleVpcIpamPoolCidr}
 *   exampleVpcIpamPoolCidr:
 *     type: aws:ec2:VpcIpamPoolCidr
 *     name: example
 *     properties:
 *       ipamPoolId: ${exampleVpcIpamPool.id}
 *       cidr: 172.20.0.0/16
 *   exampleVpcIpamPool:
 *     type: aws:ec2:VpcIpamPool
 *     name: example
 *     properties:
 *       addressFamily: ipv4
 *       ipamScopeId: ${exampleVpcIpam.privateDefaultScopeId}
 *       locale: ${current.name}
 *   exampleVpcIpam:
 *     type: aws:ec2:VpcIpam
 *     name: example
 *     properties:
 *       operatingRegions:
 *         - regionName: ${current.name}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * With the `disallowed_cidrs` attribute:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getRegion({});
 * const exampleVpcIpam = new aws.ec2.VpcIpam("example", {operatingRegions: [{
 *     regionName: current.then(current => current.name),
 * }]});
 * const exampleVpcIpamPool = new aws.ec2.VpcIpamPool("example", {
 *     addressFamily: "ipv4",
 *     ipamScopeId: exampleVpcIpam.privateDefaultScopeId,
 *     locale: current.then(current => current.name),
 * });
 * const exampleVpcIpamPoolCidr = new aws.ec2.VpcIpamPoolCidr("example", {
 *     ipamPoolId: exampleVpcIpamPool.id,
 *     cidr: "172.20.0.0/16",
 * });
 * const example = new aws.ec2.VpcIpamPoolCidrAllocation("example", {
 *     ipamPoolId: exampleVpcIpamPool.id,
 *     netmaskLength: 28,
 *     disallowedCidrs: ["172&#46;20&#46;0&#46;0/28"],
 * }, {
 *     dependsOn: [exampleVpcIpamPoolCidr],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_region()
 * example_vpc_ipam = aws.ec2.VpcIpam("example", operating_regions=[{
 *     "region_name": current.name,
 * }])
 * example_vpc_ipam_pool = aws.ec2.VpcIpamPool("example",
 *     address_family="ipv4",
 *     ipam_scope_id=example_vpc_ipam.private_default_scope_id,
 *     locale=current.name)
 * example_vpc_ipam_pool_cidr = aws.ec2.VpcIpamPoolCidr("example",
 *     ipam_pool_id=example_vpc_ipam_pool.id,
 *     cidr="172.20.0.0/16")
 * example = aws.ec2.VpcIpamPoolCidrAllocation("example",
 *     ipam_pool_id=example_vpc_ipam_pool.id,
 *     netmask_length=28,
 *     disallowed_cidrs=["172&#46;20&#46;0&#46;0/28"],
 *     opts = pulumi.ResourceOptions(depends_on=[example_vpc_ipam_pool_cidr]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetRegion.Invoke();
 *     var exampleVpcIpam = new Aws.Ec2.VpcIpam("example", new()
 *     {
 *         OperatingRegions = new[]
 *         {
 *             new Aws.Ec2.Inputs.VpcIpamOperatingRegionArgs
 *             {
 *                 RegionName = current.Apply(getRegionResult => getRegionResult.Name),
 *             },
 *         },
 *     });
 *     var exampleVpcIpamPool = new Aws.Ec2.VpcIpamPool("example", new()
 *     {
 *         AddressFamily = "ipv4",
 *         IpamScopeId = exampleVpcIpam.PrivateDefaultScopeId,
 *         Locale = current.Apply(getRegionResult => getRegionResult.Name),
 *     });
 *     var exampleVpcIpamPoolCidr = new Aws.Ec2.VpcIpamPoolCidr("example", new()
 *     {
 *         IpamPoolId = exampleVpcIpamPool.Id,
 *         Cidr = "172.20.0.0/16",
 *     });
 *     var example = new Aws.Ec2.VpcIpamPoolCidrAllocation("example", new()
 *     {
 *         IpamPoolId = exampleVpcIpamPool.Id,
 *         NetmaskLength = 28,
 *         DisallowedCidrs = new[]
 *         {
 *             "172.20.0.0/28",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleVpcIpamPoolCidr,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpcIpam, err := ec2.NewVpcIpam(ctx, "example", &ec2.VpcIpamArgs{
 * 			OperatingRegions: ec2.VpcIpamOperatingRegionArray{
 * 				&ec2.VpcIpamOperatingRegionArgs{
 * 					RegionName: pulumi.String(current.Name),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpcIpamPool, err := ec2.NewVpcIpamPool(ctx, "example", &ec2.VpcIpamPoolArgs{
 * 			AddressFamily: pulumi.String("ipv4"),
 * 			IpamScopeId:   exampleVpcIpam.PrivateDefaultScopeId,
 * 			Locale:        pulumi.String(current.Name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpcIpamPoolCidr, err := ec2.NewVpcIpamPoolCidr(ctx, "example", &ec2.VpcIpamPoolCidrArgs{
 * 			IpamPoolId: exampleVpcIpamPool.ID(),
 * 			Cidr:       pulumi.String("172.20.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpcIpamPoolCidrAllocation(ctx, "example", &ec2.VpcIpamPoolCidrAllocationArgs{
 * 			IpamPoolId:    exampleVpcIpamPool.ID(),
 * 			NetmaskLength: pulumi.Int(28),
 * 			DisallowedCidrs: pulumi.StringArray{
 * 				pulumi.String("172.20.0.0/28"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleVpcIpamPoolCidr,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamPool;
 * import com.pulumi.aws.ec2.VpcIpamPoolArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidr;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrAllocation;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrAllocationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var exampleVpcIpam = new VpcIpam("exampleVpcIpam", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var exampleVpcIpamPool = new VpcIpamPool("exampleVpcIpamPool", VpcIpamPoolArgs.builder()
 *             .addressFamily("ipv4")
 *             .ipamScopeId(exampleVpcIpam.privateDefaultScopeId())
 *             .locale(current.applyValue(getRegionResult -> getRegionResult.name()))
 *             .build());
 *         var exampleVpcIpamPoolCidr = new VpcIpamPoolCidr("exampleVpcIpamPoolCidr", VpcIpamPoolCidrArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .cidr("172.20.0.0/16")
 *             .build());
 *         var example = new VpcIpamPoolCidrAllocation("example", VpcIpamPoolCidrAllocationArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .netmaskLength(28)
 *             .disallowedCidrs("172.20.0.0/28")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleVpcIpamPoolCidr)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:VpcIpamPoolCidrAllocation
 *     properties:
 *       ipamPoolId: ${exampleVpcIpamPool.id}
 *       netmaskLength: 28
 *       disallowedCidrs:
 *         - 172.20.0.0/28
 *     options:
 *       dependson:
 *         - ${exampleVpcIpamPoolCidr}
 *   exampleVpcIpamPoolCidr:
 *     type: aws:ec2:VpcIpamPoolCidr
 *     name: example
 *     properties:
 *       ipamPoolId: ${exampleVpcIpamPool.id}
 *       cidr: 172.20.0.0/16
 *   exampleVpcIpamPool:
 *     type: aws:ec2:VpcIpamPool
 *     name: example
 *     properties:
 *       addressFamily: ipv4
 *       ipamScopeId: ${exampleVpcIpam.privateDefaultScopeId}
 *       locale: ${current.name}
 *   exampleVpcIpam:
 *     type: aws:ec2:VpcIpam
 *     name: example
 *     properties:
 *       operatingRegions:
 *         - regionName: ${current.name}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IPAM allocations using the allocation `id` and `pool id`, separated by `_`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcIpamPoolCidrAllocation:VpcIpamPoolCidrAllocation example ipam-pool-alloc-0dc6d196509c049ba8b549ff99f639736_ipam-pool-07cfb559e0921fcbe
 * ```
 */
public class VpcIpamPoolCidrAllocation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcIpamPoolCidrAllocation,
) : KotlinCustomResource(javaResource, VpcIpamPoolCidrAllocationMapper) {
    /**
     * The CIDR you want to assign to the pool.
     */
    public val cidr: Output<String>
        get() = javaResource.cidr().applyValue({ args0 -> args0 })

    /**
     * The description for the allocation.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Exclude a particular CIDR range from being returned by the pool.
     */
    public val disallowedCidrs: Output<List<String>>?
        get() = javaResource.disallowedCidrs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val ipamPoolAllocationId: Output<String>
        get() = javaResource.ipamPoolAllocationId().applyValue({ args0 -> args0 })

    /**
     * The ID of the pool to which you want to assign a CIDR.
     */
    public val ipamPoolId: Output<String>
        get() = javaResource.ipamPoolId().applyValue({ args0 -> args0 })

    /**
     * The netmask length of the CIDR you would like to allocate to the IPAM pool. Valid Values: `0-128`.
     */
    public val netmaskLength: Output<Int>
        get() = javaResource.netmaskLength().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * The owner of the resource.
     */
    public val resourceOwner: Output<String>
        get() = javaResource.resourceOwner().applyValue({ args0 -> args0 })

    /**
     * The type of the resource.
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })
}

public object VpcIpamPoolCidrAllocationMapper : ResourceMapper<VpcIpamPoolCidrAllocation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcIpamPoolCidrAllocation::class == javaResource::class

    override fun map(javaResource: Resource): VpcIpamPoolCidrAllocation =
        VpcIpamPoolCidrAllocation(javaResource as com.pulumi.aws.ec2.VpcIpamPoolCidrAllocation)
}

/**
 * @see [VpcIpamPoolCidrAllocation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIpamPoolCidrAllocation].
 */
public suspend fun vpcIpamPoolCidrAllocation(
    name: String,
    block: suspend VpcIpamPoolCidrAllocationResourceBuilder.() -> Unit,
): VpcIpamPoolCidrAllocation {
    val builder = VpcIpamPoolCidrAllocationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIpamPoolCidrAllocation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIpamPoolCidrAllocation(name: String): VpcIpamPoolCidrAllocation {
    val builder = VpcIpamPoolCidrAllocationResourceBuilder()
    builder.name(name)
    return builder.build()
}
