@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VpcIpamPreviewNextCidr].
 */
@PulumiTagMarker
public class VpcIpamPreviewNextCidrResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIpamPreviewNextCidrArgs = VpcIpamPreviewNextCidrArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIpamPreviewNextCidrArgsBuilder.() -> Unit) {
        val builder = VpcIpamPreviewNextCidrArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcIpamPreviewNextCidr {
        val builtJavaResource = com.pulumi.aws.ec2.VpcIpamPreviewNextCidr(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcIpamPreviewNextCidr(builtJavaResource)
    }
}

/**
 * Previews a CIDR from an IPAM address pool. Only works for private IPv4.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getRegion({});
 * const exampleVpcIpam = new aws.ec2.VpcIpam("example", {operatingRegions: [{
 *     regionName: current.then(current => current.name),
 * }]});
 * const exampleVpcIpamPool = new aws.ec2.VpcIpamPool("example", {
 *     addressFamily: "ipv4",
 *     ipamScopeId: exampleVpcIpam.privateDefaultScopeId,
 *     locale: current.then(current => current.name),
 * });
 * const exampleVpcIpamPoolCidr = new aws.ec2.VpcIpamPoolCidr("example", {
 *     ipamPoolId: exampleVpcIpamPool.id,
 *     cidr: "172.20.0.0/16",
 * });
 * const example = new aws.ec2.VpcIpamPreviewNextCidr("example", {
 *     ipamPoolId: exampleVpcIpamPool.id,
 *     netmaskLength: 28,
 *     disallowedCidrs: ["172&#46;2&#46;0&#46;0/32"],
 * }, {
 *     dependsOn: [exampleVpcIpamPoolCidr],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_region()
 * example_vpc_ipam = aws.ec2.VpcIpam("example", operating_regions=[{
 *     "region_name": current.name,
 * }])
 * example_vpc_ipam_pool = aws.ec2.VpcIpamPool("example",
 *     address_family="ipv4",
 *     ipam_scope_id=example_vpc_ipam.private_default_scope_id,
 *     locale=current.name)
 * example_vpc_ipam_pool_cidr = aws.ec2.VpcIpamPoolCidr("example",
 *     ipam_pool_id=example_vpc_ipam_pool.id,
 *     cidr="172.20.0.0/16")
 * example = aws.ec2.VpcIpamPreviewNextCidr("example",
 *     ipam_pool_id=example_vpc_ipam_pool.id,
 *     netmask_length=28,
 *     disallowed_cidrs=["172&#46;2&#46;0&#46;0/32"],
 *     opts = pulumi.ResourceOptions(depends_on=[example_vpc_ipam_pool_cidr]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetRegion.Invoke();
 *     var exampleVpcIpam = new Aws.Ec2.VpcIpam("example", new()
 *     {
 *         OperatingRegions = new[]
 *         {
 *             new Aws.Ec2.Inputs.VpcIpamOperatingRegionArgs
 *             {
 *                 RegionName = current.Apply(getRegionResult => getRegionResult.Name),
 *             },
 *         },
 *     });
 *     var exampleVpcIpamPool = new Aws.Ec2.VpcIpamPool("example", new()
 *     {
 *         AddressFamily = "ipv4",
 *         IpamScopeId = exampleVpcIpam.PrivateDefaultScopeId,
 *         Locale = current.Apply(getRegionResult => getRegionResult.Name),
 *     });
 *     var exampleVpcIpamPoolCidr = new Aws.Ec2.VpcIpamPoolCidr("example", new()
 *     {
 *         IpamPoolId = exampleVpcIpamPool.Id,
 *         Cidr = "172.20.0.0/16",
 *     });
 *     var example = new Aws.Ec2.VpcIpamPreviewNextCidr("example", new()
 *     {
 *         IpamPoolId = exampleVpcIpamPool.Id,
 *         NetmaskLength = 28,
 *         DisallowedCidrs = new[]
 *         {
 *             "172.2.0.0/32",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleVpcIpamPoolCidr,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpcIpam, err := ec2.NewVpcIpam(ctx, "example", &ec2.VpcIpamArgs{
 * 			OperatingRegions: ec2.VpcIpamOperatingRegionArray{
 * 				&ec2.VpcIpamOperatingRegionArgs{
 * 					RegionName: pulumi.String(current.Name),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpcIpamPool, err := ec2.NewVpcIpamPool(ctx, "example", &ec2.VpcIpamPoolArgs{
 * 			AddressFamily: pulumi.String("ipv4"),
 * 			IpamScopeId:   exampleVpcIpam.PrivateDefaultScopeId,
 * 			Locale:        pulumi.String(current.Name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVpcIpamPoolCidr, err := ec2.NewVpcIpamPoolCidr(ctx, "example", &ec2.VpcIpamPoolCidrArgs{
 * 			IpamPoolId: exampleVpcIpamPool.ID(),
 * 			Cidr:       pulumi.String("172.20.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpcIpamPreviewNextCidr(ctx, "example", &ec2.VpcIpamPreviewNextCidrArgs{
 * 			IpamPoolId:    exampleVpcIpamPool.ID(),
 * 			NetmaskLength: pulumi.Int(28),
 * 			DisallowedCidrs: pulumi.StringArray{
 * 				pulumi.String("172.2.0.0/32"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleVpcIpamPoolCidr,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamPool;
 * import com.pulumi.aws.ec2.VpcIpamPoolArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidr;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrArgs;
 * import com.pulumi.aws.ec2.VpcIpamPreviewNextCidr;
 * import com.pulumi.aws.ec2.VpcIpamPreviewNextCidrArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var exampleVpcIpam = new VpcIpam("exampleVpcIpam", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var exampleVpcIpamPool = new VpcIpamPool("exampleVpcIpamPool", VpcIpamPoolArgs.builder()
 *             .addressFamily("ipv4")
 *             .ipamScopeId(exampleVpcIpam.privateDefaultScopeId())
 *             .locale(current.applyValue(getRegionResult -> getRegionResult.name()))
 *             .build());
 *         var exampleVpcIpamPoolCidr = new VpcIpamPoolCidr("exampleVpcIpamPoolCidr", VpcIpamPoolCidrArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .cidr("172.20.0.0/16")
 *             .build());
 *         var example = new VpcIpamPreviewNextCidr("example", VpcIpamPreviewNextCidrArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .netmaskLength(28)
 *             .disallowedCidrs("172.2.0.0/32")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleVpcIpamPoolCidr)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:VpcIpamPreviewNextCidr
 *     properties:
 *       ipamPoolId: ${exampleVpcIpamPool.id}
 *       netmaskLength: 28
 *       disallowedCidrs:
 *         - 172.2.0.0/32
 *     options:
 *       dependson:
 *         - ${exampleVpcIpamPoolCidr}
 *   exampleVpcIpamPoolCidr:
 *     type: aws:ec2:VpcIpamPoolCidr
 *     name: example
 *     properties:
 *       ipamPoolId: ${exampleVpcIpamPool.id}
 *       cidr: 172.20.0.0/16
 *   exampleVpcIpamPool:
 *     type: aws:ec2:VpcIpamPool
 *     name: example
 *     properties:
 *       addressFamily: ipv4
 *       ipamScopeId: ${exampleVpcIpam.privateDefaultScopeId}
 *       locale: ${current.name}
 *   exampleVpcIpam:
 *     type: aws:ec2:VpcIpam
 *     name: example
 *     properties:
 *       operatingRegions:
 *         - regionName: ${current.name}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class VpcIpamPreviewNextCidr internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcIpamPreviewNextCidr,
) : KotlinCustomResource(javaResource, VpcIpamPreviewNextCidrMapper) {
    /**
     * The previewed CIDR from the pool.
     */
    public val cidr: Output<String>
        get() = javaResource.cidr().applyValue({ args0 -> args0 })

    /**
     * Exclude a particular CIDR range from being returned by the pool.
     */
    public val disallowedCidrs: Output<List<String>>?
        get() = javaResource.disallowedCidrs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The ID of the pool to which you want to assign a CIDR.
     */
    public val ipamPoolId: Output<String>
        get() = javaResource.ipamPoolId().applyValue({ args0 -> args0 })

    /**
     * The netmask length of the CIDR you would like to preview from the IPAM pool.
     */
    public val netmaskLength: Output<Int>?
        get() = javaResource.netmaskLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VpcIpamPreviewNextCidrMapper : ResourceMapper<VpcIpamPreviewNextCidr> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcIpamPreviewNextCidr::class == javaResource::class

    override fun map(javaResource: Resource): VpcIpamPreviewNextCidr =
        VpcIpamPreviewNextCidr(javaResource as com.pulumi.aws.ec2.VpcIpamPreviewNextCidr)
}

/**
 * @see [VpcIpamPreviewNextCidr].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIpamPreviewNextCidr].
 */
public suspend fun vpcIpamPreviewNextCidr(
    name: String,
    block: suspend VpcIpamPreviewNextCidrResourceBuilder.() -> Unit,
): VpcIpamPreviewNextCidr {
    val builder = VpcIpamPreviewNextCidrResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIpamPreviewNextCidr].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIpamPreviewNextCidr(name: String): VpcIpamPreviewNextCidr {
    val builder = VpcIpamPreviewNextCidrResourceBuilder()
    builder.name(name)
    return builder.build()
}
