@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcIpamResourceDiscoveryArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.VpcIpamResourceDiscoveryOperatingRegionArgs
import com.pulumi.aws.ec2.kotlin.inputs.VpcIpamResourceDiscoveryOperatingRegionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an IPAM Resource Discovery resource. IPAM Resource Discoveries are resources meant for multi-organization customers. If you wish to use a single IPAM across multiple orgs, a resource discovery can be created and shared from a subordinate organization to the management organizations IPAM delegated admin account. For a full deployment example, see `aws.ec2.VpcIpamResourceDiscoveryAssociation` resource.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getRegion({});
 * const main = new aws.ec2.VpcIpamResourceDiscovery("main", {
 *     description: "My IPAM Resource Discovery",
 *     operatingRegions: [{
 *         regionName: current.then(current => current.name),
 *     }],
 *     tags: {
 *         Test: "Main",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_region()
 * main = aws.ec2.VpcIpamResourceDiscovery("main",
 *     description="My IPAM Resource Discovery",
 *     operating_regions=[{
 *         "region_name": current.name,
 *     }],
 *     tags={
 *         "Test": "Main",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetRegion.Invoke();
 *     var main = new Aws.Ec2.VpcIpamResourceDiscovery("main", new()
 *     {
 *         Description = "My IPAM Resource Discovery",
 *         OperatingRegions = new[]
 *         {
 *             new Aws.Ec2.Inputs.VpcIpamResourceDiscoveryOperatingRegionArgs
 *             {
 *                 RegionName = current.Apply(getRegionResult => getRegionResult.Name),
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Test", "Main" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpcIpamResourceDiscovery(ctx, "main", &ec2.VpcIpamResourceDiscoveryArgs{
 * 			Description: pulumi.String("My IPAM Resource Discovery"),
 * 			OperatingRegions: ec2.VpcIpamResourceDiscoveryOperatingRegionArray{
 * 				&ec2.VpcIpamResourceDiscoveryOperatingRegionArgs{
 * 					RegionName: pulumi.String(current.Name),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Test": pulumi.String("Main"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamResourceDiscovery;
 * import com.pulumi.aws.ec2.VpcIpamResourceDiscoveryArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamResourceDiscoveryOperatingRegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var main = new VpcIpamResourceDiscovery("main", VpcIpamResourceDiscoveryArgs.builder()
 *             .description("My IPAM Resource Discovery")
 *             .operatingRegions(VpcIpamResourceDiscoveryOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .tags(Map.of("Test", "Main"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:ec2:VpcIpamResourceDiscovery
 *     properties:
 *       description: My IPAM Resource Discovery
 *       operatingRegions:
 *         - regionName: ${current.name}
 *       tags:
 *         Test: Main
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IPAMs using the IPAM resource discovery `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcIpamResourceDiscovery:VpcIpamResourceDiscovery example ipam-res-disco-0178368ad2146a492
 * ```
 * @property description A description for the IPAM Resource Discovery.
 * @property operatingRegions Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VpcIpamResourceDiscoveryArgs(
    public val description: Output<String>? = null,
    public val operatingRegions: Output<List<VpcIpamResourceDiscoveryOperatingRegionArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcIpamResourceDiscoveryArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcIpamResourceDiscoveryArgs =
        com.pulumi.aws.ec2.VpcIpamResourceDiscoveryArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .operatingRegions(
                operatingRegions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VpcIpamResourceDiscoveryArgs].
 */
@PulumiTagMarker
public class VpcIpamResourceDiscoveryArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var operatingRegions: Output<List<VpcIpamResourceDiscoveryOperatingRegionArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A description for the IPAM Resource Discovery.
     */
    @JvmName("fxluucepfgkdgwni")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     */
    @JvmName("socosrqqyurdjkjf")
    public suspend fun operatingRegions(`value`: Output<List<VpcIpamResourceDiscoveryOperatingRegionArgs>>) {
        this.operatingRegions = value
    }

    @JvmName("ywcqncpvjtwfdenm")
    public suspend fun operatingRegions(vararg values: Output<VpcIpamResourceDiscoveryOperatingRegionArgs>) {
        this.operatingRegions = Output.all(values.asList())
    }

    /**
     * @param values Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     */
    @JvmName("csenmkvtoyiiewei")
    public suspend fun operatingRegions(values: List<Output<VpcIpamResourceDiscoveryOperatingRegionArgs>>) {
        this.operatingRegions = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tltkbefvburrcyyp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A description for the IPAM Resource Discovery.
     */
    @JvmName("yhspstlfwyxgviln")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     */
    @JvmName("abkkiqqmcmlwwsls")
    public suspend fun operatingRegions(`value`: List<VpcIpamResourceDiscoveryOperatingRegionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatingRegions = mapped
    }

    /**
     * @param argument Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     */
    @JvmName("gjngvqpjxxulslxf")
    public suspend fun operatingRegions(argument: List<suspend VpcIpamResourceDiscoveryOperatingRegionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpcIpamResourceDiscoveryOperatingRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.operatingRegions = mapped
    }

    /**
     * @param argument Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     */
    @JvmName("ilcenfykgnnjkfdq")
    public suspend fun operatingRegions(vararg argument: suspend VpcIpamResourceDiscoveryOperatingRegionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VpcIpamResourceDiscoveryOperatingRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.operatingRegions = mapped
    }

    /**
     * @param argument Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     */
    @JvmName("wjvxkulmywqdtiad")
    public suspend fun operatingRegions(argument: suspend VpcIpamResourceDiscoveryOperatingRegionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpcIpamResourceDiscoveryOperatingRegionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.operatingRegions = mapped
    }

    /**
     * @param values Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     */
    @JvmName("mfbbuewselfafbxg")
    public suspend fun operatingRegions(vararg values: VpcIpamResourceDiscoveryOperatingRegionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatingRegions = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rlnnjsirhawqqftd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bxjvcpgfdofpqvbt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VpcIpamResourceDiscoveryArgs = VpcIpamResourceDiscoveryArgs(
        description = description,
        operatingRegions = operatingRegions,
        tags = tags,
    )
}
