@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VpcIpamResourceDiscoveryAssociation].
 */
@PulumiTagMarker
public class VpcIpamResourceDiscoveryAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIpamResourceDiscoveryAssociationArgs =
        VpcIpamResourceDiscoveryAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIpamResourceDiscoveryAssociationArgsBuilder.() -> Unit) {
        val builder = VpcIpamResourceDiscoveryAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcIpamResourceDiscoveryAssociation {
        val builtJavaResource =
            com.pulumi.aws.ec2.VpcIpamResourceDiscoveryAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VpcIpamResourceDiscoveryAssociation(builtJavaResource)
    }
}

/**
 * Provides an association between an Amazon IP Address Manager (IPAM) and a IPAM Resource Discovery. IPAM Resource Discoveries are resources meant for multi-organization customers. If you wish to use a single IPAM across multiple orgs, a resource discovery can be created and shared from a subordinate organization to the management organizations IPAM delegated admin account.
 * Once an association is created between two organizations via IPAM & a IPAM Resource Discovery, IPAM Pools can be shared via Resource Access Manager (RAM) to accounts in the subordinate organization; these RAM shares must be accepted by the end user account. Pools can then also discover and monitor IPAM resources in the subordinate organization.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.ec2.VpcIpamResourceDiscoveryAssociation("test", {
 *     ipamId: testAwsVpcIpam.id,
 *     ipamResourceDiscoveryId: testAwsVpcIpamResourceDiscovery.id,
 *     tags: {
 *         Name: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.ec2.VpcIpamResourceDiscoveryAssociation("test",
 *     ipam_id=test_aws_vpc_ipam["id"],
 *     ipam_resource_discovery_id=test_aws_vpc_ipam_resource_discovery["id"],
 *     tags={
 *         "Name": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Ec2.VpcIpamResourceDiscoveryAssociation("test", new()
 *     {
 *         IpamId = testAwsVpcIpam.Id,
 *         IpamResourceDiscoveryId = testAwsVpcIpamResourceDiscovery.Id,
 *         Tags =
 *         {
 *             { "Name", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcIpamResourceDiscoveryAssociation(ctx, "test", &ec2.VpcIpamResourceDiscoveryAssociationArgs{
 * 			IpamId:                  pulumi.Any(testAwsVpcIpam.Id),
 * 			IpamResourceDiscoveryId: pulumi.Any(testAwsVpcIpamResourceDiscovery.Id),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcIpamResourceDiscoveryAssociation;
 * import com.pulumi.aws.ec2.VpcIpamResourceDiscoveryAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new VpcIpamResourceDiscoveryAssociation("test", VpcIpamResourceDiscoveryAssociationArgs.builder()
 *             .ipamId(testAwsVpcIpam.id())
 *             .ipamResourceDiscoveryId(testAwsVpcIpamResourceDiscovery.id())
 *             .tags(Map.of("Name", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:ec2:VpcIpamResourceDiscoveryAssociation
 *     properties:
 *       ipamId: ${testAwsVpcIpam.id}
 *       ipamResourceDiscoveryId: ${testAwsVpcIpamResourceDiscovery.id}
 *       tags:
 *         Name: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IPAMs using the IPAM resource discovery association `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcIpamResourceDiscoveryAssociation:VpcIpamResourceDiscoveryAssociation example ipam-res-disco-assoc-0178368ad2146a492
 * ```
 */
public class VpcIpamResourceDiscoveryAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcIpamResourceDiscoveryAssociation,
) : KotlinCustomResource(javaResource, VpcIpamResourceDiscoveryAssociationMapper) {
    /**
     * The Amazon Resource Name (ARN) of IPAM Resource Discovery Association.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the IPAM.
     */
    public val ipamArn: Output<String>
        get() = javaResource.ipamArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the IPAM to associate.
     */
    public val ipamId: Output<String>
        get() = javaResource.ipamId().applyValue({ args0 -> args0 })

    /**
     * The home region of the IPAM.
     */
    public val ipamRegion: Output<String>
        get() = javaResource.ipamRegion().applyValue({ args0 -> args0 })

    /**
     * The ID of the Resource Discovery to associate.
     */
    public val ipamResourceDiscoveryId: Output<String>
        get() = javaResource.ipamResourceDiscoveryId().applyValue({ args0 -> args0 })

    /**
     * A boolean to identify if the Resource Discovery is the accounts default resource discovery.
     */
    public val isDefault: Output<Boolean>
        get() = javaResource.isDefault().applyValue({ args0 -> args0 })

    /**
     * The account ID for the account that manages the Resource Discovery
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * The lifecycle state of the association when you associate or disassociate a resource discovery.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * A map of tags to add to the IPAM resource discovery association resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VpcIpamResourceDiscoveryAssociationMapper :
    ResourceMapper<VpcIpamResourceDiscoveryAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcIpamResourceDiscoveryAssociation::class == javaResource::class

    override fun map(javaResource: Resource): VpcIpamResourceDiscoveryAssociation =
        VpcIpamResourceDiscoveryAssociation(
            javaResource as
                com.pulumi.aws.ec2.VpcIpamResourceDiscoveryAssociation,
        )
}

/**
 * @see [VpcIpamResourceDiscoveryAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIpamResourceDiscoveryAssociation].
 */
public suspend fun vpcIpamResourceDiscoveryAssociation(
    name: String,
    block: suspend VpcIpamResourceDiscoveryAssociationResourceBuilder.() -> Unit,
): VpcIpamResourceDiscoveryAssociation {
    val builder = VpcIpamResourceDiscoveryAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIpamResourceDiscoveryAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIpamResourceDiscoveryAssociation(name: String): VpcIpamResourceDiscoveryAssociation {
    val builder = VpcIpamResourceDiscoveryAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
