@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcIpamResourceDiscoveryAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an association between an Amazon IP Address Manager (IPAM) and a IPAM Resource Discovery. IPAM Resource Discoveries are resources meant for multi-organization customers. If you wish to use a single IPAM across multiple orgs, a resource discovery can be created and shared from a subordinate organization to the management organizations IPAM delegated admin account.
 * Once an association is created between two organizations via IPAM & a IPAM Resource Discovery, IPAM Pools can be shared via Resource Access Manager (RAM) to accounts in the subordinate organization; these RAM shares must be accepted by the end user account. Pools can then also discover and monitor IPAM resources in the subordinate organization.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.ec2.VpcIpamResourceDiscoveryAssociation("test", {
 *     ipamId: testAwsVpcIpam.id,
 *     ipamResourceDiscoveryId: testAwsVpcIpamResourceDiscovery.id,
 *     tags: {
 *         Name: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.ec2.VpcIpamResourceDiscoveryAssociation("test",
 *     ipam_id=test_aws_vpc_ipam["id"],
 *     ipam_resource_discovery_id=test_aws_vpc_ipam_resource_discovery["id"],
 *     tags={
 *         "Name": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Ec2.VpcIpamResourceDiscoveryAssociation("test", new()
 *     {
 *         IpamId = testAwsVpcIpam.Id,
 *         IpamResourceDiscoveryId = testAwsVpcIpamResourceDiscovery.Id,
 *         Tags =
 *         {
 *             { "Name", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewVpcIpamResourceDiscoveryAssociation(ctx, "test", &ec2.VpcIpamResourceDiscoveryAssociationArgs{
 * 			IpamId:                  pulumi.Any(testAwsVpcIpam.Id),
 * 			IpamResourceDiscoveryId: pulumi.Any(testAwsVpcIpamResourceDiscovery.Id),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcIpamResourceDiscoveryAssociation;
 * import com.pulumi.aws.ec2.VpcIpamResourceDiscoveryAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new VpcIpamResourceDiscoveryAssociation("test", VpcIpamResourceDiscoveryAssociationArgs.builder()
 *             .ipamId(testAwsVpcIpam.id())
 *             .ipamResourceDiscoveryId(testAwsVpcIpamResourceDiscovery.id())
 *             .tags(Map.of("Name", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:ec2:VpcIpamResourceDiscoveryAssociation
 *     properties:
 *       ipamId: ${testAwsVpcIpam.id}
 *       ipamResourceDiscoveryId: ${testAwsVpcIpamResourceDiscovery.id}
 *       tags:
 *         Name: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IPAMs using the IPAM resource discovery association `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcIpamResourceDiscoveryAssociation:VpcIpamResourceDiscoveryAssociation example ipam-res-disco-assoc-0178368ad2146a492
 * ```
 * @property ipamId The ID of the IPAM to associate.
 * @property ipamResourceDiscoveryId The ID of the Resource Discovery to associate.
 * @property tags A map of tags to add to the IPAM resource discovery association resource.
 */
public data class VpcIpamResourceDiscoveryAssociationArgs(
    public val ipamId: Output<String>? = null,
    public val ipamResourceDiscoveryId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcIpamResourceDiscoveryAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcIpamResourceDiscoveryAssociationArgs =
        com.pulumi.aws.ec2.VpcIpamResourceDiscoveryAssociationArgs.builder()
            .ipamId(ipamId?.applyValue({ args0 -> args0 }))
            .ipamResourceDiscoveryId(ipamResourceDiscoveryId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VpcIpamResourceDiscoveryAssociationArgs].
 */
@PulumiTagMarker
public class VpcIpamResourceDiscoveryAssociationArgsBuilder internal constructor() {
    private var ipamId: Output<String>? = null

    private var ipamResourceDiscoveryId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The ID of the IPAM to associate.
     */
    @JvmName("mgglbteixsytcaad")
    public suspend fun ipamId(`value`: Output<String>) {
        this.ipamId = value
    }

    /**
     * @param value The ID of the Resource Discovery to associate.
     */
    @JvmName("uisdegsnqvwdxdqs")
    public suspend fun ipamResourceDiscoveryId(`value`: Output<String>) {
        this.ipamResourceDiscoveryId = value
    }

    /**
     * @param value A map of tags to add to the IPAM resource discovery association resource.
     */
    @JvmName("mxxrnynbbkxdffoy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the IPAM to associate.
     */
    @JvmName("ixawadfkygjcyqsw")
    public suspend fun ipamId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipamId = mapped
    }

    /**
     * @param value The ID of the Resource Discovery to associate.
     */
    @JvmName("qcippjfxbmptdbds")
    public suspend fun ipamResourceDiscoveryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipamResourceDiscoveryId = mapped
    }

    /**
     * @param value A map of tags to add to the IPAM resource discovery association resource.
     */
    @JvmName("gjqahstqiukvkdlq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to add to the IPAM resource discovery association resource.
     */
    @JvmName("gdvctjaqbpowpqbj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VpcIpamResourceDiscoveryAssociationArgs =
        VpcIpamResourceDiscoveryAssociationArgs(
            ipamId = ipamId,
            ipamResourceDiscoveryId = ipamResourceDiscoveryId,
            tags = tags,
        )
}
