@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VpcIpamScope].
 */
@PulumiTagMarker
public class VpcIpamScopeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIpamScopeArgs = VpcIpamScopeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIpamScopeArgsBuilder.() -> Unit) {
        val builder = VpcIpamScopeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcIpamScope {
        val builtJavaResource = com.pulumi.aws.ec2.VpcIpamScope(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcIpamScope(builtJavaResource)
    }
}

/**
 * Creates a scope for AWS IPAM.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getRegion({});
 * const example = new aws.ec2.VpcIpam("example", {operatingRegions: [{
 *     regionName: current.then(current => current.name),
 * }]});
 * const exampleVpcIpamScope = new aws.ec2.VpcIpamScope("example", {
 *     ipamId: example.id,
 *     description: "Another Scope",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_region()
 * example = aws.ec2.VpcIpam("example", operating_regions=[{
 *     "region_name": current.name,
 * }])
 * example_vpc_ipam_scope = aws.ec2.VpcIpamScope("example",
 *     ipam_id=example.id,
 *     description="Another Scope")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetRegion.Invoke();
 *     var example = new Aws.Ec2.VpcIpam("example", new()
 *     {
 *         OperatingRegions = new[]
 *         {
 *             new Aws.Ec2.Inputs.VpcIpamOperatingRegionArgs
 *             {
 *                 RegionName = current.Apply(getRegionResult => getRegionResult.Name),
 *             },
 *         },
 *     });
 *     var exampleVpcIpamScope = new Aws.Ec2.VpcIpamScope("example", new()
 *     {
 *         IpamId = example.Id,
 *         Description = "Another Scope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := ec2.NewVpcIpam(ctx, "example", &ec2.VpcIpamArgs{
 * 			OperatingRegions: ec2.VpcIpamOperatingRegionArray{
 * 				&ec2.VpcIpamOperatingRegionArgs{
 * 					RegionName: pulumi.String(current.Name),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpcIpamScope(ctx, "example", &ec2.VpcIpamScopeArgs{
 * 			IpamId:      example.ID(),
 * 			Description: pulumi.String("Another Scope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamScope;
 * import com.pulumi.aws.ec2.VpcIpamScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var example = new VpcIpam("example", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var exampleVpcIpamScope = new VpcIpamScope("exampleVpcIpamScope", VpcIpamScopeArgs.builder()
 *             .ipamId(example.id())
 *             .description("Another Scope")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:VpcIpam
 *     properties:
 *       operatingRegions:
 *         - regionName: ${current.name}
 *   exampleVpcIpamScope:
 *     type: aws:ec2:VpcIpamScope
 *     name: example
 *     properties:
 *       ipamId: ${example.id}
 *       description: Another Scope
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IPAMs using the `scope_id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcIpamScope:VpcIpamScope example ipam-scope-0513c69f283d11dfb
 * ```
 */
public class VpcIpamScope internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcIpamScope,
) : KotlinCustomResource(javaResource, VpcIpamScopeMapper) {
    /**
     * The Amazon Resource Name (ARN) of the scope.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description for the scope you're creating.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the IPAM for which you're creating this scope.
     */
    public val ipamArn: Output<String>
        get() = javaResource.ipamArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the IPAM for which you're creating this scope.
     */
    public val ipamId: Output<String>
        get() = javaResource.ipamId().applyValue({ args0 -> args0 })

    public val ipamScopeType: Output<String>
        get() = javaResource.ipamScopeType().applyValue({ args0 -> args0 })

    /**
     * Defines if the scope is the default scope or not.
     */
    public val isDefault: Output<Boolean>
        get() = javaResource.isDefault().applyValue({ args0 -> args0 })

    /**
     * The number of pools in the scope.
     */
    public val poolCount: Output<Int>
        get() = javaResource.poolCount().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VpcIpamScopeMapper : ResourceMapper<VpcIpamScope> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcIpamScope::class == javaResource::class

    override fun map(javaResource: Resource): VpcIpamScope = VpcIpamScope(
        javaResource as
            com.pulumi.aws.ec2.VpcIpamScope,
    )
}

/**
 * @see [VpcIpamScope].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIpamScope].
 */
public suspend fun vpcIpamScope(
    name: String,
    block: suspend VpcIpamScopeResourceBuilder.() -> Unit,
): VpcIpamScope {
    val builder = VpcIpamScopeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIpamScope].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIpamScope(name: String): VpcIpamScope {
    val builder = VpcIpamScopeResourceBuilder()
    builder.name(name)
    return builder.build()
}
