@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcIpv4CidrBlockAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to associate additional IPv4 CIDR blocks with a VPC.
 * When a VPC is created, a primary IPv4 CIDR block for the VPC must be specified.
 * The `aws.ec2.VpcIpv4CidrBlockAssociation` resource allows further IPv4 CIDR blocks to be added to the VPC.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
 * const secondaryCidr = new aws.ec2.VpcIpv4CidrBlockAssociation("secondary_cidr", {
 *     vpcId: main.id,
 *     cidrBlock: "172.20.0.0/16",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
 * secondary_cidr = aws.ec2.VpcIpv4CidrBlockAssociation("secondary_cidr",
 *     vpc_id=main.id,
 *     cidr_block="172.20.0.0/16")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.Vpc("main", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var secondaryCidr = new Aws.Ec2.VpcIpv4CidrBlockAssociation("secondary_cidr", new()
 *     {
 *         VpcId = main.Id,
 *         CidrBlock = "172.20.0.0/16",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpcIpv4CidrBlockAssociation(ctx, "secondary_cidr", &ec2.VpcIpv4CidrBlockAssociationArgs{
 * 			VpcId:     main.ID(),
 * 			CidrBlock: pulumi.String("172.20.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpcIpv4CidrBlockAssociation;
 * import com.pulumi.aws.ec2.VpcIpv4CidrBlockAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var secondaryCidr = new VpcIpv4CidrBlockAssociation("secondaryCidr", VpcIpv4CidrBlockAssociationArgs.builder()
 *             .vpcId(main.id())
 *             .cidrBlock("172.20.0.0/16")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *   secondaryCidr:
 *     type: aws:ec2:VpcIpv4CidrBlockAssociation
 *     name: secondary_cidr
 *     properties:
 *       vpcId: ${main.id}
 *       cidrBlock: 172.20.0.0/16
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_vpc_ipv4_cidr_block_association` using the VPC CIDR Association ID. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcIpv4CidrBlockAssociation:VpcIpv4CidrBlockAssociation example vpc-cidr-assoc-xxxxxxxx
 * ```
 * @property cidrBlock The IPv4 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv4_netmask_length`.
 * @property ipv4IpamPoolId The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
 * @property ipv4NetmaskLength The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a `ipv4_ipam_pool_id`.
 * @property vpcId The ID of the VPC to make the association with.
 */
public data class VpcIpv4CidrBlockAssociationArgs(
    public val cidrBlock: Output<String>? = null,
    public val ipv4IpamPoolId: Output<String>? = null,
    public val ipv4NetmaskLength: Output<Int>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcIpv4CidrBlockAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcIpv4CidrBlockAssociationArgs =
        com.pulumi.aws.ec2.VpcIpv4CidrBlockAssociationArgs.builder()
            .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
            .ipv4IpamPoolId(ipv4IpamPoolId?.applyValue({ args0 -> args0 }))
            .ipv4NetmaskLength(ipv4NetmaskLength?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcIpv4CidrBlockAssociationArgs].
 */
@PulumiTagMarker
public class VpcIpv4CidrBlockAssociationArgsBuilder internal constructor() {
    private var cidrBlock: Output<String>? = null

    private var ipv4IpamPoolId: Output<String>? = null

    private var ipv4NetmaskLength: Output<Int>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The IPv4 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv4_netmask_length`.
     */
    @JvmName("equbfrlcmxcndtpc")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
     */
    @JvmName("mrvubykxmarchbdl")
    public suspend fun ipv4IpamPoolId(`value`: Output<String>) {
        this.ipv4IpamPoolId = value
    }

    /**
     * @param value The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a `ipv4_ipam_pool_id`.
     */
    @JvmName("rqnptirigrcgfxmx")
    public suspend fun ipv4NetmaskLength(`value`: Output<Int>) {
        this.ipv4NetmaskLength = value
    }

    /**
     * @param value The ID of the VPC to make the association with.
     */
    @JvmName("wxwygmholmefgkvn")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The IPv4 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv4_netmask_length`.
     */
    @JvmName("nvrgtfmnetngdejn")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
     */
    @JvmName("juyqqarjhsfacten")
    public suspend fun ipv4IpamPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4IpamPoolId = mapped
    }

    /**
     * @param value The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a `ipv4_ipam_pool_id`.
     */
    @JvmName("ldptlasmiryidsac")
    public suspend fun ipv4NetmaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4NetmaskLength = mapped
    }

    /**
     * @param value The ID of the VPC to make the association with.
     */
    @JvmName("tvuoikllcogmcxla")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): VpcIpv4CidrBlockAssociationArgs = VpcIpv4CidrBlockAssociationArgs(
        cidrBlock = cidrBlock,
        ipv4IpamPoolId = ipv4IpamPoolId,
        ipv4NetmaskLength = ipv4NetmaskLength,
        vpcId = vpcId,
    )
}
