@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to associate additional IPv6 CIDR blocks with a VPC.
 * The `aws.ec2.VpcIpv6CidrBlockAssociation` resource allows IPv6 CIDR blocks to be added to the VPC.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.ec2.Vpc("test", {cidrBlock: "10.0.0.0/16"});
 * const testVpcIpv6CidrBlockAssociation = new aws.ec2.VpcIpv6CidrBlockAssociation("test", {
 *     ipv6IpamPoolId: testAwsVpcIpamPool.id,
 *     vpcId: test.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.ec2.Vpc("test", cidr_block="10.0.0.0/16")
 * test_vpc_ipv6_cidr_block_association = aws.ec2.VpcIpv6CidrBlockAssociation("test",
 *     ipv6_ipam_pool_id=test_aws_vpc_ipam_pool["id"],
 *     vpc_id=test.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Ec2.Vpc("test", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var testVpcIpv6CidrBlockAssociation = new Aws.Ec2.VpcIpv6CidrBlockAssociation("test", new()
 *     {
 *         Ipv6IpamPoolId = testAwsVpcIpamPool.Id,
 *         VpcId = test.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := ec2.NewVpc(ctx, "test", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewVpcIpv6CidrBlockAssociation(ctx, "test", &ec2.VpcIpv6CidrBlockAssociationArgs{
 * 			Ipv6IpamPoolId: pulumi.Any(testAwsVpcIpamPool.Id),
 * 			VpcId:          test.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociation;
 * import com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Vpc("test", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var testVpcIpv6CidrBlockAssociation = new VpcIpv6CidrBlockAssociation("testVpcIpv6CidrBlockAssociation", VpcIpv6CidrBlockAssociationArgs.builder()
 *             .ipv6IpamPoolId(testAwsVpcIpamPool.id())
 *             .vpcId(test.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *   testVpcIpv6CidrBlockAssociation:
 *     type: aws:ec2:VpcIpv6CidrBlockAssociation
 *     name: test
 *     properties:
 *       ipv6IpamPoolId: ${testAwsVpcIpamPool.id}
 *       vpcId: ${test.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_vpc_ipv6_cidr_block_association` using the VPC CIDR Association ID. For example:
 * ```sh
 * $ pulumi import aws:ec2/vpcIpv6CidrBlockAssociation:VpcIpv6CidrBlockAssociation example vpc-cidr-assoc-xxxxxxxx
 * ```
 * @property assignGeneratedIpv6CidrBlock Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IPv6 addresses, or the size of the CIDR block. Default is `false`. Conflicts with `ipv6_pam_pool_id`, `ipv6_pool`, `ipv6_cidr_block` and `ipv6_netmask_length`.
 * @property ipv6CidrBlock The IPv6 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv6_netmask_length`. This parameter is required if `ipv6_netmask_length` is not set and the IPAM pool does not have `allocation_default_netmask` set. Conflicts with `assign_generated_ipv6_cidr_block`.
 * @property ipv6IpamPoolId - (Optional) The ID of an IPv6 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Conflict with `assign_generated_ipv6_cidr_block` and `ipv6_ipam_pool_id`.
 * @property ipv6NetmaskLength The netmask length of the IPv6 CIDR you want to allocate to this VPC. Requires specifying a `ipv6_ipam_pool_id`. This parameter is optional if the IPAM pool has `allocation_default_netmask` set, otherwise it or `ipv6_cidr_block` are required. Conflicts with `assign_generated_ipv6_cidr_block` and `ipv6_ipam_pool_id`.
 * @property ipv6Pool The  ID of an IPv6 address pool from which to allocate the IPv6 CIDR block. Conflicts with `ipv6_pam_pool_id`, `ipv6_pool`.
 * @property vpcId The ID of the VPC to make the association with.
 */
public data class VpcIpv6CidrBlockAssociationArgs(
    public val assignGeneratedIpv6CidrBlock: Output<Boolean>? = null,
    public val ipv6CidrBlock: Output<String>? = null,
    public val ipv6IpamPoolId: Output<String>? = null,
    public val ipv6NetmaskLength: Output<Int>? = null,
    public val ipv6Pool: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociationArgs =
        com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociationArgs.builder()
            .assignGeneratedIpv6CidrBlock(assignGeneratedIpv6CidrBlock?.applyValue({ args0 -> args0 }))
            .ipv6CidrBlock(ipv6CidrBlock?.applyValue({ args0 -> args0 }))
            .ipv6IpamPoolId(ipv6IpamPoolId?.applyValue({ args0 -> args0 }))
            .ipv6NetmaskLength(ipv6NetmaskLength?.applyValue({ args0 -> args0 }))
            .ipv6Pool(ipv6Pool?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcIpv6CidrBlockAssociationArgs].
 */
@PulumiTagMarker
public class VpcIpv6CidrBlockAssociationArgsBuilder internal constructor() {
    private var assignGeneratedIpv6CidrBlock: Output<Boolean>? = null

    private var ipv6CidrBlock: Output<String>? = null

    private var ipv6IpamPoolId: Output<String>? = null

    private var ipv6NetmaskLength: Output<Int>? = null

    private var ipv6Pool: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IPv6 addresses, or the size of the CIDR block. Default is `false`. Conflicts with `ipv6_pam_pool_id`, `ipv6_pool`, `ipv6_cidr_block` and `ipv6_netmask_length`.
     */
    @JvmName("dugrqchjlybmkkvd")
    public suspend fun assignGeneratedIpv6CidrBlock(`value`: Output<Boolean>) {
        this.assignGeneratedIpv6CidrBlock = value
    }

    /**
     * @param value The IPv6 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv6_netmask_length`. This parameter is required if `ipv6_netmask_length` is not set and the IPAM pool does not have `allocation_default_netmask` set. Conflicts with `assign_generated_ipv6_cidr_block`.
     */
    @JvmName("golkicoeimwapjhx")
    public suspend fun ipv6CidrBlock(`value`: Output<String>) {
        this.ipv6CidrBlock = value
    }

    /**
     * @param value - (Optional) The ID of an IPv6 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Conflict with `assign_generated_ipv6_cidr_block` and `ipv6_ipam_pool_id`.
     */
    @JvmName("alodhksgliejbugk")
    public suspend fun ipv6IpamPoolId(`value`: Output<String>) {
        this.ipv6IpamPoolId = value
    }

    /**
     * @param value The netmask length of the IPv6 CIDR you want to allocate to this VPC. Requires specifying a `ipv6_ipam_pool_id`. This parameter is optional if the IPAM pool has `allocation_default_netmask` set, otherwise it or `ipv6_cidr_block` are required. Conflicts with `assign_generated_ipv6_cidr_block` and `ipv6_ipam_pool_id`.
     */
    @JvmName("qobenbmpueykmjea")
    public suspend fun ipv6NetmaskLength(`value`: Output<Int>) {
        this.ipv6NetmaskLength = value
    }

    /**
     * @param value The  ID of an IPv6 address pool from which to allocate the IPv6 CIDR block. Conflicts with `ipv6_pam_pool_id`, `ipv6_pool`.
     */
    @JvmName("puqqcgaxwpmhpufr")
    public suspend fun ipv6Pool(`value`: Output<String>) {
        this.ipv6Pool = value
    }

    /**
     * @param value The ID of the VPC to make the association with.
     */
    @JvmName("rnrpnrtglpvwbbut")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IPv6 addresses, or the size of the CIDR block. Default is `false`. Conflicts with `ipv6_pam_pool_id`, `ipv6_pool`, `ipv6_cidr_block` and `ipv6_netmask_length`.
     */
    @JvmName("bgomnxdnuoqpdvti")
    public suspend fun assignGeneratedIpv6CidrBlock(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignGeneratedIpv6CidrBlock = mapped
    }

    /**
     * @param value The IPv6 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv6_netmask_length`. This parameter is required if `ipv6_netmask_length` is not set and the IPAM pool does not have `allocation_default_netmask` set. Conflicts with `assign_generated_ipv6_cidr_block`.
     */
    @JvmName("jwjtwppxfsaylred")
    public suspend fun ipv6CidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlock = mapped
    }

    /**
     * @param value - (Optional) The ID of an IPv6 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Conflict with `assign_generated_ipv6_cidr_block` and `ipv6_ipam_pool_id`.
     */
    @JvmName("prbwhortfkyrdeng")
    public suspend fun ipv6IpamPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6IpamPoolId = mapped
    }

    /**
     * @param value The netmask length of the IPv6 CIDR you want to allocate to this VPC. Requires specifying a `ipv6_ipam_pool_id`. This parameter is optional if the IPAM pool has `allocation_default_netmask` set, otherwise it or `ipv6_cidr_block` are required. Conflicts with `assign_generated_ipv6_cidr_block` and `ipv6_ipam_pool_id`.
     */
    @JvmName("gbxhqbpuaihlsvbp")
    public suspend fun ipv6NetmaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6NetmaskLength = mapped
    }

    /**
     * @param value The  ID of an IPv6 address pool from which to allocate the IPv6 CIDR block. Conflicts with `ipv6_pam_pool_id`, `ipv6_pool`.
     */
    @JvmName("gwnpigxqlfmlbjgj")
    public suspend fun ipv6Pool(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Pool = mapped
    }

    /**
     * @param value The ID of the VPC to make the association with.
     */
    @JvmName("tsmcdakkkcfsqpby")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): VpcIpv6CidrBlockAssociationArgs = VpcIpv6CidrBlockAssociationArgs(
        assignGeneratedIpv6CidrBlock = assignGeneratedIpv6CidrBlock,
        ipv6CidrBlock = ipv6CidrBlock,
        ipv6IpamPoolId = ipv6IpamPoolId,
        ipv6NetmaskLength = ipv6NetmaskLength,
        ipv6Pool = ipv6Pool,
        vpcId = vpcId,
    )
}
